/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.conversation;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.scamshield.conversation.ConversationStage;
import java.util.ArrayList;
import java.util.List;

public class SequencePatternDetector {
    private static final List<SequencePattern> DANGEROUS_PATTERNS = new ArrayList<SequencePattern>();

    public static List<DetectedPattern> analyzeSequence(List<String> tacticSequence) {
        ArrayList<DetectedPattern> detected = new ArrayList<DetectedPattern>();
        for (SequencePattern pattern : DANGEROUS_PATTERNS) {
            MatchResult match = pattern.matches(tacticSequence);
            if (!match.isMatch()) continue;
            detected.add(new DetectedPattern(pattern.name, pattern.bonus, pattern.stage, match.matchedIndices));
            PackCore.LOGGER.warn("[ScamShield] Detected dangerous sequence: {} (bonus: +{})", (Object)pattern.name, (Object)pattern.bonus);
        }
        return detected;
    }

    static {
        DANGEROUS_PATTERNS.add(new SequencePattern("Discord Verification Scam", List.of("trust_building", "discord_mention", "verification_request", "credential_fishing"), 150, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Direct Credential Phishing", List.of("discord_mention", "verification_request", "credential_fishing"), 120, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Island Theft Progression", List.of("trust_building", "quitting_claim", "coop_command"), 140, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Staff Impersonation Scam", List.of("authority", "urgency", "credential_fishing"), 160, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Trust Exploitation Pattern", List.of("trust_building", "urgency", "credential_fishing"), 130, ConversationStage.PRESSURE));
        DANGEROUS_PATTERNS.add(new SequencePattern("Reward Bait Scam", List.of("free_promise", "visit_command", "credential_fishing"), 125, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Off-Platform Verification", List.of("discord_mention", "technical_excuse", "verification_request"), 115, ConversationStage.TRANSITION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Target Assessment Scam", List.of("wealth_inquiry", "trust_building", "credential_fishing"), 135, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Quitting Island Theft", List.of("quitting_claim", "coop_command", "visit_command"), 145, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Flex Payment Scam", List.of("trade_manipulation", "command_instruction", "reciprocity"), 140, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Free Rank to Coin Theft", List.of("free_promise", "command_instruction", "discord_transition", "wealth_inquiry"), 155, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Tournament Verification Scam", List.of("tournament_bait", "urgency", "discord_transition", "verification_request"), 150, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Fake Accident Auction Scam", List.of("fake_accident", "urgency", "specific_valuables"), 130, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Crafting Material Theft", List.of("crafting_help", "trust_building", "specific_valuables"), 125, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Party to VC Verification", List.of("discord_transition", "technical_excuse", "verification_request", "credential_fishing"), 165, ConversationStage.EXPLOITATION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Immediate Command Request", List.of("command_instruction", "free_promise"), 110, ConversationStage.TRANSITION));
        DANGEROUS_PATTERNS.add(new SequencePattern("Wealth Assessment to Scam", List.of("wealth_inquiry", "wealth_inquiry", "trade_manipulation"), 140, ConversationStage.EXPLOITATION));
    }

    private static class SequencePattern {
        final String name;
        final List<String> requiredSequence;
        final int bonus;
        final ConversationStage stage;

        SequencePattern(String name, List<String> requiredSequence, int bonus, ConversationStage stage) {
            this.name = name;
            this.requiredSequence = requiredSequence;
            this.bonus = bonus;
            this.stage = stage;
        }

        MatchResult matches(List<String> tacticSequence) {
            ArrayList<Integer> matchedIndices = new ArrayList<Integer>();
            int patternIndex = 0;
            for (int i = 0; i < tacticSequence.size() && patternIndex < this.requiredSequence.size(); ++i) {
                String requiredTactic = this.requiredSequence.get(patternIndex);
                String actualTactic = tacticSequence.get(i);
                if (!actualTactic.equals(requiredTactic) && !actualTactic.contains(requiredTactic) && !requiredTactic.contains(actualTactic)) continue;
                matchedIndices.add(i);
                ++patternIndex;
            }
            boolean isMatch = patternIndex == this.requiredSequence.size();
            return new MatchResult(isMatch, matchedIndices);
        }
    }

    private static class MatchResult {
        final boolean isMatch;
        final List<Integer> matchedIndices;

        MatchResult(boolean isMatch, List<Integer> matchedIndices) {
            this.isMatch = isMatch;
            this.matchedIndices = matchedIndices;
        }

        boolean isMatch() {
            return this.isMatch;
        }
    }

    public static class DetectedPattern {
        private final String name;
        private final int bonus;
        private final ConversationStage stage;
        private final List<Integer> matchedIndices;

        public DetectedPattern(String name, int bonus, ConversationStage stage, List<Integer> matchedIndices) {
            this.name = name;
            this.bonus = bonus;
            this.stage = stage;
            this.matchedIndices = matchedIndices;
        }

        public String getName() {
            return this.name;
        }

        public int getBonus() {
            return this.bonus;
        }

        public ConversationStage getStage() {
            return this.stage;
        }

        public List<Integer> getMatchedIndices() {
            return this.matchedIndices;
        }
    }
}

