/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector;

public enum ConfidenceLevel {
    LOW(90, 129, "Low", "\u00a7e", false),
    MEDIUM(130, 159, "Medium", "\u00a76", false),
    HIGH(160, Integer.MAX_VALUE, "High", "\u00a7c", true);

    private final int minScore;
    private final int maxScore;
    private final String displayName;
    private final String colorCode;
    private final boolean forceScreen;

    private ConfidenceLevel(int minScore, int maxScore, String displayName, String colorCode, boolean forceScreen) {
        this.minScore = minScore;
        this.maxScore = maxScore;
        this.displayName = displayName;
        this.colorCode = colorCode;
        this.forceScreen = forceScreen;
    }

    public static ConfidenceLevel fromScore(int score) {
        for (ConfidenceLevel level : ConfidenceLevel.values()) {
            if (score < level.minScore || score > level.maxScore) continue;
            return level;
        }
        return LOW;
    }

    public int getMinScore() {
        return this.minScore;
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public boolean shouldForceScreen() {
        return this.forceScreen;
    }

    public boolean shouldSuggestWhitelist() {
        return this == LOW;
    }
}

