/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.pattern;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AhoCorasickMatcher {
    private final TrieNode root = new TrieNode();
    private boolean compiled = false;

    public void addPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return;
        }
        TrieNode node = this.root;
        for (char c : pattern.toCharArray()) {
            TrieNode finalNode = node;
            node = node.children.computeIfAbsent(Character.valueOf(c), k -> {
                TrieNode child = new TrieNode();
                child.depth = finalNode.depth + 1;
                return child;
            });
        }
        node.patterns.add(pattern);
        this.compiled = false;
    }

    private void buildFailureLinks() {
        ArrayDeque<TrieNode> queue = new ArrayDeque<TrieNode>();
        this.root.failure = this.root;
        for (TrieNode child : this.root.children.values()) {
            child.failure = this.root;
            queue.offer(child);
        }
        while (!queue.isEmpty()) {
            TrieNode current = (TrieNode)queue.poll();
            for (Map.Entry<Character, TrieNode> entry : current.children.entrySet()) {
                char c = entry.getKey().charValue();
                TrieNode child = entry.getValue();
                queue.offer(child);
                TrieNode failure = current.failure;
                while (failure != this.root && !failure.children.containsKey(Character.valueOf(c))) {
                    failure = failure.failure;
                }
                child.failure = failure.children.getOrDefault(Character.valueOf(c), this.root);
                child.patterns.addAll(child.failure.patterns);
            }
        }
    }

    public Set<String> findMatches(String text) {
        if (text == null || text.isEmpty()) {
            return Collections.emptySet();
        }
        if (!this.compiled) {
            this.buildFailureLinks();
            this.compiled = true;
        }
        HashSet<String> matches = new HashSet<String>();
        TrieNode current = this.root;
        for (char c : text.toCharArray()) {
            while (current != this.root && !current.children.containsKey(Character.valueOf(c))) {
                current = current.failure;
            }
            if (!current.children.containsKey(Character.valueOf(c))) continue;
            current = current.children.get(Character.valueOf(c));
            matches.addAll(current.patterns);
        }
        return matches;
    }

    public int countMatches(String text) {
        return this.findMatches(text).size();
    }

    static class TrieNode {
        final Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
        TrieNode failure;
        final Set<String> patterns = new HashSet<String>();
        int depth = 0;

        TrieNode() {
        }
    }
}

