/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.types;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.context.ConversationContext;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.types.ScamType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandInstructionScam
implements ScamType {
    private boolean enabled = true;
    private static final Pattern COMMAND_INSTRUCTION = Pattern.compile("\\b(do|type|run|use|enter)?\\s*(/visit|/party|/p|/coopadd|/coop|/trade|visit|party|coopadd)\\s+(me|\\w+)", 2);
    private static final Pattern COMMAND_WITH_REWARD = Pattern.compile("\\b(to (receive|get|claim|win)).*?(/visit|/party|/p|/coopadd|visit|party)", 2);

    @Override
    public String getId() {
        return "command_instruction_scam";
    }

    @Override
    public String getDisplayName() {
        return "Command Instruction";
    }

    @Override
    public void analyze(String message, String rawMessage, String sender, ConversationContext context, DetectionResult.Builder result) {
        Matcher rewardMatcher;
        if (!this.enabled) {
            return;
        }
        int score = 0;
        String lower = message.toLowerCase();
        boolean tradeOrPromoContext = lower.matches(".*\\b(wts|wtb|wtt|selling|buying|trade|trading|visit my island|visit me for|lowball|lowballing|lb|lbing)\\b.*") || lower.contains("youtube") || lower.contains("subscriber") || lower.contains("series") || lower.contains("hype") || lower.matches(".*\\d+[mkb].*");
        Matcher commandMatcher = COMMAND_INSTRUCTION.matcher(message);
        if (commandMatcher.find()) {
            String command = commandMatcher.group(2).toLowerCase();
            if (command.contains("coop")) {
                score += 100;
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield]   Co-op command instruction: +100 points");
                }
            } else if (command.contains("visit")) {
                int visitPenalty = tradeOrPromoContext ? 5 : 15;
                score += visitPenalty;
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield]   Visit command instruction: +{} points (promoContext={})", (Object)visitPenalty, (Object)tradeOrPromoContext);
                }
            } else if (command.contains("party") || command.contains("trade")) {
                int penalty = tradeOrPromoContext ? 5 : 10;
                score += penalty;
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield]   Party/Trade command instruction: +{} points (promoContext={})", (Object)penalty, (Object)tradeOrPromoContext);
                }
            }
        }
        if ((rewardMatcher = COMMAND_WITH_REWARD.matcher(message)).find()) {
            score += 45;
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield]   Command with reward promise: +45 points");
            }
        }
        int commandCount = 0;
        if (lower.contains("/visit") || lower.contains("visit me")) {
            ++commandCount;
        }
        if (lower.contains("/party") || lower.contains("/p ")) {
            ++commandCount;
        }
        if (lower.contains("/coopadd") || lower.contains("coopadd")) {
            ++commandCount;
        }
        if (lower.contains("/trade")) {
            ++commandCount;
        }
        if (commandCount >= 2) {
            score += 35;
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield]   Multiple commands in message: +35 points");
            }
        }
        if ((lower.contains("denycoop") || lower.contains("deny coop") || lower.contains("clear it out") || lower.contains("to clear")) && (lower.contains("coopadd") || lower.contains("coop"))) {
            score += 60;
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield]   Fake co-op command variant: +60 points");
            }
        }
        if (lower.contains("do /") || lower.contains("type /") || lower.contains("run /") || lower.contains("use /") || lower.contains("enter /")) {
            int impPenalty = tradeOrPromoContext ? 5 : 20;
            score += impPenalty;
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield]   Imperative command language: +{} points (promoContext={})", (Object)impPenalty, (Object)tradeOrPromoContext);
            }
        }
        if (rawMessage != null && rawMessage.toUpperCase().equals(rawMessage) && (rawMessage.contains("/VISIT") || rawMessage.contains("/PARTY") || rawMessage.contains("/COOPADD") || rawMessage.contains("VISIT ME"))) {
            score += 15;
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield]   ALL CAPS command: +15 points");
            }
        }
        if (score > 0) {
            result.addScamTypeContribution(this.getId(), score);
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] {} detected: +{} points", (Object)this.getDisplayName(), (Object)score);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

