/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.components;

import com.github.kd_gaming1.packcore.ui.surface.effects.TextureSurfaces;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4185;

public class ScreenUIComponents {
    public static FlowLayout createSidebar(int widthPercent) {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)widthPercent), (Sizing)Sizing.expand()).gap(8).surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/notif_box.png"), 607, 755)).padding(Insets.of((int)12));
    }

    public static FlowLayout createInfoPanel(int widthPercent) {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)widthPercent), (Sizing)Sizing.expand()).gap(8).surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/info_box.png"), 1142, 934)).padding(Insets.of((int)14));
    }

    public static FlowLayout createSection(String title, int expandPercent) {
        Sizing verticalSizing = expandPercent > 0 ? Sizing.expand((int)expandPercent) : Sizing.content();
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)verticalSizing).gap(4).surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-18355))).padding(Insets.of((int)8));
        if (title != null) {
            section.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-1)));
        }
        return section;
    }

    public static FlowLayout createInfoRow(String label, String value) {
        FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8);
        row.child(Components.label((class_2561)class_2561.method_43470((String)label)).color(UITheme.color(-5195576)).sizing(Sizing.fixed((int)80), Sizing.content()));
        row.child(Components.label((class_2561)class_2561.method_43470((String)value)).color(UITheme.color(-1)).horizontalSizing(Sizing.expand()));
        return row;
    }

    public static FlowLayout createInfoBox() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-11184811))).padding(Insets.of((int)8));
    }

    public static FlowLayout createStatusCard(String icon, String title, String message, int bgColor, int borderColor) {
        FlowLayout card = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).surface(Surface.flat((int)bgColor).and(Surface.outline((int)borderColor))).padding(Insets.of((int)12));
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
        if (icon != null) {
            header.child((Component)Components.label((class_2561)class_2561.method_43470((String)icon)).color(UITheme.color(borderColor)));
        }
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-1)));
        card.child((Component)header);
        if (message != null) {
            LabelComponent msg = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-5195576)).horizontalSizing(Sizing.fill((int)95));
            card.child((Component)msg);
        }
        return card;
    }

    public static FlowLayout createSuccessCard(String title, String message) {
        return ScreenUIComponents.createStatusCard("\u2713", title, message, -535147218, -15681151);
    }

    public static FlowLayout createWarningCard(String title, String message) {
        return ScreenUIComponents.createStatusCard("\u26a0", title, message, -528993009, -680437);
    }

    public static FlowLayout createErrorCard(String title, String message) {
        return ScreenUIComponents.createStatusCard("\u2717", title, message, -528540387, -1096636);
    }

    public static ButtonComponent createButton(String text, class_4185.class_4241 action) {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)text), arg_0 -> ((class_4185.class_4241)action).onPress(arg_0)).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20));
    }

    public static ButtonComponent createButton(String text, class_4185.class_4241 action, int width, int height) {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)text), arg_0 -> ((class_4185.class_4241)action).onPress(arg_0)).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)width, (int)(height * 3))).sizing(Sizing.fixed((int)width), Sizing.fixed((int)height));
    }

    public static FlowLayout createButtonRow(ButtonComponent ... buttons) {
        FlowLayout row = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER);
        for (ButtonComponent button : buttons) {
            row.child((Component)button);
        }
        return row;
    }

    public static FlowLayout createListEntry() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content()).gap(2).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811))).padding(Insets.of((int)6));
    }

    public static void applyHoverEffects(FlowLayout entry, Runnable onSelect) {
        entry.mouseEnter().subscribe(() -> entry.surface(Surface.flat((int)-1069925830).and(Surface.outline((int)-18355))));
        entry.mouseLeave().subscribe(() -> entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811))));
        if (onSelect != null) {
            entry.mouseDown().subscribe((x, y, button) -> {
                if (button == 0) {
                    onSelect.run();
                    return true;
                }
                return false;
            });
            entry.cursorStyle(CursorStyle.HAND);
        }
    }

    public static void applySelectedState(FlowLayout entry, boolean selected) {
        if (selected) {
            entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-18355)));
        } else {
            entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
        }
    }

    public static FlowLayout createDialog(String title, String message, int width) {
        FlowLayout dialog = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)width), (Sizing)Sizing.content()).gap(12).surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-18355))).padding(Insets.of((int)20)).positioning(Positioning.relative((int)50, (int)40));
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        if (message != null) {
            LabelComponent msg = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)100));
            dialog.child((Component)msg);
        }
        return dialog;
    }

    public static FlowLayout createWarningDialog(String title, String message, int width) {
        FlowLayout dialog = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)width), (Sizing)Sizing.content()).gap(12).surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-680437))).padding(Insets.of((int)20)).positioning(Positioning.relative((int)50, (int)40));
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        header.child(Components.label((class_2561)class_2561.method_43470((String)"\u26a0")).color(UITheme.color(-680437)).sizing(Sizing.fixed((int)24), Sizing.content()));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-680437)));
        dialog.child((Component)header);
        if (message != null) {
            LabelComponent msg = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)100));
            dialog.child((Component)msg);
        }
        return dialog;
    }

    public static ScrollContainer<FlowLayout> createScrollContainer(FlowLayout content) {
        ScrollContainer scroll = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)content);
        scroll.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scroll.scrollbarThiccness(6);
        return scroll;
    }

    public static ScrollContainer<FlowLayout> createScrollBoxHorizontal(FlowLayout content) {
        ScrollContainer scroll = Containers.horizontalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)content);
        scroll.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scroll.scrollbarThiccness(6);
        return scroll;
    }

    public static FlowLayout createEmptyState(String message) {
        FlowLayout empty = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        empty.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-5195576)));
        return empty;
    }

    public static String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    public static String formatTimestamp(String isoTimestamp) {
        try {
            return isoTimestamp.replace('T', ' ').substring(0, Math.min(isoTimestamp.length(), 19));
        }
        catch (Exception e) {
            return isoTimestamp;
        }
    }

    public static String stripMarkdown(String text) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("\\{[^}]*}", "");
        text = text.replaceAll("\\*\\*", "");
        text = text.replaceAll("^#+\\s*", "");
        text = text.replaceAll("\\[([^]]+)]\\([^)]+\\)", "$1");
        text = text.replaceAll("_", "");
        text = text.replaceAll("`", "");
        return text.trim();
    }
}

