/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.components;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.lavendermd.CustomLavenderCompiler;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class WizardUIComponents {
    private static final MarkdownProcessor<ParentComponent> MARKDOWN_PROCESSOR = new MarkdownProcessor(CustomLavenderCompiler::new, new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature(), new ImageFeature()});
    private static final Map<String, ParentComponent> MARKDOWN_CACHE = new ConcurrentHashMap<String, ParentComponent>();
    private static final ModpackInfo MODPACK_INFO = PackCore.getModpackInfo();

    public static FlowLayout createHeader(String titlePrefix, String subtitle) {
        return WizardUIComponents.createHeader(titlePrefix, subtitle, true);
    }

    public static FlowLayout createHeader(String titlePrefix, String subtitle, boolean includeModpackName) {
        FlowLayout header = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6);
        class_5250 titleText = includeModpackName ? TextOps.concat((class_2561)TextOps.withColor((String)(titlePrefix + " "), (int)-1), (class_2561)class_2561.method_43470((String)MODPACK_INFO.getName()).method_10862(class_2583.field_24360.method_36139(-18355).method_10982(Boolean.valueOf(true)))) : TextOps.withColor((String)titlePrefix, (int)-1);
        header.child((Component)Components.label((class_2561)titleText).shadow(true));
        if (subtitle != null && !subtitle.isEmpty()) {
            LabelComponent subtitleLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)subtitle).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)))).color(Color.ofRgb((int)-5195576)).margins(Insets.of((int)2, (int)0, (int)2, (int)0)).sizing(Sizing.expand(), Sizing.content());
            header.child((Component)subtitleLabel);
        }
        return header;
    }

    public static FlowLayout createSelectionCard(boolean isSelected, Consumer<FlowLayout> onClick) {
        int borderColor = isSelected ? -15681151 : 0x40FFFFFF;
        FlowLayout card = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).surface(Surface.outline((int)borderColor)).padding(Insets.of((int)12)).cursorStyle(CursorStyle.HAND);
        if (onClick != null) {
            card.mouseDown().subscribe((x, y, button) -> {
                onClick.accept(card);
                return true;
            });
        }
        return card;
    }

    public static ScrollContainer<FlowLayout> createMarkdownScroll(String content) {
        FlowLayout wrapper = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4);
        Component markdownComponent = MARKDOWN_CACHE.computeIfAbsent(content, arg_0 -> MARKDOWN_PROCESSOR.process(arg_0)).horizontalSizing(Sizing.fill((int)98));
        wrapper.child(markdownComponent);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)wrapper);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)8));
        return scrollContainer;
    }

    public static LabelComponent createStatusLabel(String text, String icon, int color) {
        String displayText = icon != null ? icon + " " + text : text;
        return (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)displayText).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)color)).horizontalSizing(Sizing.fill((int)100));
    }

    public static FlowLayout createInfoCard(String title, String description, int bgColor, int borderColor) {
        FlowLayout card = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)bgColor).and(Surface.outline((int)borderColor))).padding(Insets.of((int)8)).margins(Insets.of((int)6, (int)0, (int)6, (int)6));
        if (title != null) {
            card.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)borderColor)));
        }
        if (description != null) {
            LabelComponent desc = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)description)).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)95));
            card.child((Component)desc);
        }
        return card;
    }

    public static FlowLayout createOptionBox(String icon, String title, String description, boolean isSelected, Consumer<FlowLayout> onClick) {
        FlowLayout card = WizardUIComponents.createSelectionCard(isSelected, onClick);
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        if (icon != null) {
            header.child((Component)Components.label((class_2561)class_2561.method_43470((String)icon)).color(Color.ofRgb((int)-18355)));
        }
        header.child(Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)).horizontalSizing(Sizing.expand()));
        card.child((Component)header);
        if (description != null) {
            LabelComponent desc = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)description)).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)100));
            card.child((Component)desc);
        }
        return card;
    }

    public static LabelComponent createProgressStepLabel(String stepName, ProgressStatus status) {
        String icon = switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "\u2705";
            case 1 -> "\u274c";
            case 2 -> "\u23f3";
            case 3 -> "\u23f8";
        };
        class_124 color = switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_124.field_1060;
            case 1 -> class_124.field_1061;
            case 2 -> class_124.field_1054;
            case 3 -> class_124.field_1080;
        };
        return (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)(icon + " " + stepName)).method_10862(class_2583.field_24360.method_10977(color))).margins(Insets.left((int)8));
    }

    public static FlowLayout createSummaryItem(String label, String value) {
        FlowLayout item = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).margins(Insets.vertical((int)2));
        item.child((Component)Components.label((class_2561)class_2561.method_43470((String)label)).color(Color.ofRgb((int)-1)));
        if (value != null) {
            LabelComponent valueLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)value)).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.expand());
            item.child((Component)valueLabel);
        }
        return item;
    }

    public static FlowLayout createImageOption(String title, String texturePath, int textureWidth, int textureHeight, boolean isSelected, Runnable onClick) {
        FlowLayout wrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)32), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)8)).cursorStyle(CursorStyle.HAND);
        wrapper.child((Component)Components.label((class_2561)TextOps.withColor((String)title, (int)-1).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).margins(Insets.of((int)4, (int)4, (int)2, (int)4)));
        class_2960 textureId = class_2960.method_60655((String)"packcore", (String)texturePath);
        Surface imageSurface = isSelected ? Surface.outline((int)-15681151).and(Surface.tiled((class_2960)textureId, (int)textureWidth, (int)textureHeight)) : Surface.tiled((class_2960)textureId, (int)textureWidth, (int)textureHeight);
        FlowLayout imageContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(imageSurface).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
        if (onClick != null) {
            imageContainer.mouseDown().subscribe((x, y, button) -> {
                onClick.run();
                return true;
            });
        }
        wrapper.child((Component)imageContainer);
        return wrapper;
    }

    public static enum ProgressStatus {
        SUCCESS,
        ERROR,
        RUNNING,
        PENDING;

    }
}

