/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.configmanager;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.backup.BackupManager;
import com.github.kd_gaming1.packcore.notification.BackupNotifications;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ConfigManagerScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.SelectiveFileApplicationScreen;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class BackupManagementScreen
extends BasePackCoreScreen {
    private BackupManager.BackupInfo selectedBackup = null;
    private FlowLayout infoPanel;
    private FlowLayout sidebarContent;
    private final Map<BackupManager.BackupInfo, FlowLayout> entryComponents = new HashMap<BackupManager.BackupInfo, FlowLayout>();
    private FlowLayout progressDialog = null;
    private LabelComponent progressLabel = null;
    private volatile boolean operationInBackground = false;
    private volatile String currentOperationName = "";
    private volatile boolean isRestoreOperation = false;

    public BackupManagementScreen() {
        super((class_437)new ConfigManagerScreen());
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)("Backup Manager - " + PackCore.getModpackInfo().getName())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(-1));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createInfoPanel());
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = ScreenUIComponents.createSidebar(35);
        sidebar.child(this.createInfoText());
        this.sidebarContent = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(8);
        sidebar.child(ScreenUIComponents.createScrollContainer(this.sidebarContent));
        sidebar.child((Component)this.createSidebarButtons());
        this.rebuildSidebarContent();
        return sidebar;
    }

    private Component createInfoText() {
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        int padding = guiScale <= 2 ? 16 : 8;
        FlowLayout container = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)padding, (int)0, (int)padding, (int)0));
        LabelComponent infoLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Manage your configuration backups. Auto backups are created before applying new configs.")).color(UITheme.color(-1)).sizing(Sizing.fill((int)95), Sizing.content());
        container.child((Component)infoLabel);
        return container;
    }

    private void rebuildSidebarContent() {
        this.sidebarContent.clearChildren();
        this.entryComponents.clear();
        this.sidebarContent.child((Component)ScreenUIComponents.createEmptyState("Loading backups..."));
        BackupManager.getBackupsAsync().thenAccept(allBackups -> class_310.method_1551().execute(() -> {
            this.sidebarContent.clearChildren();
            List<BackupManager.BackupInfo> manualBackups = allBackups.stream().filter(b -> b.type() == BackupManager.BackupType.MANUAL).toList();
            List<BackupManager.BackupInfo> autoBackups = allBackups.stream().filter(b -> b.type() == BackupManager.BackupType.AUTO).toList();
            this.sidebarContent.child((Component)this.createBackupSection("Manual Backups", manualBackups, true));
            this.sidebarContent.child((Component)this.createBackupSection("Auto Backups", autoBackups, false));
        }));
    }

    private FlowLayout createBackupSection(String title, List<BackupManager.BackupInfo> backups, boolean isManual) {
        FlowLayout section = ScreenUIComponents.createSection(title, isManual ? 45 : 50);
        section.horizontalSizing(Sizing.fill((int)98));
        FlowLayout listContent = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2);
        if (backups.isEmpty()) {
            listContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No backups found")).color(UITheme.color(-5195576)));
        } else {
            for (BackupManager.BackupInfo backup : backups) {
                listContent.child((Component)this.createBackupEntry(backup));
            }
        }
        section.child(ScreenUIComponents.createScrollContainer(listContent));
        return section;
    }

    private FlowLayout createBackupEntry(BackupManager.BackupInfo backup) {
        FlowLayout entry = ScreenUIComponents.createListEntry();
        String displayTitle = backup.title() != null && !backup.title().isEmpty() ? backup.title() : backup.configName();
        entry.child((Component)Components.label((class_2561)class_2561.method_43470((String)displayTitle)).color(UITheme.color(-1)));
        FlowLayout badges = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)backup.type().getDisplayName())).color(UITheme.color(backup.type() == BackupManager.BackupType.MANUAL ? -15681151 : -680437)));
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)("v" + backup.configVersion()))).color(UITheme.color(-5195576)));
        entry.child((Component)badges);
        this.entryComponents.put(backup, entry);
        ScreenUIComponents.applyHoverEffects(entry, () -> this.selectBackup(backup));
        return entry;
    }

    private FlowLayout createSidebarButtons() {
        FlowLayout buttonRow = (FlowLayout)Containers.ltrTextFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.child(ScreenUIComponents.createButton("Create Backup", btn -> this.showCreateBackupDialog(), 90, 19).margins(Insets.bottom((int)4)));
        buttonRow.child(ScreenUIComponents.createButton("Open Folder", btn -> BackupManager.openBackupsFolder(), 90, 19).margins(Insets.bottom((int)4)));
        buttonRow.child(ScreenUIComponents.createButton("Refresh", btn -> this.refreshBackupsList(), 90, 19).margins(Insets.bottom((int)4)));
        return buttonRow;
    }

    private FlowLayout createInfoPanel() {
        this.infoPanel = ScreenUIComponents.createInfoPanel(65);
        this.showEmptyState();
        return this.infoPanel;
    }

    private void showEmptyState() {
        this.infoPanel.clearChildren();
        this.infoPanel.child((Component)ScreenUIComponents.createEmptyState("Select a backup to view details"));
    }

    private void selectBackup(BackupManager.BackupInfo backup) {
        if (this.selectedBackup != null && this.entryComponents.containsKey(this.selectedBackup)) {
            ScreenUIComponents.applySelectedState(this.entryComponents.get(this.selectedBackup), false);
        }
        this.selectedBackup = backup;
        if (this.entryComponents.containsKey(backup)) {
            ScreenUIComponents.applySelectedState(this.entryComponents.get(backup), true);
        }
        this.showBackupDetails();
    }

    private void showBackupDetails() {
        if (this.selectedBackup == null) {
            return;
        }
        this.infoPanel.clearChildren();
        this.infoPanel.horizontalAlignment(HorizontalAlignment.LEFT);
        this.infoPanel.verticalAlignment(VerticalAlignment.TOP);
        int padding = (Integer)class_310.method_1551().field_1690.method_42474().method_41753() <= 2 ? 6 : 0;
        String headerText = this.selectedBackup.title() != null && !this.selectedBackup.title().isEmpty() ? this.selectedBackup.title() : this.selectedBackup.configName();
        this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)headerText).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)).margins(Insets.of((int)padding, (int)0, (int)0, (int)0)));
        FlowLayout infoBox = ScreenUIComponents.createInfoBox();
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Type:", this.selectedBackup.type().getDisplayName()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Config:", this.selectedBackup.configName()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Version:", this.selectedBackup.configVersion()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Created:", ScreenUIComponents.formatTimestamp(this.selectedBackup.timestamp())));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Size:", ScreenUIComponents.formatSize(this.selectedBackup.sizeBytes())));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Backup ID:", this.selectedBackup.backupId()));
        this.infoPanel.child((Component)infoBox);
        if (this.selectedBackup.description() != null && !this.selectedBackup.description().trim().isEmpty()) {
            this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
            this.infoPanel.child(Components.label((class_2561)class_2561.method_43470((String)this.selectedBackup.description())).color(UITheme.color(-1)).sizing(Sizing.fill((int)95), Sizing.content()));
        }
        this.infoPanel.child((Component)ScreenUIComponents.createWarningCard("Restore Information", "Restoring will replace current files. An auto-backup will be created first."));
        this.infoPanel.child((Component)this.createActionButtons());
    }

    private FlowLayout createActionButtons() {
        FlowLayout buttonPanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER);
        buttonPanel.child((Component)ScreenUIComponents.createButton("Restore Full Backup", btn -> this.showRestoreConfirmation(), 120, 20));
        buttonPanel.child((Component)ScreenUIComponents.createButton("Restore Specific Files", btn -> class_310.method_1551().method_1507((class_437)new SelectiveFileApplicationScreen(this.selectedBackup, (class_437)this)), 120, 20));
        if (this.selectedBackup.type() == BackupManager.BackupType.MANUAL) {
            buttonPanel.child((Component)ScreenUIComponents.createButton("Delete", btn -> this.showDeleteConfirmation(), 90, 20));
        }
        return buttonPanel;
    }

    private void showCreateBackupDialog() {
        FlowLayout dialog = ScreenUIComponents.createDialog("Create Manual Backup", null, 450);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Title:*")).color(UITheme.color(-1)));
        TextBoxComponent titleField = Components.textBox((Sizing)Sizing.fill((int)95), (String)"");
        titleField.method_47404((class_2561)class_2561.method_43470((String)"Enter backup title"));
        dialog.child((Component)titleField);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description (optional):")).color(UITheme.color(-1)));
        TextBoxComponent descriptionField = Components.textBox((Sizing)Sizing.fill((int)95), (String)"");
        descriptionField.method_47404((class_2561)class_2561.method_43470((String)"Additional details about this backup"));
        dialog.child((Component)descriptionField);
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Create", btn -> {
            String title = titleField.method_1882().trim();
            String description = descriptionField.method_1882().trim();
            this.closeTopOverlay();
            this.performCreateBackup(title.isEmpty() ? null : title, description.isEmpty() ? null : description);
        }), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay())));
        this.showOverlay(dialog, false);
    }

    private void performCreateBackup(String title, String description) {
        String finalTitle;
        this.currentOperationName = finalTitle = title != null ? title : "Manual backup - " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
        this.operationInBackground = false;
        this.isRestoreOperation = false;
        this.showBackupWarningDialog(finalTitle, description);
    }

    private void showBackupWarningDialog(String title, String description) {
        FlowLayout dialog = ScreenUIComponents.createWarningDialog("Backup Notice", null, 400);
        FlowLayout warningText = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Important Notice:")).color(UITheme.color(-1)).margins(Insets.bottom((int)4)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 The backup will run in the background")).color(UITheme.color(-1)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 A progress indicator will show the status")).color(UITheme.color(-1)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 You can continue using the interface")).color(UITheme.color(-1)).margins(Insets.bottom((int)8)));
        dialog.child((Component)warningText);
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 80, 20), ScreenUIComponents.createButton("Continue", btn -> {
            this.closeTopOverlay();
            this.executeBackupCreation(title, description);
        }, 120, 20)));
        this.showOverlay(dialog, false);
    }

    private void executeBackupCreation(String title, String description) {
        this.operationInBackground = false;
        this.showProgressDialog("Creating Backup", "Preparing backup...");
        ((CompletableFuture)BackupManager.createManualBackupAsync(title, description, this::updateProgress).thenAccept(backupPath -> class_310.method_1551().execute(() -> {
            this.closeProgressDialog();
            this.refreshBackupsList();
            BackupNotifications.notifyBackupComplete(this.currentOperationName, backupPath, false);
            if (class_310.method_1551().field_1755 == this) {
                try {
                    class_156.method_668().method_672(backupPath.getParent().toFile());
                }
                catch (Exception e) {
                    PackCore.LOGGER.warn("Failed to auto-open backup folder", (Throwable)e);
                }
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.closeProgressDialog();
                PackCore.LOGGER.error("Failed to create backup", throwable);
                this.showErrorDialog("Backup failed: " + throwable.getMessage());
            });
            return null;
        });
    }

    private void showRestoreConfirmation() {
        if (this.selectedBackup == null) {
            return;
        }
        FlowLayout dialog = ScreenUIComponents.createWarningDialog("Restore Backup?", null, 500);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Backup: " + this.selectedBackup.getDisplayName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-1)));
        FlowLayout warningBox = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-680437))).padding(Insets.of((int)12));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"This will:")).color(UITheme.color(-1)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Replace your current configuration files")).color(UITheme.color(-5195576)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Create an auto-backup of your current state")).color(UITheme.color(-5195576)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Overwrite mod configs and settings")).color(UITheme.color(-5195576)));
        dialog.child((Component)warningBox);
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Restore", btn -> {
            this.closeTopOverlay();
            this.showRestoreWarningDialog();
        }), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay())));
        this.showOverlay(dialog, false);
    }

    private void showRestoreWarningDialog() {
        FlowLayout dialog = ScreenUIComponents.createWarningDialog("Restore Notice", null, 400);
        FlowLayout warningText = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Important Notice:")).color(UITheme.color(-1)).margins(Insets.bottom((int)4)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 The restore will run in the background")).color(UITheme.color(-1)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 A progress indicator will show the status")).color(UITheme.color(-1)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 You can continue using the interface")).color(UITheme.color(-1)).margins(Insets.bottom((int)8)));
        dialog.child((Component)warningText);
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 80, 20), ScreenUIComponents.createButton("Continue Restore", btn -> {
            this.closeTopOverlay();
            this.performRestore();
        }, 120, 20)));
        this.showOverlay(dialog, false);
    }

    private void performRestore() {
        if (this.selectedBackup == null) {
            return;
        }
        this.currentOperationName = this.selectedBackup.getDisplayName();
        this.operationInBackground = false;
        this.isRestoreOperation = true;
        this.showProgressDialog("Restoring Backup", "Preparing restore...");
        ((CompletableFuture)BackupManager.restoreBackupAsync(this.selectedBackup, this::updateProgress).thenAccept(success -> class_310.method_1551().execute(() -> {
            this.closeProgressDialog();
            if (success.booleanValue()) {
                this.refreshBackupsList();
                Path gameDir = class_310.method_1551().field_1697.toPath();
                Path backupsDir = gameDir.resolve("packcore/backups");
                Path backupPath = backupsDir.resolve(this.selectedBackup.backupId() + ".zip");
                BackupNotifications.notifyBackupComplete(this.currentOperationName, backupPath, true);
            } else {
                this.showErrorDialog("Failed to restore backup!");
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.closeProgressDialog();
                PackCore.LOGGER.error("Failed to restore backup", throwable);
                this.showErrorDialog("Restore failed: " + throwable.getMessage());
            });
            return null;
        });
    }

    private void showDeleteConfirmation() {
        if (this.selectedBackup == null) {
            return;
        }
        FlowLayout dialog = ScreenUIComponents.createDialog("Delete Backup?", this.selectedBackup.getDisplayName() + "\n\nThis action cannot be undone.", 400);
        dialog.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-1096636)));
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Delete", btn -> {
            this.closeTopOverlay();
            this.performDelete();
        }), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay())));
        this.showOverlay(dialog, false);
    }

    private void performDelete() {
        if (this.selectedBackup == null) {
            return;
        }
        if (BackupManager.deleteBackup(this.selectedBackup)) {
            PackCore.LOGGER.info("Deleted backup: {}", (Object)this.selectedBackup.getDisplayName());
            this.selectedBackup = null;
            this.refreshBackupsList();
        } else {
            this.showErrorDialog("Failed to delete backup");
        }
    }

    private void showProgressDialog(String title, String message) {
        this.progressDialog = ScreenUIComponents.createDialog(title, null, 350);
        this.progressDialog.positioning(Positioning.absolute((int)((this.field_22789 - 350) / 2), (int)((this.field_22790 - 150) / 2)));
        this.progressDialog.zIndex(20);
        this.progressLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-1)).margins(Insets.bottom((int)12));
        this.progressDialog.child((Component)this.progressLabel);
        FlowLayout buttonRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER);
        ButtonComponent backgroundButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Continue in Background"), btn -> {
            this.operationInBackground = true;
            this.closeProgressDialog();
        }).horizontalSizing(Sizing.content());
        buttonRow.child((Component)backgroundButton);
        this.progressDialog.child((Component)buttonRow);
        this.rootComponent.child((Component)this.progressDialog);
    }

    private void updateProgress(String message) {
        class_310.method_1551().execute(() -> {
            if (this.progressLabel != null && !this.operationInBackground) {
                this.progressLabel.text((class_2561)class_2561.method_43470((String)message));
            }
        });
    }

    private void closeProgressDialog() {
        if (this.progressDialog != null) {
            this.rootComponent.removeChild((Component)this.progressDialog);
            this.progressDialog = null;
            this.progressLabel = null;
        }
    }

    private void showErrorDialog(String message) {
        FlowLayout dialog = ScreenUIComponents.createDialog("Error", message, 350);
        dialog.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-1096636)));
        dialog.positioning(Positioning.absolute((int)((this.field_22789 - 350) / 2), (int)((this.field_22790 - 120) / 2)));
        dialog.zIndex(20);
        dialog.child(ScreenUIComponents.createButton("OK", btn -> this.rootComponent.removeChild((Component)dialog), 80, 20).horizontalSizing(Sizing.content()));
        this.rootComponent.child((Component)dialog);
    }

    private void refreshBackupsList() {
        this.selectedBackup = null;
        this.showEmptyState();
        this.rebuildSidebarContent();
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }
}

