/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.configmanager;

import com.github.kd_gaming1.packcore.config.apply.FileDescriptionRegistry;
import com.github.kd_gaming1.packcore.config.apply.SelectiveConfigApplyService;
import com.github.kd_gaming1.packcore.config.backup.BackupManager;
import com.github.kd_gaming1.packcore.config.backup.SelectiveBackupRestoreService;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.ui.component.tree.FileTreeNode;
import com.github.kd_gaming1.packcore.ui.component.tree.FileTreeUIHelper;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveFileApplicationScreen
extends BasePackCoreScreen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private final Mode mode;
    private final ConfigFileRepository.ConfigFile sourceConfig;
    private final BackupManager.BackupInfo sourceBackup;
    private final Set<String> selectedPaths = ConcurrentHashMap.newKeySet();
    private FlowLayout sidebar;
    private FlowLayout mainContent;
    private FlowLayout fileTreeContainer;
    private FlowLayout detailsPanel;
    private ButtonComponent applyButton;
    private LabelComponent selectionInfoLabel;
    private ScrollContainer<FlowLayout> fileTreeScrollContainer;
    private List<SelectiveConfigApplyService.SelectableFile> allFiles = new ArrayList<SelectiveConfigApplyService.SelectableFile>();
    private FileTreeNode rootNode;
    private final Map<FileTreeNode, FlowLayout> treeNodeRows = new HashMap<FileTreeNode, FlowLayout>();
    private Path virtualRoot;

    public SelectiveFileApplicationScreen(ConfigFileRepository.ConfigFile sourceConfig, class_437 parent) {
        super(parent);
        this.mode = Mode.CONFIG_APPLY;
        this.sourceConfig = sourceConfig;
        this.sourceBackup = null;
    }

    public SelectiveFileApplicationScreen(BackupManager.BackupInfo sourceBackup, class_437 parent) {
        super(parent);
        this.mode = Mode.BACKUP_RESTORE;
        this.sourceConfig = null;
        this.sourceBackup = sourceBackup;
    }

    @Override
    protected Component createTitleLabel() {
        String sourceName = this.mode == Mode.CONFIG_APPLY ? this.sourceConfig.getDisplayName() : this.sourceBackup.getDisplayName();
        return Components.label((class_2561)class_2561.method_43470((String)(this.mode.getTitle() + " - " + sourceName)).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(-1));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8);
        mainContent.child((Component)this.createSidebar().padding(Insets.of((int)20, (int)16, (int)14, (int)14)));
        mainContent.child((Component)this.createContentArea());
        this.loadFiles();
        return mainContent;
    }

    private FlowLayout createSidebar() {
        this.sidebar = ScreenUIComponents.createSidebar(35);
        FlowLayout scrollContent = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(8);
        scrollContent.child((Component)this.createInstructions());
        scrollContent.child((Component)this.createQuickSelectButtons());
        scrollContent.child((Component)this.createSelectionInfo());
        this.sidebar.child(ScreenUIComponents.createScrollContainer(scrollContent));
        this.applyButton = ScreenUIComponents.createButton(this.mode == Mode.CONFIG_APPLY ? "Apply Selected" : "Restore Selected", btn -> this.showConfirmationDialog(), 120, 20);
        this.applyButton.active(false);
        this.sidebar.child((Component)this.applyButton).horizontalAlignment(HorizontalAlignment.CENTER);
        return this.sidebar;
    }

    private FlowLayout createInstructions() {
        FlowLayout section = ScreenUIComponents.createSection("Instructions", 0);
        String instructions = this.mode == Mode.CONFIG_APPLY ? "Select specific files from the configuration to apply. Expand folders to see contents. Check items to select them." : "Choose which files to restore from this backup. A safety backup will be created before restoration.";
        LabelComponent label = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)instructions)).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)95));
        section.child((Component)label);
        return section;
    }

    private FlowLayout createQuickSelectButtons() {
        FlowLayout section = ScreenUIComponents.createSection("Quick Select", 0);
        section.horizontalAlignment(HorizontalAlignment.CENTER);
        FlowLayout row1 = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.CENTER);
        row1.child((Component)ScreenUIComponents.createButton("Select All", btn -> this.selectAll(), 90, 19));
        row1.child((Component)ScreenUIComponents.createButton("Clear All", btn -> this.deselectAll(), 90, 19));
        section.child((Component)row1);
        FlowLayout row2 = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.CENTER);
        row2.child((Component)ScreenUIComponents.createButton("Configs Only", btn -> this.selectByType(SelectiveConfigApplyService.SelectableFile.FileType.MOD_CONFIG), 90, 19));
        row2.child((Component)ScreenUIComponents.createButton("Game Options", btn -> this.selectByType(SelectiveConfigApplyService.SelectableFile.FileType.GAME_OPTIONS), 90, 19));
        section.child((Component)row2);
        return section;
    }

    private FlowLayout createSelectionInfo() {
        FlowLayout section = ScreenUIComponents.createSection("Selection", 0);
        section.horizontalAlignment(HorizontalAlignment.CENTER);
        this.selectionInfoLabel = Components.label((class_2561)class_2561.method_43470((String)"0 files selected\n0 B")).color(UITheme.color(-5195576));
        section.child((Component)this.selectionInfoLabel);
        return section;
    }

    private FlowLayout createContentArea() {
        this.mainContent = ScreenUIComponents.createInfoPanel(65);
        this.mainContent.verticalAlignment(VerticalAlignment.TOP);
        this.mainContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"File Structure").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)).margins(Insets.of((int)6, (int)4, (int)8, (int)4)));
        this.fileTreeContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(2);
        this.mainContent.child(ScreenUIComponents.createScrollContainer(this.fileTreeContainer).sizing(Sizing.fill((int)100), Sizing.expand((int)60)));
        this.mainContent.child((Component)this.createDetailsSection());
        return this.mainContent;
    }

    private FlowLayout createDetailsSection() {
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand((int)35)).gap(4).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-18355))).padding(Insets.of((int)8)).margins(Insets.top((int)8));
        section.child((Component)Components.label((class_2561)class_2561.method_43470((String)"File Details").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        this.detailsPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4);
        this.showEmptyDetails();
        section.child(ScreenUIComponents.createScrollContainer(this.detailsPanel).sizing(Sizing.fill((int)100), Sizing.expand()));
        return section;
    }

    private void showEmptyDetails() {
        this.detailsPanel.clearChildren();
        this.detailsPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Hover over a file to see details")).color(UITheme.color(-5195576)));
    }

    private void showFileDetails(SelectiveConfigApplyService.SelectableFile file) {
        this.detailsPanel.clearChildren();
        Optional<FileDescriptionRegistry.FileDescription> description = FileDescriptionRegistry.getDescription(file.path());
        String icon = description.map(FileDescriptionRegistry.FileDescription::icon).orElse(FileDescriptionRegistry.getIcon(file.path()));
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)icon)).color(UITheme.color(-18355)));
        header.child(Components.label((class_2561)class_2561.method_43470((String)file.displayName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)).horizontalSizing(Sizing.expand()));
        this.detailsPanel.child((Component)header);
        this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Type:", file.type().getDisplayName()));
        this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Size:", ScreenUIComponents.formatSize(file.size())));
        Object displayPath = file.path();
        if (((String)displayPath).length() > 50) {
            displayPath = "..." + ((String)displayPath).substring(((String)displayPath).length() - 47);
        }
        this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Path:", (String)displayPath));
        if (description.isPresent()) {
            FileDescriptionRegistry.FileDescription desc = description.get();
            this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Description:", desc.description()));
            if (desc.isImportant()) {
                this.detailsPanel.child((Component)ScreenUIComponents.createWarningCard("Important File", "This file contains critical settings that will significantly affect your experience."));
            }
        } else if (file.description() != null && !file.description().isEmpty()) {
            this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Description:", file.description()));
        }
    }

    private void loadFiles() {
        this.fileTreeContainer.clearChildren();
        this.fileTreeContainer.child((Component)ScreenUIComponents.createEmptyState("Loading files..."));
        CompletableFuture<List<SelectiveConfigApplyService.SelectableFile>> loadFuture = this.mode == Mode.CONFIG_APPLY ? SelectiveConfigApplyService.scanConfigFiles(this.sourceConfig) : SelectiveBackupRestoreService.scanBackupFiles(this.sourceBackup);
        ((CompletableFuture)loadFuture.thenAccept(files -> class_310.method_1551().execute(() -> {
            this.allFiles = files;
            this.buildFileTree();
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                LOGGER.error("Failed to load files", throwable);
                this.fileTreeContainer.clearChildren();
                this.fileTreeContainer.child((Component)ScreenUIComponents.createErrorCard("Load Error", "Failed to scan files: " + throwable.getMessage()));
            });
            return null;
        });
    }

    private void buildFileTree() {
        this.fileTreeContainer.clearChildren();
        this.treeNodeRows.clear();
        if (this.allFiles.isEmpty()) {
            this.fileTreeContainer.child((Component)ScreenUIComponents.createEmptyState("No files found"));
            return;
        }
        this.virtualRoot = Paths.get("", new String[0]);
        this.rootNode = new FileTreeNode(this.virtualRoot, "root", true);
        this.rootNode.setExpanded(true);
        this.rootNode.setChildrenLoaded(true);
        for (SelectiveConfigApplyService.SelectableFile file : this.allFiles) {
            this.addFileToTree(file);
        }
        for (FileTreeNode child : this.rootNode.getChildren()) {
            this.addTreeNodeToUI(child, 0);
        }
        this.updateSelectionInfo();
    }

    private void addFileToTree(SelectiveConfigApplyService.SelectableFile file) {
        String[] pathParts = file.path().split("[/\\\\]");
        FileTreeNode currentNode = this.rootNode;
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i];
            boolean isLast = i == pathParts.length - 1;
            FileTreeNode childNode = this.findChild(currentNode, part);
            if (childNode == null) {
                Path nodePath = currentNode.getPath().resolve(part);
                childNode = new FileTreeNode(nodePath, part, !isLast);
                childNode.setChildrenLoaded(true);
                currentNode.addChild(childNode);
            }
            currentNode = childNode;
        }
    }

    private FileTreeNode findChild(FileTreeNode parent, String name) {
        for (FileTreeNode child : parent.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private void addTreeNodeToUI(FileTreeNode node, int depth) {
        if (node.isHidden()) {
            return;
        }
        boolean isSelected = this.selectedPaths.contains(node.getPath().toString());
        FlowLayout nodeRow = FileTreeUIHelper.createTreeNodeRow(node, depth, isSelected, () -> this.toggleNodeExpansion(node), (n, checked) -> this.toggleSelection((FileTreeNode)n, (boolean)checked), this::showNodeDetails);
        this.treeNodeRows.put(node, nodeRow);
        this.fileTreeContainer.child((Component)nodeRow);
        if (node.isDirectory() && node.isExpanded()) {
            for (FileTreeNode child : node.getChildren()) {
                this.addTreeNodeToUI(child, depth + 1);
            }
        }
    }

    private void showNodeDetails(FileTreeNode node) {
        if (node.isDirectory()) {
            int fileCount = FileTreeUIHelper.countFiles(node);
            long size = FileTreeUIHelper.calculateSize(node);
            this.detailsPanel.clearChildren();
            this.detailsPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\ud83d\udcc1 " + node.getName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
            this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Type:", "Directory"));
            this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Files:", String.valueOf(fileCount)));
            this.detailsPanel.child((Component)ScreenUIComponents.createInfoRow("Total Size:", ScreenUIComponents.formatSize(size)));
        } else {
            String path = node.getPath().toString();
            this.allFiles.stream().filter(f -> f.path().equals(path)).findFirst().ifPresent(this::showFileDetails);
        }
    }

    private void toggleNodeExpansion(FileTreeNode node) {
        node.setExpanded(!node.isExpanded());
        this.updateNodeExpansion(node);
    }

    private void updateNodeExpansion(FileTreeNode node) {
        FlowLayout nodeRow = this.treeNodeRows.get(node);
        if (nodeRow == null) {
            return;
        }
        int nodeIndex = -1;
        List children = this.fileTreeContainer.children();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) != nodeRow) continue;
            nodeIndex = i;
            break;
        }
        if (nodeIndex == -1) {
            return;
        }
        this.updateExpandButton(nodeRow, node.isExpanded());
        if (node.isExpanded()) {
            int depth = this.calculateDepth(nodeRow);
            int insertIndex = nodeIndex + 1;
            for (FileTreeNode child : node.getChildren()) {
                int rowsAdded = this.createNodeRow(child, depth + 1, insertIndex);
                insertIndex += rowsAdded;
            }
        } else {
            this.removeChildrenFromTree(node);
        }
    }

    private void updateExpandButton(FlowLayout row, boolean expanded) {
        Object e;
        if (!row.children().isEmpty() && (e = row.children().get(0)) instanceof ButtonComponent) {
            ButtonComponent btn = (ButtonComponent)e;
            btn.method_25355((class_2561)class_2561.method_43470((String)(expanded ? "\u25bc" : "\u25b6")));
        }
    }

    private int calculateDepth(FlowLayout row) {
        Insets padding = (Insets)row.padding().get();
        return padding.left() / 16;
    }

    private int createNodeRow(FileTreeNode node, int depth, int insertIndex) {
        if (node.isHidden()) {
            return 0;
        }
        boolean isSelected = this.selectedPaths.contains(node.getPath().toString());
        FlowLayout nodeRow = FileTreeUIHelper.createTreeNodeRow(node, depth, isSelected, () -> this.toggleNodeExpansion(node), this::toggleSelection, this::showNodeDetails);
        this.treeNodeRows.put(node, nodeRow);
        ArrayList<FlowLayout> children = new ArrayList<FlowLayout>(this.fileTreeContainer.children());
        if (insertIndex <= children.size()) {
            children.add(insertIndex, nodeRow);
        } else {
            children.add(nodeRow);
        }
        this.fileTreeContainer.clearChildren();
        children.forEach(arg_0 -> ((FlowLayout)this.fileTreeContainer).child(arg_0));
        int rowsAdded = 1;
        if (node.isDirectory() && node.isExpanded()) {
            int childIndex = insertIndex + 1;
            for (FileTreeNode child : node.getChildren()) {
                int childRows = this.createNodeRow(child, depth + 1, childIndex);
                childIndex += childRows;
                rowsAdded += childRows;
            }
        }
        return rowsAdded;
    }

    private void removeChildrenFromTree(FileTreeNode node) {
        for (FileTreeNode child : node.getChildren()) {
            FlowLayout childRow = this.treeNodeRows.remove(child);
            if (childRow != null) {
                this.fileTreeContainer.removeChild((Component)childRow);
            }
            if (!child.isDirectory()) continue;
            this.removeChildrenFromTree(child);
        }
    }

    private void toggleSelection(FileTreeNode node, boolean selected) {
        FileTreeUIHelper.selectNodeAndChildren(node, selected, this.selectedPaths);
        this.updateSelectionInfo();
        this.updateNodeVisualsRecursive(node);
    }

    private void updateNodeVisualsRecursive(FileTreeNode node) {
        FlowLayout row = this.treeNodeRows.get(node);
        if (row != null) {
            boolean isSelected = this.selectedPaths.contains(node.getPath().toString());
            for (Component child : row.children()) {
                LabelComponent label;
                if (child instanceof CheckboxComponent) {
                    CheckboxComponent checkbox = (CheckboxComponent)child;
                    checkbox.checked(isSelected);
                    continue;
                }
                if (!(child instanceof LabelComponent) || !(label = (LabelComponent)child).text().getString().equals(node.getName())) continue;
                label.color(UITheme.color(isSelected ? -18355 : -1));
            }
        }
        if (node.isDirectory()) {
            for (FileTreeNode child : node.getChildren()) {
                this.updateNodeVisualsRecursive(child);
            }
        }
    }

    private void updateTreeVisuals() {
        for (Map.Entry<FileTreeNode, FlowLayout> entry : this.treeNodeRows.entrySet()) {
            FileTreeNode node = entry.getKey();
            FlowLayout row = entry.getValue();
            boolean isSelected = this.selectedPaths.contains(node.getPath().toString());
            for (Component child : row.children()) {
                LabelComponent label;
                if (child instanceof CheckboxComponent) {
                    CheckboxComponent checkbox = (CheckboxComponent)child;
                    checkbox.checked(isSelected);
                    continue;
                }
                if (!(child instanceof LabelComponent) || !(label = (LabelComponent)child).text().getString().equals(node.getName())) continue;
                label.color(UITheme.color(isSelected ? -18355 : -1));
            }
        }
        this.updateSelectionInfo();
    }

    private void selectAll() {
        for (SelectiveConfigApplyService.SelectableFile file : this.allFiles) {
            this.selectedPaths.add(file.path());
        }
        this.updateTreeVisuals();
    }

    private void deselectAll() {
        this.selectedPaths.clear();
        this.updateTreeVisuals();
    }

    private void selectByType(SelectiveConfigApplyService.SelectableFile.FileType type) {
        this.selectedPaths.clear();
        for (SelectiveConfigApplyService.SelectableFile file : this.allFiles) {
            if (file.type() != type) continue;
            this.selectedPaths.add(file.path());
        }
        this.updateTreeVisuals();
    }

    private void updateSelectionInfo() {
        int count = this.selectedPaths.size();
        long totalSize = this.allFiles.stream().filter(f -> this.selectedPaths.contains(f.path())).mapToLong(SelectiveConfigApplyService.SelectableFile::size).sum();
        String sizeText = ScreenUIComponents.formatSize(totalSize);
        this.selectionInfoLabel.text((class_2561)class_2561.method_43470((String)(count + " file" + (count != 1 ? "s" : "") + " selected\n" + sizeText)));
        this.applyButton.active(count > 0);
    }

    private void showConfirmationDialog() {
        String sourceName;
        String action;
        String string = action = this.mode == Mode.CONFIG_APPLY ? "Apply" : "Restore";
        if (this.mode == Mode.CONFIG_APPLY) {
            assert (this.sourceConfig != null);
            sourceName = this.sourceConfig.getDisplayName();
        } else {
            assert (this.sourceBackup != null);
            sourceName = this.sourceBackup.getDisplayName();
        }
        FlowLayout dialog = ScreenUIComponents.createWarningDialog(action + " Selected Files?", null, 500);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)("You have selected " + this.selectedPaths.size() + " file" + (this.selectedPaths.size() != 1 ? "s" : "") + " to " + action.toLowerCase() + " from:"))).color(UITheme.color(-1)));
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)sourceName).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)).margins(Insets.bottom((int)8)));
        dialog.child((Component)ScreenUIComponents.createWarningCard("\u26a0 Game Will Close", "The game will close and apply the selected files on next startup.  Configuration files cannot be hot-reloaded while the game is running."));
        dialog.child((Component)ScreenUIComponents.createWarningCard("Auto-Backup", "An automatic backup will be created before applying changes.  You can restore it later if needed."));
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton(action + " & Close Game", btn -> {
            this.closeTopOverlay();
            this.performApplication();
        }, 140, 20), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 90, 20)));
        this.showOverlay(dialog, false);
    }

    private void performApplication() {
        FlowLayout progressDialog = ScreenUIComponents.createDialog("Scheduling Files", "Preparing to " + (this.mode == Mode.CONFIG_APPLY ? "apply" : "restore") + " files on next startup...", 350);
        this.showOverlay(progressDialog, false);
        CompletableFuture<Boolean> applyFuture = this.mode == Mode.CONFIG_APPLY ? SelectiveConfigApplyService.scheduleSelectiveConfigApplication(this.sourceConfig, this.selectedPaths) : SelectiveBackupRestoreService.scheduleSelectiveRestore(this.sourceBackup, this.selectedPaths);
        ((CompletableFuture)applyFuture.thenAccept(success -> class_310.method_1551().execute(() -> {
            this.closeTopOverlay();
            if (success.booleanValue()) {
                if (class_310.method_1551().field_1724 != null) {
                    String action = this.mode == Mode.CONFIG_APPLY ? "Applying" : "Restoring";
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)(action + " " + this.selectedPaths.size() + " selected files - Restarting...")), false);
                }
            } else {
                this.showErrorDialog();
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.closeTopOverlay();
                LOGGER.error("Failed to schedule files", throwable);
                this.showErrorDialog();
            });
            return null;
        });
    }

    private void showErrorDialog() {
        String action = this.mode == Mode.CONFIG_APPLY ? "apply" : "restore";
        FlowLayout dialog = ScreenUIComponents.createDialog("Error", "Failed to " + action + " selected files. Check logs for details.", 350);
        dialog.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-1096636)));
        dialog.child(ScreenUIComponents.createButton("OK", btn -> this.closeTopOverlay(), 80, 20).horizontalSizing(Sizing.content()));
        this.showOverlay(dialog, false);
    }

    public static enum Mode {
        CONFIG_APPLY("Apply Configuration Files"),
        BACKUP_RESTORE("Restore Backup Files");

        private final String title;

        private Mode(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

