/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard.pages;

import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.wizard.BaseWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.WizardNavigator;
import com.github.kd_gaming1.packcore.ui.surface.effects.TextureSurfaces;
import com.github.kd_gaming1.packcore.util.wizard.WizardDataStore;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class ItemBackgroundWizardPage
extends BaseWizardPage {
    private static final List<BackgroundOption> OPTIONS = List.of(new BackgroundOption("No Background", "No Background", "item_bg_none.png"), new BackgroundOption("Circular", "Circular Background", "item_bg_circular.png"), new BackgroundOption("Square", "Square Background", "item_bg_square.png"));
    private final WizardDataStore dataStore = WizardDataStore.getInstance();
    private String selectedBackground = this.dataStore.getItemBackground();
    private LabelComponent selectionLabel;
    private FlowLayout contentContainer;

    public ItemBackgroundWizardPage() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Item Background"), 3, 6), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        if (this.selectedBackground.isEmpty()) {
            this.selectedBackground = "None";
        }
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        this.contentContainer = contentContainer;
        contentContainer.surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/frame.png"), 1920, 1080));
        contentContainer.padding(Insets.of((int)22, (int)22, (int)18, (int)18));
        contentContainer.child((Component)WizardUIComponents.createHeader("Choose your preferred item background style for", "Select how items should appear in your inventory and menus. You can choose no background, a circular design, or a full square background. (Tip: Click the image)").margins(Insets.horizontal((int)34)));
        contentContainer.child((Component)this.createSelectionLabel());
        contentContainer.child((Component)this.createImageChoices());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
    }

    private LabelComponent createSelectionLabel() {
        int color;
        Object displayText;
        if ("None".equals(this.selectedBackground)) {
            displayText = "\ud83d\udc47 Click an image below to choose your item background style";
            color = -18355;
        } else {
            displayText = "\u2713 Selected: " + this.selectedBackground;
            color = -15681151;
        }
        this.selectionLabel = WizardUIComponents.createStatusLabel((String)displayText, null, color);
        this.selectionLabel.margins(Insets.left((int)16));
        return this.selectionLabel;
    }

    private FlowLayout createImageChoices() {
        FlowLayout choicesRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(12).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        for (BackgroundOption option : OPTIONS) {
            choicesRow.child((Component)this.createBackgroundOption(option));
        }
        return choicesRow;
    }

    private FlowLayout createBackgroundOption(BackgroundOption option) {
        boolean isSelected = option.key.equals(this.selectedBackground);
        FlowLayout wrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)32), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)8)).cursorStyle(CursorStyle.HAND);
        wrapper.child((Component)Components.label((class_2561)class_2561.method_43470((String)option.displayName).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)).margins(Insets.of((int)4, (int)4, (int)2, (int)4)));
        class_2960 textureId = class_2960.method_60655((String)"packcore", (String)("textures/gui/wizard/" + option.texturePath));
        Surface imageSurface = isSelected ? TextureSurfaces.scaledContain(textureId, 555, 666).and(Surface.outline((int)-15681151)) : TextureSurfaces.scaledContain(textureId, 555, 666);
        FlowLayout imageContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(imageSurface).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
        imageContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectBackground(option.key);
            return true;
        });
        wrapper.child((Component)imageContainer);
        return wrapper;
    }

    private void selectBackground(String background) {
        this.selectedBackground = background;
        this.dataStore.setItemBackground(background);
        if (this.selectionLabel != null) {
            this.selectionLabel.text((class_2561)class_2561.method_43470((String)("\u2713 Selected: " + this.selectedBackground)).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-15681151));
        }
        this.rebuildContent();
    }

    private void rebuildContent() {
        if (this.contentContainer != null) {
            this.contentContainer.clearChildren();
            this.buildContent(this.contentContainer);
        }
    }

    @Override
    protected void onContinuePressed() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(WizardNavigator.createWizardPage(4));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 100;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    private record BackgroundOption(String key, String displayName, String texturePath) {
    }
}

