/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard.pages;

import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.wizard.BaseWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.WizardNavigator;
import com.github.kd_gaming1.packcore.util.markdown.MarkdownService;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class WelcomeWizardPage
extends BaseWizardPage {
    private static final String FALLBACK_CONTENT = "# Welcome\n\nWelcome to PackCore! This is the default welcome content.\n\nFind and edit this content in `rundir/packcore/wizard_markdown_content/welcome.md`\n";
    private final String markdownContent;
    private final boolean configApplied;
    private boolean detailsExpanded = false;
    private FlowLayout detailsSection;
    private ButtonComponent toggleButton;

    public WelcomeWizardPage() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Welcome"), 0, 6), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        MarkdownService markdownService = new MarkdownService();
        this.markdownContent = markdownService.getOrDefault("welcome.md", FALLBACK_CONTENT);
        this.configApplied = PackCoreConfig.defaultConfigSuccessfullyApplied;
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.gap(8);
        contentContainer.child((Component)WizardUIComponents.createHeader("Welcome to", "Let's get you set up for the best experience! Take 30 seconds and read through the welcome please."));
        contentContainer.child((Component)this.createStatusCard());
        contentContainer.child((Component)this.createExpandableDetails());
        contentContainer.child((Component)this.createBottomTip());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        contentContainerRight.gap(8);
        contentContainerRight.child((Component)this.createWizardOverview());
    }

    private FlowLayout createStatusCard() {
        if (this.configApplied) {
            return this.createSuccessCard();
        }
        return this.createFailureCard();
    }

    private FlowLayout createSuccessCard() {
        FlowLayout card = WizardUIComponents.createInfoCard("\u2713 Default Configs Successfully Applied", null, 537966977, -15681151);
        class_310 mc = class_310.method_1551();
        int width = mc.method_22683().method_4480();
        int height = mc.method_22683().method_4507();
        String configName = ConfigFileRepository.getCurrentConfig().getDisplayName();
        LabelComponent details = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)("We have detected your screen resolution to be " + width + "x" + height + " and have enabled configs: " + configName))).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)100));
        card.child((Component)details);
        return card;
    }

    private FlowLayout createFailureCard() {
        FlowLayout card = WizardUIComponents.createInfoCard("\u26a0 Automatic Config Application Failed", "Automatic config setup didn't work. You can reset and try again, or continue and configure manually from the main menu later.", 552551492, -1096636);
        ButtonComponent resetButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Reset & Try Again"), btn -> this.showResetConfirmation()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
        card.child((Component)resetButton);
        return card;
    }

    private FlowLayout createExpandableDetails() {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8);
        this.toggleButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)this.getToggleButtonText()), btn -> this.toggleDetails()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
        container.child((Component)this.toggleButton);
        this.detailsSection = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand((int)64)).gap(8).surface(Surface.flat((int)0x20000000).and(Surface.outline((int)0x30FFFFFF))).padding(Insets.of((int)8));
        this.detailsSection.child(WizardUIComponents.createMarkdownScroll(this.markdownContent).sizing(Sizing.fill((int)100), Sizing.fill()));
        if (!this.detailsExpanded) {
            this.detailsSection.positioning(Positioning.absolute((int)0, (int)-10000));
        }
        container.child((Component)this.detailsSection);
        return container;
    }

    private void toggleDetails() {
        this.detailsExpanded = !this.detailsExpanded;
        this.toggleButton.method_25355((class_2561)class_2561.method_43470((String)this.getToggleButtonText()));
        if (this.detailsExpanded) {
            this.detailsSection.positioning(Positioning.layout());
        } else {
            this.detailsSection.positioning(Positioning.absolute((int)0, (int)-10000));
        }
    }

    private String getToggleButtonText() {
        return this.detailsExpanded ? "\u25bc Hide Details" : "\u25b6 Show More Details";
    }

    private FlowLayout createBottomTip() {
        FlowLayout tip = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).surface(Surface.flat((int)553629773)).padding(Insets.of((int)12));
        tip.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udca1")).color(Color.ofRgb((int)-18355)));
        LabelComponent tipText = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Tip: You can reconfigure everything later using ").method_10852((class_2561)class_2561.method_43470((String)"/packcore").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)" in-game"))).color(Color.ofRgb((int)-1)).horizontalSizing(Sizing.expand());
        tip.child((Component)tipText);
        return tip;
    }

    private FlowLayout createWizardOverview() {
        String[][] steps;
        FlowLayout overview = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).margins(Insets.of((int)4));
        overview.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udccb Setup Steps").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)));
        FlowLayout stepsContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(6);
        for (String[] step : steps = new String[][]{{"1", "Performance", "Optimize FPS & quality"}, {"2", "Tab Design", "Choose Tab style"}, {"3", "Background", "Pick item style"}, {"4", "Resources", "Select texture packs"}, {"5", "Info", "Useful tips"}, {"6", "Apply", "Activate settings"}}) {
            stepsContainer.child((Component)this.createStepIndicator(step[0], step[1], step[2]));
        }
        ScrollContainer stepsScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)stepsContainer);
        stepsScroll.scrollbar(ScrollContainer.Scrollbar.vanilla());
        stepsScroll.scrollbarThiccness(6);
        stepsScroll.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        stepsScroll.padding(Insets.of((int)8));
        overview.child((Component)stepsScroll);
        return overview;
    }

    private FlowLayout createStepIndicator(String number, String title, String desc) {
        FlowLayout indicator = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).padding(Insets.of((int)8)).surface(Surface.flat((int)541757666).and(Surface.outline((int)0x30FFFFFF))).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout badge = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)28), (Sizing)Sizing.fixed((int)28)).surface(Surface.flat((int)-11890462).and(Surface.outline((int)-1))).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        badge.child((Component)Components.label((class_2561)class_2561.method_43470((String)number).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)).shadow(true));
        indicator.child((Component)badge);
        FlowLayout textContent = Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).gap(2);
        textContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)));
        textContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)desc)).color(Color.ofRgb((int)-5195576)));
        indicator.child((Component)textContent);
        return indicator;
    }

    private void showResetConfirmation() {
        FlowLayout dialog = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)350), (Sizing)Sizing.content()).gap(12).surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-680437))).padding(Insets.of((int)20)).positioning(Positioning.relative((int)50, (int)50));
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Reset Setup?").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-680437)));
        LabelComponent msg = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"This will reset PackCore and close the game. The wizard will restart when you reopen Minecraft.")).color(Color.ofRgb((int)-1)).horizontalSizing(Sizing.fill((int)100));
        dialog.child((Component)msg);
        FlowLayout buttons = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)8));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.getRootComponent().removeChild((Component)this.getRootComponent().children().getLast())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Reset & Exit"), btn -> this.performReset()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20)));
        dialog.child((Component)buttons);
        OverlayContainer overlay = Containers.overlay((Component)dialog);
        overlay.closeOnClick(true);
        overlay.surface(Surface.flat((int)Integer.MIN_VALUE));
        overlay.zIndex(10);
        this.getRootComponent().child((Component)overlay);
    }

    private void performReset() {
        PackCoreConfig.defaultConfigSuccessfullyApplied = false;
        PackCoreConfig.write((String)"packcore");
        class_310.method_1551().method_1592();
    }

    @Override
    protected void onContinuePressed() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(WizardNavigator.createWizardPage(1));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 58;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }
}

