/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.surface.effects;

import io.wispforest.owo.ui.core.Surface;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

public final class TextureSurfaces {
    private TextureSurfaces() {
    }

    public static Surface scaledCover(class_2960 texture, int textureWidth, int textureHeight) {
        TextureSurfaces.validateTextureDimensions(textureWidth, textureHeight);
        return (context, component) -> {
            if (component.width() <= 0 || component.height() <= 0) {
                return;
            }
            int cx = component.x();
            int cy = component.y();
            int cw = component.width();
            int ch = component.height();
            float scaleX = (float)cw / (float)textureWidth;
            float scaleY = (float)ch / (float)textureHeight;
            float scale = Math.max(scaleX, scaleY);
            int scaledWidth = Math.round((float)textureWidth * scale);
            int scaledHeight = Math.round((float)textureHeight * scale);
            int drawX = cx + (cw - scaledWidth) / 2;
            int drawY = cy + (ch - scaledHeight) / 2;
            context.method_25293(class_1921::method_62277, texture, drawX, drawY, 0.0f, 0.0f, scaledWidth, scaledHeight, textureWidth, textureHeight, textureWidth, textureHeight, -1);
        };
    }

    public static Surface scaledContain(class_2960 texture, int textureWidth, int textureHeight) {
        TextureSurfaces.validateTextureDimensions(textureWidth, textureHeight);
        return (context, component) -> {
            if (component.width() <= 0 || component.height() <= 0) {
                return;
            }
            int cx = component.x();
            int cy = component.y();
            int cw = component.width();
            int ch = component.height();
            float scaleX = (float)cw / (float)textureWidth;
            float scaleY = (float)ch / (float)textureHeight;
            float scale = Math.min(scaleX, scaleY);
            int scaledWidth = Math.round((float)textureWidth * scale);
            int scaledHeight = Math.round((float)textureHeight * scale);
            int drawX = cx + (cw - scaledWidth) / 2;
            int drawY = cy + (ch - scaledHeight) / 2;
            context.method_25293(class_1921::method_62277, texture, drawX, drawY, 0.0f, 0.0f, scaledWidth, scaledHeight, textureWidth, textureHeight, textureWidth, textureHeight, -1);
        };
    }

    public static Surface stretched(class_2960 texture, int textureWidth, int textureHeight) {
        TextureSurfaces.validateTextureDimensions(textureWidth, textureHeight);
        return (context, component) -> {
            if (component.width() <= 0 || component.height() <= 0) {
                return;
            }
            context.method_25293(class_1921::method_62277, texture, component.x(), component.y(), 0.0f, 0.0f, component.width(), component.height(), textureWidth, textureHeight, textureWidth, textureHeight, -1);
        };
    }

    public static Surface tiled(class_2960 texture, int textureWidth, int textureHeight) {
        TextureSurfaces.validateTextureDimensions(textureWidth, textureHeight);
        return (context, component) -> {
            if (component.width() <= 0 || component.height() <= 0) {
                return;
            }
            int startX = component.x();
            int startY = component.y();
            int endX = startX + component.width();
            int endY = startY + component.height();
            for (int y = startY; y < endY; y += textureHeight) {
                int tileHeight = Math.min(textureHeight, endY - y);
                for (int x = startX; x < endX; x += textureWidth) {
                    int tileWidth = Math.min(textureWidth, endX - x);
                    context.method_25290(class_1921::method_62277, texture, x, y, 0.0f, 0.0f, tileWidth, tileHeight, textureWidth, textureHeight);
                }
            }
        };
    }

    public static Surface tiledCustom(class_2960 texture, int textureWidth, int textureHeight, int tileWidth, int tileHeight) {
        TextureSurfaces.validateTextureDimensions(textureWidth, textureHeight);
        if (tileWidth <= 0 || tileHeight <= 0) {
            throw new IllegalArgumentException("Tile dimensions must be positive: " + tileWidth + "x" + tileHeight);
        }
        return (context, component) -> {
            if (component.width() <= 0 || component.height() <= 0) {
                return;
            }
            int startX = component.x();
            int startY = component.y();
            int endX = startX + component.width();
            int endY = startY + component.height();
            for (int y = startY; y < endY; y += tileHeight) {
                int drawHeight = Math.min(tileHeight, endY - y);
                for (int x = startX; x < endX; x += tileWidth) {
                    int drawWidth = Math.min(tileWidth, endX - x);
                    context.method_25293(class_1921::method_62277, texture, x, y, 0.0f, 0.0f, drawWidth, drawHeight, textureWidth, textureHeight, tileWidth, tileHeight, -1);
                }
            }
        };
    }

    public static Surface layered(Surface ... surfaces) {
        if (surfaces.length == 0) {
            return Surface.BLANK;
        }
        return (context, component) -> {
            for (Surface surface : surfaces) {
                surface.draw(context, component);
            }
        };
    }

    private static void validateTextureDimensions(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Texture dimensions must be positive: " + width + "x" + height);
        }
    }
}

