/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.wizard;

import com.github.kd_gaming1.packcore.PackCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WizardDataStore {
    private static final WizardDataStore INSTANCE = new WizardDataStore();
    private final WizardData data = new WizardData();
    private ApplicationState appState = new ApplicationState();

    private WizardDataStore() {
    }

    public static WizardDataStore getInstance() {
        return INSTANCE;
    }

    public void setOptimizationProfile(String profile) {
        this.data.optimizationProfile = profile;
        this.logUpdate("optimization profile", profile);
    }

    public String getOptimizationProfile() {
        return this.data.optimizationProfile;
    }

    public void setTabDesign(String design) {
        this.data.tabDesign = design;
        this.logUpdate("tab design", design);
    }

    public String getTabDesign() {
        return this.data.tabDesign;
    }

    public void setItemBackground(String background) {
        this.data.itemBackground = background;
        this.logUpdate("item background", background);
    }

    public String getItemBackground() {
        return this.data.itemBackground;
    }

    public void setResourcePacksOrdered(List<String> packs) {
        this.data.resourcePacksOrdered.clear();
        this.data.resourcePacksOrdered.addAll(packs);
        this.logUpdate("resource packs", packs.toString());
    }

    public List<String> getResourcePacksOrdered() {
        return new ArrayList<String>(this.data.resourcePacksOrdered);
    }

    public Set<String> getAdditionalSettings() {
        return new HashSet<String>();
    }

    public void setApplicationState(boolean applying, boolean applied, String error) {
        this.appState = new ApplicationState(applying, applied, error);
    }

    public boolean isConfigurationApplying() {
        return this.appState.applying;
    }

    public void setConfigurationApplying(boolean applying) {
        this.appState = this.appState.withApplying(applying);
    }

    public boolean isConfigurationApplied() {
        return this.appState.applied;
    }

    public void setConfigurationApplied(boolean applied) {
        this.appState = this.appState.withApplied(applied);
    }

    public void setConfigurationResult(String result, String errorMessage) {
        this.appState = this.appState.withError(errorMessage != null ? errorMessage : "");
        this.logUpdate("configuration result", result + " - " + errorMessage);
    }

    public String getConfigurationResult() {
        return this.appState.applied ? "success" : (!this.appState.error.isEmpty() ? "failed" : "");
    }

    public String getConfigurationErrorMessage() {
        return this.appState.error;
    }

    public WizardConfiguration getConfiguration() {
        return new WizardConfiguration(this.data.optimizationProfile, new ArrayList<String>(this.data.resourcePacksOrdered), this.data.tabDesign, this.data.itemBackground);
    }

    public boolean isConfigurationComplete() {
        return !this.data.optimizationProfile.isEmpty();
    }

    public void reset() {
        this.data.clear();
        this.appState = new ApplicationState();
        PackCore.LOGGER.info("Wizard data reset");
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        if (!this.data.optimizationProfile.isEmpty()) {
            sb.append("Performance: ").append(this.data.optimizationProfile);
        }
        if (!this.data.tabDesign.isEmpty()) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append("Tab: ").append(this.data.tabDesign);
        }
        if (!this.data.itemBackground.isEmpty()) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append("Items: ").append(this.data.itemBackground);
        }
        if (!this.data.resourcePacksOrdered.isEmpty()) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append("Packs: ").append(String.join((CharSequence)", ", this.data.resourcePacksOrdered));
        }
        return sb.toString();
    }

    private void logUpdate(String field, String value) {
        PackCore.LOGGER.debug("Set {}: {}", (Object)field, (Object)value);
    }

    private static class WizardData {
        String optimizationProfile = "";
        String tabDesign = "";
        String itemBackground = "";
        final List<String> resourcePacksOrdered = new ArrayList<String>();

        private WizardData() {
        }

        void clear() {
            this.optimizationProfile = "";
            this.tabDesign = "";
            this.itemBackground = "";
            this.resourcePacksOrdered.clear();
        }
    }

    private record ApplicationState(boolean applying, boolean applied, String error) {
        ApplicationState() {
            this(false, false, "");
        }

        ApplicationState withApplying(boolean applying) {
            return new ApplicationState(applying, this.applied, this.error);
        }

        ApplicationState withApplied(boolean applied) {
            return new ApplicationState(this.applying, applied, this.error);
        }

        ApplicationState withError(String error) {
            return new ApplicationState(this.applying, this.applied, error);
        }
    }

    public record WizardConfiguration(String optimizationProfile, List<String> resourcePacksOrdered, String tabDesign, String itemBackground) {
        private final List<String> resourcePacksOrdered;

        public List<String> resourcePacksOrdered() {
            return new ArrayList<String>(this.resourcePacksOrdered);
        }

        public Set<String> getAdditionalSettings() {
            return new HashSet<String>();
        }

        public Map<String, Object> getCustomSettings() {
            return new HashMap<String, Object>();
        }
    }
}

