package com.github.kd_gaming1.packcore.command.packcore;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class MenuCommand {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("menu")
                .then(ClientCommandManager.literal("enable")
                        .executes(ctx -> setMenuEnabled(ctx, true)))
                .then(ClientCommandManager.literal("disable")
                        .executes(ctx -> setMenuEnabled(ctx, false)))
                .then(ClientCommandManager.literal("toggle")
                        .executes(MenuCommand::toggleMenu))
                .executes(MenuCommand::showMenuStatus);
    }

    private static int setMenuEnabled(CommandContext<FabricClientCommandSource> context, boolean enabled) {
        PackCoreConfig.enableCustomMenu = enabled;
        PackCoreConfig.write(PackCore.MOD_ID);

        String status = enabled ? "enabled" : "disabled";
        class_124 color = enabled ? class_124.field_1060 : class_124.field_1061;

        context.getSource().sendFeedback(
                class_2561.method_43470("✓ Custom menu " + status + "!")
                        .method_27692(color)
        );

        context.getSource().sendFeedback(
                class_2561.method_43470("ℹ Restart the game for changes to take effect.")
                        .method_27692(class_124.field_1054)
        );

        return 1;
    }

    private static int toggleMenu(CommandContext<FabricClientCommandSource> context) {
        boolean newState = !PackCoreConfig.enableCustomMenu;
        return setMenuEnabled(context, newState);
    }

    private static int showMenuStatus(CommandContext<FabricClientCommandSource> context) {
        boolean enabled = PackCoreConfig.enableCustomMenu;
        String status = enabled ? "Enabled" : "Disabled";
        class_124 color = enabled ? class_124.field_1060 : class_124.field_1061;

        context.getSource().sendFeedback(
                class_2561.method_43470("Custom Menu Status: ")
                        .method_27692(class_124.field_1054)
                        .method_10852(class_2561.method_43470(status).method_27692(color))
        );

        context.getSource().sendFeedback(
                class_2561.method_43470("Use ").method_27692(class_124.field_1080)
                        .method_10852(class_2561.method_43470("/packcore menu toggle").method_27692(class_124.field_1060))
                        .method_10852(class_2561.method_43470(" to change").method_27692(class_124.field_1080))
        );

        return 1;
    }
}