package com.github.kd_gaming1.packcore.integration.minecraft;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.github.kd_gaming1.packcore.PackCore.MOD_ID;

import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4063;
import net.minecraft.class_4066;
import net.minecraft.class_5365;

/**
 * Integration class for vanilla Minecraft settings.
 * Handles GameOptions modifications for performance profiles.
 */
public class MinecraftIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static boolean applyProfile(PerformanceProfileService.PerformanceProfile profile) {
        try {
            class_315 options = getValidatedOptions();
            if (options == null) return false;

            switch (profile) {
                case PERFORMANCE -> applyPerformanceSettings(options);
                case BALANCED -> applyBalancedSettings(options);
                case QUALITY, SHADERS -> applyQualitySettings(options);
                default -> {
                    LOGGER.warn("Unknown profile: {}", profile);
                    return false;
                }
            }

            options.method_1640();
            LOGGER.debug("Minecraft profile '{}' applied successfully", profile.name());
            return true;
        } catch (Exception e) {
            LOGGER.error("Failed to apply Minecraft profile", e);
            return false;
        }
    }

    public static boolean restoreDefaults() {
        try {
            class_315 options = getValidatedOptions();
            if (options == null) return false;

            // Reset to default values using getter methods
            options.method_42534().method_41748(class_5365.field_25428);
            options.method_42503().method_41748(12);
            options.method_42510().method_41748(12);
            options.method_42517().method_41748(1.0);
            options.method_42524().method_41748(120);
            options.method_42433().method_41748(false);
            options.method_41805().method_41748(2);
            options.method_42435().method_41748(true);
            options.method_42528().method_41748(class_4063.field_18164);
            options.method_41792().method_41748(true); // Ambient occlusion

            options.method_1640();
            LOGGER.debug("Minecraft default settings restored");
            return true;
        } catch (Exception e) {
            LOGGER.error("Failed to restore Minecraft defaults", e);
            return false;
        }
    }

    private static class_315 getValidatedOptions() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            LOGGER.warn("MinecraftClient is null, cannot apply profile");
            return null;
        }

        class_315 options = client.field_1690;
        if (options == null) {
            LOGGER.warn("GameOptions is null, cannot apply profile");
            return null;
        }

        return options;
    }

    private static void applyPerformanceSettings(class_315 options) {
        // Performance profile settings from options.txt
        options.method_41792().method_41748(true);
        options.method_41805().method_41748(2);
        options.method_42433().method_41748(false);
        options.method_42517().method_41748(1.0);
        options.method_42435().method_41748(false);
        options.method_42534().method_41748(class_5365.field_25427); // graphicsMode:0 = FAST
        options.method_42524().method_41748(260);
        options.method_42563().method_41748(2);
        options.method_42475().method_41748(class_4066.field_18199); // particles:2 = MINIMAL
        options.method_42528().method_41748(class_4063.field_18163); // renderClouds:"fast"
        options.method_42503().method_41748(10); // renderDistance:10
        options.method_42510().method_41748(10);

        LOGGER.debug("Applied Minecraft performance settings");
    }

    private static void applyBalancedSettings(class_315 options) {
        // Balanced profile settings from options.txt
        options.method_41792().method_41748(true);
        options.method_41805().method_41748(2);
        options.method_42433().method_41748(false);
        options.method_42517().method_41748(1.0);
        options.method_42435().method_41748(true);
        options.method_42534().method_41748(class_5365.field_25428); // graphicsMode:1 = FANCY
        options.method_42524().method_41748(260);
        options.method_42563().method_41748(4);
        options.method_42475().method_41748(class_4066.field_18197); // particles:0 = ALL
        options.method_42528().method_41748(class_4063.field_18164); // renderClouds:"true"
        options.method_42503().method_41748(14); // renderDistance:14
        options.method_42510().method_41748(12);

        LOGGER.debug("Applied Minecraft balanced settings");
    }

    private static void applyQualitySettings(class_315 options) {
        // Quality profile settings from options.txt
        options.method_41792().method_41748(true);
        options.method_41805().method_41748(2);
        options.method_42433().method_41748(false);
        options.method_42517().method_41748(1.25);
        options.method_42435().method_41748(true);
        options.method_42534().method_41748(class_5365.field_25429); // graphicsMode:2 = FABULOUS
        options.method_42524().method_41748(260);
        options.method_42563().method_41748(4);
        options.method_42475().method_41748(class_4066.field_18197); // particles:0 = ALL
        options.method_42528().method_41748(class_4063.field_18164); // renderClouds:"true"
        //? if >=1.21.8 {
        
        /*options.getViewDistance().setValue(20); // renderDistance:20
         
        *///?} else {
        options.method_42503().method_41748(16); // renderDistance:16
        //?}
        options.method_42510().method_41748(12);

        LOGGER.debug("Applied Minecraft quality settings");
    }
}