/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.command.packcore;

import com.github.kd_gaming1.packcore.integration.tabdesign.TabDesignManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class TabDesignCommand {
    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tabdesign").then(ClientCommandManager.literal((String)"list").executes(TabDesignCommand::listTabDesigns))).then(ClientCommandManager.literal((String)"apply").then(ClientCommandManager.argument((String)"design", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("skyhanni");
            builder.suggest("skyblocker");
            return builder.buildFuture();
        }).executes(TabDesignCommand::applyTabDesign)));
    }

    private static int applyTabDesign(CommandContext<FabricClientCommandSource> context) {
        String designName = StringArgumentType.getString(context, (String)"design").toLowerCase();
        if (!designName.equals("skyhanni") && !designName.equals("skyblocker")) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Unknown tab design: " + designName)).method_27692(class_124.field_1061));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available designs: skyhanni, skyblocker").method_27692(class_124.field_1054));
            return 0;
        }
        TabDesignManager.TabDesignAvailability availability = TabDesignManager.getAvailability();
        if (designName.equals("skyhanni") && !availability.isSkyHanniAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u2717 SkyHanni mod is not installed!").method_27692(class_124.field_1061));
            return 0;
        }
        if (designName.equals("skyblocker") && !availability.isSkyblockerAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u2717 Skyblocker mod is not installed!").method_27692(class_124.field_1061));
            return 0;
        }
        String displayName = designName.equals("skyhanni") ? "SkyHanni Compact" : "Skyblocker Fancy";
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Applying tab design: " + displayName + "...")).method_27692(class_124.field_1054));
        CompletableFuture.runAsync(() -> {
            try {
                boolean success = TabDesignManager.applyTabDesign(designName);
                class_310.method_1551().execute(() -> {
                    if (success) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u2713 Tab design '" + displayName + "' applied successfully!")).method_27692(class_124.field_1060));
                        if (designName.equals("skyhanni")) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2139 SkyHanni Compact tab list is now active").method_27692(class_124.field_1080));
                        } else {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2139 Skyblocker Fancy tab HUD is now active").method_27692(class_124.field_1080));
                        }
                    } else {
                        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u26a0 Failed to apply tab design").method_27692(class_124.field_1054));
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  The mod may not be loaded properly").method_27692(class_124.field_1080));
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u2717 Failed to apply tab design: " + e.getMessage())).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int listTabDesigns(CommandContext<FabricClientCommandSource> context) {
        TabDesignManager.TabDesignAvailability availability = TabDesignManager.getAvailability();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== PackCore Tab Designs ===").method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Mods:").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 SkyHanni: " + (availability.isSkyHanniAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.isSkyHanniAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 Skyblocker: " + (availability.isSkyblockerAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.isSkyblockerAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)""));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Designs:").method_27692(class_124.field_1054));
        if (availability.isSkyHanniAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2022 SkyHanni Compact - Minimalist compact tab list").method_27692(class_124.field_1068));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"    Command: /packcore tabdesign apply skyhanni").method_27692(class_124.field_1080));
        }
        if (availability.isSkyblockerAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2022 Skyblocker Fancy - Feature-rich tab HUD").method_27692(class_124.field_1068));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"    Command: /packcore tabdesign apply skyblocker").method_27692(class_124.field_1080));
        }
        if (!availability.isSkyHanniAvailable() && !availability.isSkyblockerAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u26a0 No compatible tab design mods found").method_27692(class_124.field_1061));
        }
        return 1;
    }
}

