/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.imports;

import com.github.kd_gaming1.packcore.config.apply.ConfigApplyService;
import com.github.kd_gaming1.packcore.config.model.ConfigMetadata;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.util.task.ProgressListener;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigImportService.class);
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");

    public static CompletableFuture<Path> selectConfigFile() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1724 != null) {
                        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eFile browser opening... It may appear behind Minecraft. Check your taskbar!"), false);
                    }
                });
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Select Config File to Import (.zip with metadata)");
                fileChooser.setFileFilter(new FileNameExtensionFilter("Config Files (*.zip)", "zip"));
                fileChooser.setFileSelectionMode(0);
                fileChooser.setMultiSelectionEnabled(false);
                Path downloadsPath = Paths.get(System.getProperty("user.home"), "Downloads");
                if (Files.exists(downloadsPath, new LinkOption[0])) {
                    fileChooser.setCurrentDirectory(downloadsPath.toFile());
                }
                SwingUtilities.invokeLater(() -> {
                    Window[] windows;
                    for (Window window : windows = Window.getWindows()) {
                        if (!(window instanceof JDialog)) continue;
                        window.toFront();
                        window.requestFocus();
                    }
                });
                int result = fileChooser.showOpenDialog(null);
                if (result == 0) {
                    Path selectedFile = fileChooser.getSelectedFile().toPath();
                    LOGGER.info("Selected file: {}", (Object)selectedFile);
                    if (!selectedFile.toString().toLowerCase().endsWith(".zip")) {
                        LOGGER.warn("Selected file is not a zip: {}", (Object)selectedFile);
                        ConfigImportService.showErrorDialog("Invalid File", "Please select a .zip file containing a valid configuration.");
                        return null;
                    }
                    return selectedFile;
                }
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Error opening file dialog", (Throwable)e);
                ConfigImportService.showErrorDialog("Error", "Failed to open file browser: " + e.getMessage());
                return null;
            }
        });
    }

    private static void showErrorDialog(String title, String message) {
        SwingUtilities.invokeLater(() -> {
            JOptionPane optionPane = new JOptionPane(message, 0);
            JDialog dialog = optionPane.createDialog(title);
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
        });
    }

    public static ConfigMetadata previewConfig(Path configPath) {
        if (configPath == null || !Files.exists(configPath, new LinkOption[0])) {
            LOGGER.error("Config file does not exist: {}", (Object)configPath);
            return null;
        }
        if (!configPath.toString().toLowerCase().endsWith(".zip")) {
            LOGGER.error("File is not a zip: {}", (Object)configPath);
            return null;
        }
        ValidationResult validation = ConfigImportService.validateConfigZip(configPath);
        if (!validation.isValid) {
            LOGGER.error("Config validation failed: {}", (Object)validation.errorMessage);
            ConfigImportService.showErrorDialog("Invalid Config", validation.errorMessage);
            return null;
        }
        return ConfigFileRepository.readMetadataFromZip(configPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ValidationResult validateConfigZip(Path zipPath) {
        if (zipPath == null) return ValidationResult.invalid("File does not exist");
        if (!Files.exists(zipPath, new LinkOption[0])) {
            return ValidationResult.invalid("File does not exist");
        }
        if (!zipPath.toString().toLowerCase().endsWith(".zip")) {
            return ValidationResult.invalid("File must be a .zip file");
        }
        try {
            if (Files.size(zipPath) == 0L) {
                return ValidationResult.invalid("File is empty");
            }
        }
        catch (IOException e) {
            return ValidationResult.invalid("Cannot read file size");
        }
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            ValidationResult validationResult;
            boolean hasMetadata = false;
            boolean hasJarFiles = false;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.equals("packcore_metadata.json") || entryName.endsWith("/packcore_metadata.json")) {
                    hasMetadata = true;
                }
                if (!entryName.toLowerCase().endsWith(".jar")) continue;
                hasJarFiles = true;
                LOGGER.warn("Found .jar file in config: {}", (Object)entryName);
            }
            if (!hasMetadata) {
                validationResult = ValidationResult.invalid("Invalid config file: Missing packcore_metadata.json\n\nThis ZIP must contain configuration metadata to be imported.");
                return validationResult;
            }
            if (hasJarFiles) {
                validationResult = ValidationResult.invalid("Invalid config file: Contains .jar files\n\nConfiguration files should not contain mod .jar files.\nPlease use config files only.");
                return validationResult;
            }
            validationResult = ValidationResult.valid();
            return validationResult;
        }
        catch (IOException e) {
            LOGGER.error("Failed to validate config zip", (Throwable)e);
            return ValidationResult.invalid("Cannot read ZIP file: " + e.getMessage());
        }
    }

    public static void importConfig(Path sourceFile, boolean applyImmediately, ProgressListener callback) {
        if (callback == null) {
            callback = new ProgressListener(){

                @Override
                public void onProgress(String msg, int pct) {
                }

                @Override
                public void onComplete(boolean success, String msg) {
                }
            };
        }
        ProgressListener finalCallback = callback;
        CompletableFuture.runAsync(() -> {
            try {
                finalCallback.onProgress("Validating file...", 10);
                ValidationResult validation = ConfigImportService.validateConfigZip(sourceFile);
                if (!validation.isValid) {
                    finalCallback.onComplete(false, validation.errorMessage);
                    return;
                }
                finalCallback.onProgress("Reading metadata...", 30);
                ConfigMetadata metadata = ConfigFileRepository.readMetadataFromZip(sourceFile);
                if (metadata == null || !metadata.isValid()) {
                    finalCallback.onComplete(false, "Could not read config metadata or metadata is invalid");
                    return;
                }
                finalCallback.onProgress("Copying file...", 50);
                Path destination = ConfigImportService.copyToCustomConfigs(sourceFile, metadata);
                if (destination == null) {
                    finalCallback.onComplete(false, "Failed to copy config file");
                    return;
                }
                finalCallback.onProgress("Import complete", 80);
                if (applyImmediately) {
                    finalCallback.onProgress("Scheduling restart...", 90);
                    ConfigFileRepository.ConfigFile configFile = new ConfigFileRepository.ConfigFile(destination.getFileName().toString(), destination, false, metadata);
                    ConfigApplyService.scheduleConfigApplication(configFile);
                    finalCallback.onComplete(true, "Config imported and will be applied on restart.");
                } else {
                    finalCallback.onComplete(true, "Config imported successfully: " + metadata.getName());
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to import config", (Throwable)e);
                finalCallback.onComplete(false, "Import failed: " + e.getMessage());
            }
        });
    }

    private static Path copyToCustomConfigs(Path sourceFile, ConfigMetadata metadata) {
        try {
            Path gameDir = class_310.method_1551().field_1697.toPath();
            Path customConfigsDir = gameDir.resolve("packcore/modpack_config/custom_configs");
            Files.createDirectories(customConfigsDir, new FileAttribute[0]);
            String baseName = metadata.getName().replaceAll("[^a-zA-Z0-9\\-_]", "_");
            String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMAT);
            String fileName = baseName + "_" + timestamp + ".zip";
            Path destination = customConfigsDir.resolve(fileName);
            int counter = 1;
            while (Files.exists(destination, new LinkOption[0])) {
                fileName = baseName + "_" + timestamp + "_" + counter + ".zip";
                destination = customConfigsDir.resolve(fileName);
                ++counter;
            }
            Files.copy(sourceFile, destination, StandardCopyOption.COPY_ATTRIBUTES);
            LOGGER.info("Config imported to: {}", (Object)destination);
            return destination;
        }
        catch (IOException e) {
            LOGGER.error("Failed to copy config file", (Throwable)e);
            return null;
        }
    }

    public static boolean configExists(String configName) {
        if (configName == null || configName.isBlank()) {
            return false;
        }
        String sanitizedName = configName.replaceAll("[^a-zA-Z0-9\\-_]", "_").toLowerCase();
        return ConfigFileRepository.getAllConfigs().stream().anyMatch(config -> config.fileName().toLowerCase().contains(sanitizedName));
    }

    public record ValidationResult(boolean isValid, String errorMessage) {
        public static ValidationResult valid() {
            return new ValidationResult(true, null);
        }

        public static ValidationResult invalid(String message) {
            return new ValidationResult(false, message);
        }
    }
}

