/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.integration.itembackground;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.util.wizard.WizardDataStore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;

public class ItemBackgroundManager {
    private static final String SKYBLOCKER_MOD_ID = "skyblocker";
    private static final String CONFIG_MANAGER_CLASS = "de.hysky.skyblocker.config.SkyblockerConfigManager";
    private static final String ITEM_BACKGROUND_ENUM_CLASS = "de.hysky.skyblocker.config.configs.GeneralConfig$ItemBackgroundStyle";
    private static final float DEFAULT_OPACITY = 0.5f;

    public static boolean applyItemBackgroundFromWizard() {
        String itemBackground = WizardDataStore.getInstance().getItemBackground();
        if (ItemBackgroundManager.shouldSkipApplication(itemBackground)) {
            return true;
        }
        if (!ItemBackgroundManager.isSkyblockerLoaded()) {
            PackCore.LOGGER.warn("Skyblocker not loaded; cannot apply item background");
            return false;
        }
        String style = ItemBackgroundManager.mapToSkyblockerStyle(itemBackground);
        return ItemBackgroundManager.applyItemBackgroundStyle(style);
    }

    private static boolean applyItemBackgroundStyle(String style) {
        try {
            Class<?> configManager = Class.forName(CONFIG_MANAGER_CLASS);
            Method updateMethod = configManager.getDeclaredMethod("update", Consumer.class);
            Consumer<Object> configUpdater = config -> ItemBackgroundManager.updateItemBackgroundConfig(config, style);
            updateMethod.invoke(null, configUpdater);
            PackCore.LOGGER.info("Successfully applied Skyblocker item background change: {}", (Object)(style == null ? "DISABLE_BACKGROUNDS" : style));
            return true;
        }
        catch (ClassNotFoundException e) {
            PackCore.LOGGER.warn("Skyblocker config manager not found - mod may not be loaded correctly");
            return false;
        }
        catch (NoSuchMethodException e) {
            PackCore.LOGGER.warn("Skyblocker config update method not found - API may have changed");
            return false;
        }
        catch (Exception e) {
            PackCore.LOGGER.error("Unexpected error while applying item background config", (Throwable)e);
            return false;
        }
    }

    private static void updateItemBackgroundConfig(Object config, String style) {
        try {
            Field generalField = config.getClass().getField("general");
            Object general = generalField.get(config);
            Field itemInfoDisplayField = general.getClass().getField("itemInfoDisplay");
            Object itemInfoDisplay = itemInfoDisplayField.get(general);
            Field rarityBackgroundsField = itemInfoDisplay.getClass().getField("itemRarityBackgrounds");
            rarityBackgroundsField.setBoolean(itemInfoDisplay, style != null);
            if (style != null) {
                Class<?> styleEnum = Class.forName(ITEM_BACKGROUND_ENUM_CLASS);
                Object enumValue = Enum.valueOf(styleEnum, style);
                Field styleField = itemInfoDisplay.getClass().getField("itemBackgroundStyle");
                styleField.set(itemInfoDisplay, enumValue);
                Field opacityField = itemInfoDisplay.getClass().getField("itemBackgroundOpacity");
                opacityField.setFloat(itemInfoDisplay, 0.5f);
                PackCore.LOGGER.debug("Item background config updated: style={}, opacity={}", (Object)style, (Object)Float.valueOf(0.5f));
            } else {
                PackCore.LOGGER.debug("Item rarity backgrounds disabled via wizard selection");
            }
        }
        catch (NoSuchFieldException e) {
            PackCore.LOGGER.error("Required config field not found - Skyblocker structure may have changed: {}", (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            PackCore.LOGGER.error("Item background style enum not found - Skyblocker may have changed");
        }
        catch (IllegalAccessException e) {
            PackCore.LOGGER.error("Cannot access config fields - security restrictions may apply");
        }
        catch (Exception e) {
            PackCore.LOGGER.error("Unexpected error updating item background config", (Throwable)e);
        }
    }

    private static String mapToSkyblockerStyle(String wizardStyle) {
        if (wizardStyle == null) {
            return "SQUARE";
        }
        return switch (wizardStyle.toLowerCase().trim()) {
            case "circular" -> "CIRCULAR";
            case "square" -> "SQUARE";
            case "no background", "none" -> null;
            default -> {
                PackCore.LOGGER.warn("Unknown item background style '{}', defaulting to SQUARE", (Object)wizardStyle);
                yield "SQUARE";
            }
        };
    }

    private static boolean shouldSkipApplication(String itemBackground) {
        return itemBackground == null || itemBackground.isEmpty();
    }

    private static boolean isSkyblockerLoaded() {
        return FabricLoader.getInstance().isModLoaded(SKYBLOCKER_MOD_ID);
    }
}

