/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield;

import com.github.kd_gaming1.packcore.scamshield.detector.ConfidenceLevel;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamCategory;
import com.github.kd_gaming1.packcore.ui.screen.scamshield.ScamWarningScreen;

public class ScamShieldScreenIntegration {
    public static ScamWarningScreen.ScamWarning convertToWarning(DetectionResult result) {
        return new ScamWarningScreen.ScamWarning(result.getSender(), ScamShieldScreenIntegration.mapCategory(result.getPrimaryCategory()), result.getOriginalMessage(), ScamShieldScreenIntegration.mapConfidence(result.getConfidenceLevel()));
    }

    private static ScamWarningScreen.ScamType mapCategory(ScamCategory category) {
        return switch (category) {
            case ScamCategory.DISCORD_VERIFY, ScamCategory.PHISHING -> ScamWarningScreen.ScamType.PHISHING_LINK;
            case ScamCategory.FAKE_REWARD -> ScamWarningScreen.ScamType.FALSE_REWARDS;
            case ScamCategory.ACCOUNT_THEFT -> ScamWarningScreen.ScamType.COOP_SCAM;
            case ScamCategory.TRADE_MANIPULATION -> ScamWarningScreen.ScamType.PRICE_MANIPULATION;
            case ScamCategory.CRAFTING_SCAM -> ScamWarningScreen.ScamType.CRAFTING;
            case ScamCategory.BORROWING_SCAM -> ScamWarningScreen.ScamType.BORROWING;
            case ScamCategory.RANK_SELLING -> ScamWarningScreen.ScamType.RANK_SELLING;
            default -> ScamWarningScreen.ScamType.GENERAL;
        };
    }

    private static int mapConfidence(ConfidenceLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case ConfidenceLevel.LOW -> 60;
            case ConfidenceLevel.MEDIUM -> 80;
            case ConfidenceLevel.HIGH -> 95;
        };
    }

    public static String getDetectionSummary(DetectionResult result) {
        return "Category: " + result.getPrimaryCategory().getDisplayName() + " | Score: " + result.getTotalScore() + " | Confidence: " + result.getConfidenceLevel().getDisplayName();
    }

    public static boolean shouldShowWarningScreen(DetectionResult result) {
        return result.getConfidenceLevel() == ConfidenceLevel.HIGH;
    }

    public static String getEducationContentForCategory(ScamCategory category) {
        return null;
    }

    public static String getEducationSectionForCategory(ScamCategory category) {
        return switch (category) {
            case ScamCategory.DISCORD_VERIFY, ScamCategory.PHISHING -> "Phishing Links";
            case ScamCategory.FAKE_REWARD -> "False Rewards";
            case ScamCategory.ACCOUNT_THEFT -> "Co-op Island Stealing";
            case ScamCategory.TRADE_MANIPULATION -> "Price Manipulation";
            case ScamCategory.CRAFTING_SCAM -> "Crafting/Reforging Scams";
            case ScamCategory.BORROWING_SCAM -> "Borrowing/Loaning Scams";
            case ScamCategory.RANK_SELLING -> "Rank Selling";
            default -> null;
        };
    }
}

