/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.conversation;

public enum ConversationStage {
    INITIAL(0, "Initial Contact"),
    SETUP(1, "Setup Phase"),
    TRANSITION(2, "Platform Transition"),
    EXPLOITATION(3, "Credential Request"),
    PRESSURE(4, "Urgency Pressure");

    private final int level;
    private final String displayName;

    private ConversationStage(int level, String displayName) {
        this.level = level;
        this.displayName = displayName;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isMoreAdvancedThan(ConversationStage other) {
        return this.level > other.level;
    }

    public double getDangerMultiplier() {
        switch (this.ordinal()) {
            case 0: {
                return 0.5;
            }
            case 1: {
                return 1.0;
            }
            case 2: {
                return 1.5;
            }
            case 3: {
                return 2.5;
            }
            case 4: {
                return 3.0;
            }
        }
        return 1.0;
    }
}

