/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.debug;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.scamshield.debug.TestCase;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamDetector;
import java.util.ArrayList;
import java.util.List;

public class ScamShieldDebugger {
    private final ScamDetector detector = ScamDetector.getInstance();
    private final List<TestCase> testCases = this.createTestCases();

    public DebugReport runTests() {
        PackCore.LOGGER.info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        PackCore.LOGGER.info("\u2551          ScamShield Debug Test Suite - Starting...            \u2551");
        PackCore.LOGGER.info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        DebugReport report = new DebugReport();
        int testNumber = 1;
        for (TestCase testCase : this.testCases) {
            PackCore.LOGGER.info("");
            PackCore.LOGGER.info("\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
            PackCore.LOGGER.info("\u2502 Test #{}: {}", (Object)testNumber++, (Object)testCase.getName());
            PackCore.LOGGER.info("\u2502 Category: {}", (Object)testCase.getCategory());
            PackCore.LOGGER.info("\u2502 Description: {}", (Object)testCase.getDescription());
            PackCore.LOGGER.info("\u2502 Should Trigger: {} (Min Score: {})", (Object)testCase.shouldTrigger(), (Object)testCase.getExpectedMinScore());
            PackCore.LOGGER.info("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
            TestResult result = this.runTest(testCase);
            report.addResult(result);
            this.logTestResult(result);
        }
        this.logSummary(report);
        return report;
    }

    private TestResult runTest(TestCase testCase) {
        TestResult result = new TestResult(testCase);
        int messageNum = 1;
        this.detector.getContext().reset();
        for (TestCase.Message message : testCase.getConversation()) {
            if (message.getDelayMs() > 0L) {
                try {
                    Thread.sleep(message.getDelayMs());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            PackCore.LOGGER.info("  \u2502 Msg {}: [{}] {}", new Object[]{messageNum++, message.getSender(), message.getText()});
            DetectionResult detection = this.detector.analyze(message.getText(), message.getSender());
            result.addDetection(detection);
            if (detection.getTotalScore() <= 0) continue;
            PackCore.LOGGER.info("  \u2502   \u251c\u2500 Score: {} (Type: {}, Progression: {})", new Object[]{detection.getTotalScore(), detection.getScamTypeScore(), detection.getProgressionScore()});
            if (detection.getTriggeredScamTypes().isEmpty()) continue;
            PackCore.LOGGER.info("  \u2502   \u2514\u2500 Detected: {}", (Object)String.join((CharSequence)", ", detection.getTriggeredScamTypes()));
        }
        return result;
    }

    private void logTestResult(TestResult result) {
        boolean passed = result.isPassed();
        DetectionResult finalDetection = result.getFinalDetection();
        PackCore.LOGGER.info("");
        PackCore.LOGGER.info("  \u250c\u2500\u2500\u2500 RESULT \u2500\u2500\u2500");
        PackCore.LOGGER.info("  \u2502 Status: {}", (Object)(passed ? "\u2705 PASSED" : "\u274c FAILED"));
        PackCore.LOGGER.info("  \u2502 Final Score: {}", (Object)finalDetection.getTotalScore());
        PackCore.LOGGER.info("  \u2502 Triggered: {}", (Object)finalDetection.isTriggered());
        PackCore.LOGGER.info("  \u2502 Expected: {}", (Object)result.getTestCase().shouldTrigger());
        if (!passed) {
            PackCore.LOGGER.info("  \u2502 ");
            PackCore.LOGGER.info("  \u2502 \u26a0 FAILURE REASON:");
            if (result.getTestCase().shouldTrigger() && !finalDetection.isTriggered()) {
                PackCore.LOGGER.info("  \u2502   Expected to trigger but didn't!");
                PackCore.LOGGER.info("  \u2502   Score: {} / Required: {}", (Object)finalDetection.getTotalScore(), (Object)result.getTestCase().getExpectedMinScore());
            } else if (!result.getTestCase().shouldTrigger() && finalDetection.isTriggered()) {
                PackCore.LOGGER.info("  \u2502   Should NOT trigger but did!");
                PackCore.LOGGER.info("  \u2502   Score: {}", (Object)finalDetection.getTotalScore());
            } else if (finalDetection.getTotalScore() < result.getTestCase().getExpectedMinScore()) {
                PackCore.LOGGER.info("  \u2502   Score too low!");
                PackCore.LOGGER.info("  \u2502   Got: {} / Expected: {}", (Object)finalDetection.getTotalScore(), (Object)result.getTestCase().getExpectedMinScore());
            }
        }
        if (!finalDetection.getScamTypeContributions().isEmpty()) {
            PackCore.LOGGER.info("  \u2502 ");
            PackCore.LOGGER.info("  \u2502 Score Breakdown:");
            finalDetection.getScamTypeContributions().forEach((type, score) -> PackCore.LOGGER.info("  \u2502   \u2022 {}: {} points", type, score));
        }
        PackCore.LOGGER.info("  \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
    }

    private void logSummary(DebugReport report) {
        PackCore.LOGGER.info("");
        PackCore.LOGGER.info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        PackCore.LOGGER.info("\u2551                    TEST SUMMARY                                \u2551");
        PackCore.LOGGER.info("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        PackCore.LOGGER.info("\u2551 Total Tests:     {:>3}                                          \u2551", (Object)report.getTotalTests());
        PackCore.LOGGER.info("\u2551 Passed:          {:>3} ({}%)                                    \u2551", (Object)report.getPassedTests(), (Object)report.getPassRate());
        PackCore.LOGGER.info("\u2551 Failed:          {:>3}                                          \u2551", (Object)report.getFailedTests());
        PackCore.LOGGER.info("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        if (report.getFailedTests() > 0) {
            PackCore.LOGGER.info("\u2551 Failed Tests:                                                  \u2551");
            for (TestResult result : report.getResults()) {
                if (result.isPassed()) continue;
                Object truncated = result.getTestCase().getName();
                if (((String)truncated).length() > 55) {
                    truncated = ((String)truncated).substring(0, 52) + "...";
                }
                PackCore.LOGGER.info("\u2551   \u2022 {:<55} \u2551", truncated);
            }
        }
        PackCore.LOGGER.info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    private List<TestCase> createTestCases() {
        ArrayList<TestCase> cases = new ArrayList<TestCase>();
        cases.add(new TestCase.Builder().name("Discord Free Rank - Full Sequence").description("Exact pattern from research: free rank \u2192 discord \u2192 verify \u2192 code").category("Discord Verification").message("ScammerX", "Anyone wants a free rank /visit me!").message("ScammerX", "So you would like a free rank? add me friend on Discord!", 1200L).message("ScammerX", "my discord is ScammerX#1234", 800L).message("ScammerX", "How many coins do you have?", 1500L).message("ScammerX", "ok cool, now verify your email on the website", 1000L).message("ScammerX", "what code did microsoft send you?", 1200L).shouldTrigger(true).expectedMinScore(150).build());
        cases.add(new TestCase.Builder().name("Discord with Technical Excuse").description("Research pattern: 'My DM doesn't work, join the server'").category("Discord Verification").message("TechIssues", "hey bro").message("TechIssues", "wanna join tournament?", 700L).message("TechIssues", "add me on discord for details", 900L).message("TechIssues", "My DM doesn't work, join the server", 1100L).message("TechIssues", "you need to verify your minecraft account", 1300L).message("TechIssues", "link your account and enter email", 1000L).shouldTrigger(true).expectedMinScore(160).build());
        cases.add(new TestCase.Builder().name("Friendly Start \u2192 Sudden Discord Push").description("Tone shift: casual chat suddenly becomes credential fishing").category("Discord Verification").message("FriendlyGuy", "hey whats up").message("FriendlyGuy", "nice skin lol", 800L).message("FriendlyGuy", "you play skyblock?", 600L).message("FriendlyGuy", "cool cool", 500L).message("FriendlyGuy", "btw i have a discord server for sb players", 1000L).message("FriendlyGuy", "join quick", 600L).message("FriendlyGuy", "just verify with your minecraft email real quick", 1200L).shouldTrigger(true).expectedMinScore(110).build());
        cases.add(new TestCase.Builder().name("Staff Impersonation + Discord").description("Claims Hypixel staff, asks for Discord verification").category("Discord Verification").message("Hypixel_Admin", "hello i'm a hypixel moderator").message("Hypixel_Admin", "your account has been flagged", 1000L).message("Hypixel_Admin", "you need to verify immediately", 800L).message("Hypixel_Admin", "join official discord server", 700L).message("Hypixel_Admin", "verify your email and send the code", 1000L).shouldTrigger(true).expectedMinScore(180).build());
        cases.add(new TestCase.Builder().name("Free Coins with Party Command").description("Research: Do /p scammer to receive 5 million free coins").category("Free Rewards").message("CoinGiver", "Do /p CoinGiver to receive 5 million free coins!").message("CoinGiver", "Hey, go to scamsite.com to receive your coins!", 1500L).shouldTrigger(true).expectedMinScore(100).build());
        cases.add(new TestCase.Builder().name("Free Rank with Visit Command").description("Research pattern: Anyone wants a free rank /visit me").category("Free Rewards").message("RankGiver", "Anyone wants a free rank /visit me!").message("RankGiver", "visit my island to find out how!", 1000L).message("RankGiver", "you need discord for the rank", 1200L).shouldTrigger(true).expectedMinScore(120).build());
        cases.add(new TestCase.Builder().name("Item Flex Scam").description("Research: 'Visit me to flex your most expensive items! I will pay you 10%'").category("Free Rewards").message("ItemCollector", "Visit me to flex your most expensive items!").message("ItemCollector", "I will pay you 10% of the item price just to see the flex!", 1000L).message("ItemCollector", "how many coins do you have btw?", 800L).shouldTrigger(true).expectedMinScore(90).build());
        cases.add(new TestCase.Builder().name("Quitting SkyBlock - Island Theft").description("Research: I'm quitting SkyBlock! /coopadd to receive all my goodies").category("Free Rewards").message("QuittingPlayer", "I'm quitting SkyBlock!").message("QuittingPlayer", "/coopadd QuittingPlayer to receive all my goodies", 800L).message("QuittingPlayer", "including my Superior Dragon Armor set!", 600L).shouldTrigger(true).expectedMinScore(100).build());
        cases.add(new TestCase.Builder().name("BedWars Duel Scam").description("Research: Duel me for a Free Rank Upgrade (Must Win)").category("Tournament").message("DuelMaster", "Duel me for a Free Rank Upgrade (Must Win)").message("DuelMaster", "add me on discord after", 1500L).message("DuelMaster", "you need to verify to get the rank", 1200L).shouldTrigger(true).expectedMinScore(140).build());
        cases.add(new TestCase.Builder().name("Tournament Registration Scam").description("Fake tournament requiring Discord verification").category("Tournament").message("TourneyHost", "HYPIXEL TOURNAMENT EVENT!").message("TourneyHost", "10k members already joined", 800L).message("TourneyHost", "free mvp++ for all participants", 900L).message("TourneyHost", "join discord to register", 700L).message("TourneyHost", "Click this link to register for the tournament", 1000L).message("TourneyHost", "verify your minecraft account", 1100L).shouldTrigger(true).expectedMinScore(160).build());
        cases.add(new TestCase.Builder().name("Crafting Help Material Theft").description("Research: I have materials but no recipe, can someone help?").category("Crafting Scam").message("NeedsCrafter", "Hey, I have the materials to craft a Sea Creature Artifact").message("NeedsCrafter", "but I don't have the recipe unlocked. Can someone help?", 1200L).message("HelpfulScammer", "Sure! Give me the materials and I'll make it!", 1500L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Reverse Crafting Scam").description("Scammer asks for help, then runs with your coins").category("Crafting Scam").message("CrafterScam", "I need help on crafting a Juju Shortbow").message("CrafterScam", "but I need coins for collat. Can someone help?", 1000L).message("CrafterScam", "give me 50m and i'll craft it for you", 800L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Escalating Pressure Scam").description("Each message gets progressively more urgent and suspicious").category("Progression").message("Escalator", "hey", 400L).message("Escalator", "wanna party?", 600L).message("Escalator", "join my discord too", 800L).message("Escalator", "quick add me", 700L).message("Escalator", "verify your email NOW", 900L).message("Escalator", "SEND ME THE CODE IMMEDIATELY!!!", 1000L).shouldTrigger(true).expectedMinScore(130).build());
        cases.add(new TestCase.Builder().name("Four-Stage Phishing Sequence").description("Tests detection of all 4 phishing stages: bait \u2192 social \u2192 verify \u2192 credentials").category("Progression").message("PhishingPro", "free giveaway event!", 600L).message("PhishingPro", "join my party to participate", 800L).message("PhishingPro", "you need to verify to claim", 1000L).message("PhishingPro", "send me your email and the microsoft code", 1200L).shouldTrigger(true).expectedMinScore(140).build());
        cases.add(new TestCase.Builder().name("Wealth Inquiry Then Scam").description("Asks about wealth, then launches scam").category("Progression").message("WealthyScammer", "nice gear bro").message("WealthyScammer", "how much is your networth?", 900L).message("WealthyScammer", "damn thats a lot", 700L).message("WealthyScammer", "wanna double your coins?", 800L).message("WealthyScammer", "join my discord i'll show you", 1000L).message("WealthyScammer", "just verify quick", 1100L).shouldTrigger(true).expectedMinScore(120).build());
        cases.add(new TestCase.Builder().name("Normal Dungeon Party").description("Regular dungeon party formation").category("Legitimate").message("DungeonRunner", "hey wanna run f7?").message("DungeonRunner", "we need a healer", 800L).message("DungeonRunner", "bring good gear", 600L).message("DungeonRunner", "/p DungeonRunner when ready", 700L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Helpful Player Giving Advice").description("Player helping with game tips").category("Legitimate").message("HelpfulVet", "your talismans need reforging").message("HelpfulVet", "use strong reforge for damage", 900L).message("HelpfulVet", "also get some more accessories", 700L).message("HelpfulVet", "that'll help a lot", 600L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Trading Negotiation").description("Normal trading conversation").category("Legitimate").message("Trader", "selling necron armor 500m").message("Trader", "negotiable price", 800L).message("Trader", "meet at auction house?", 600L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Guild Recruitment").description("Guild invite - legitimate").category("Legitimate").message("GuildRecruiter", "hey we're looking for members").message("GuildRecruiter", "active guild with events", 900L).message("GuildRecruiter", "we have a discord for coordination", 800L).message("GuildRecruiter", "interested?", 600L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Friend Asking About Discord").description("Friend casually asking about Discord - not suspicious").category("Legitimate").message("RealFriend", "hey you on discord?").message("RealFriend", "easier to voice chat there for dungeons", 900L).message("RealFriend", "no worries if not lol", 700L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Party Chat Coordination").description("Normal party coordination").category("Legitimate").message("PartyLeader", "everyone ready?").message("PartyLeader", "start dungeon in 30 seconds", 500L).message("PartyLeader", "stick together this time", 600L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Auction House Discussion").description("Discussing auction house prices").category("Legitimate").message("AHPlayer", "whats the price of necron handle?").message("AHPlayer", "saw one for 600m earlier", 800L).message("AHPlayer", "is that a good deal?", 600L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Island Visit Request").description("Legitimate island visit request").category("Legitimate").message("IslandVisitor", "cool island dude").message("IslandVisitor", "can I visit to see your farm setup?", 900L).message("IslandVisitor", "trying to improve mine", 700L).shouldTrigger(false).expectedMinScore(0).build());
        cases.add(new TestCase.Builder().name("Legitimate Question Using Trigger Words").description("Someone genuinely asking about verification").category("Edge Case").message("NewPlayer", "quick question").message("NewPlayer", "how do i verify my email on hypixel?", 900L).message("NewPlayer", "is the verification safe?", 800L).message("NewPlayer", "never done it before", 700L).shouldTrigger(false).expectedMinScore(30).build());
        cases.add(new TestCase.Builder().name("Genuine Discord Server Mention").description("Someone mentioning their legitimate community Discord").category("Edge Case").message("CommunityMember", "we have a skyblock community discord").message("CommunityMember", "just for hanging out and trading", 1000L).message("CommunityMember", "no pressure to join", 800L).shouldTrigger(false).expectedMinScore(20).build());
        cases.add(new TestCase.Builder().name("Subtle Scam - Barely Over Threshold").description("Very subtle scam that should barely trigger").category("Edge Case").message("SubtleScammer", "hey wanna see something cool?").message("SubtleScammer", "check out this discord server", 1000L).message("SubtleScammer", "they're giving free stuff", 900L).message("SubtleScammer", "you just need to verify", 1100L).shouldTrigger(true).expectedMinScore(80).build());
        cases.add(new TestCase.Builder().name("Compromised Friend Account").description("Real friend account compromised, starts acting suspicious").category("Edge Case").message("BestFriend", "yo its me").message("BestFriend", "check this out", 800L).message("BestFriend", "free ranks here", 700L).message("BestFriend", "trust me bro join the discord", 900L).message("BestFriend", "verify your account there", 1000L).shouldTrigger(true).expectedMinScore(110).build());
        cases.add(new TestCase.Builder().name("Research Example: Rank Store Scam").description("Exact sequence from research document").category("Research Example").message("ResearchScammer", "Anyone wants a free rank /visit me!").message("ResearchScammer", "So you would like a free rank? add me friend on Discord!", 1500L).message("ResearchScammer", "How many coins do you have?", 1200L).message("ResearchScammer", "Give me the coins; I'll press enter then.", 1300L).shouldTrigger(true).expectedMinScore(150).build());
        cases.add(new TestCase.Builder().name("Research Example: BedWars Verification").description("From research: In bedwars, scammer asks to play duos then verify").category("Research Example").message("BedwarsScam", "wanna play bedwars duos?").message("BedwarsScam", "gg man good game", 2000L).message("BedwarsScam", "btw you interested in tournaments?", 1500L).message("BedwarsScam", "add me on discord", 1000L).message("BedwarsScam", "My DM doesn't work, join the server", 1200L).message("BedwarsScam", "you need to verify your minecraft account", 1300L).shouldTrigger(true).expectedMinScore(140).build());
        cases.add(new TestCase.Builder().name("Research Example: Auction Scam").description("From research: OMG HELP!! I accidentally put superior boots as BIN").category("Research Example").message("PanickedSeller", "OMG HELP!!").message("PanickedSeller", "I accidentally put superior boots on my AH as BIN for 3 million", 1000L).message("PanickedSeller", "how do I get it back??!", 800L).shouldTrigger(false).expectedMinScore(30).build());
        cases.add(new TestCase.Builder().name("Research Example: Co-op Island Theft").description("From research: Bogus co-op command trick").category("Research Example").message("CoopScammer", "I'm quitting SkyBlock!").message("CoopScammer", "/coopadd CoopScammer to receive all my goodies", 1200L).message("CoopScammer", "including my Superior Dragon Armor set!", 900L).shouldTrigger(true).expectedMinScore(100).build());
        cases.add(new TestCase.Builder().name("Research Example: Unbalanced Trade").description("From research: I want to buy your Aspect of the Dragons").category("Research Example").message("TradeScammer", "I want to buy your Aspect of the Dragons").message("TradeScammer", "I'll offer you clean Old Dragon Boots for it", 1000L).message("TradeScammer", "I'm offering more than what your sword is worth", 900L).shouldTrigger(false).expectedMinScore(20).build());
        cases.add(new TestCase.Builder().name("All Tactics Combined").description("Urgency + Authority + Scarcity + Verification + Credentials").category("Multi-Tactic").message("MasterScammer", "URGENT im hypixel staff", 400L).message("MasterScammer", "your account has suspicious activity", 800L).message("MasterScammer", "only you have been selected for verification", 700L).message("MasterScammer", "verify NOW or you'll be banned", 900L).message("MasterScammer", "join discord immediately", 600L).message("MasterScammer", "send your email and microsoft code ASAP", 1000L).shouldTrigger(true).expectedMinScore(200).build());
        cases.add(new TestCase.Builder().name("Slow Burn Social Engineering").description("Long conversation building trust before scam").category("Multi-Tactic").message("PatientScammer", "hey").message("PatientScammer", "nice skin", 1500L).message("PatientScammer", "you play skyblock?", 1200L).message("PatientScammer", "cool what's your skill average?", 1300L).message("PatientScammer", "nice dude", 1000L).message("PatientScammer", "btw i run a skyblock community", 1500L).message("PatientScammer", "we do giveaways and events", 1200L).message("PatientScammer", "wanna join the discord?", 1000L).message("PatientScammer", "quick just verify your minecraft account", 1400L).shouldTrigger(true).expectedMinScore(100).build());
        return cases;
    }

    public static class DebugReport {
        private final List<TestResult> results = new ArrayList<TestResult>();

        public void addResult(TestResult result) {
            this.results.add(result);
        }

        public int getTotalTests() {
            return this.results.size();
        }

        public int getPassedTests() {
            return (int)this.results.stream().filter(TestResult::isPassed).count();
        }

        public int getFailedTests() {
            return this.getTotalTests() - this.getPassedTests();
        }

        public int getPassRate() {
            if (this.getTotalTests() == 0) {
                return 0;
            }
            return this.getPassedTests() * 100 / this.getTotalTests();
        }

        public List<TestResult> getResults() {
            return new ArrayList<TestResult>(this.results);
        }
    }

    public static class TestResult {
        private final TestCase testCase;
        private final List<DetectionResult> detections = new ArrayList<DetectionResult>();

        public TestResult(TestCase testCase) {
            this.testCase = testCase;
        }

        public void addDetection(DetectionResult result) {
            this.detections.add(result);
        }

        public TestCase getTestCase() {
            return this.testCase;
        }

        public DetectionResult getFinalDetection() {
            return this.detections.isEmpty() ? DetectionResult.SAFE : this.detections.get(this.detections.size() - 1);
        }

        public boolean isPassed() {
            DetectionResult finalResult = this.getFinalDetection();
            if (this.testCase.shouldTrigger()) {
                return finalResult.isTriggered() && finalResult.getTotalScore() >= this.testCase.getExpectedMinScore();
            }
            return !finalResult.isTriggered();
        }
    }
}

