/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.configmanager;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.export.ConfigExportService;
import com.github.kd_gaming1.packcore.notification.ExportNotifications;
import com.github.kd_gaming1.packcore.ui.component.PlaceholderTextArea;
import com.github.kd_gaming1.packcore.ui.component.tree.FileTreeNode;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ConfigManagerScreen;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportConfigScreen
extends BasePackCoreScreen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private static final String DEFAULT_VERSION = "1.0.0";
    private final ScheduledExecutorService asyncExecutor;
    private final ConfigExportService exportManager;
    private final Set<Path> selectedPaths = ConcurrentHashMap.newKeySet();
    private final Map<String, Boolean> modsToInclude = new LinkedHashMap<String, Boolean>();
    private FileTreeNode rootNode;
    private FlowLayout treeContainer;
    private FlowLayout contentPanel;
    private LabelComponent selectionInfoLabel;
    private ButtonComponent nextButton;
    private TextBoxComponent nameField;
    private TextAreaComponent descriptionArea;
    private TextBoxComponent versionField;
    private TextBoxComponent authorField;
    private ButtonComponent resolutionButton;
    private FlowLayout modsListContainer;
    private boolean showingMetadata = false;
    private String selectedResolution;
    private String currentResolution;
    private final Map<FileTreeNode, FlowLayout> nodeRowCache = new ConcurrentHashMap<FileTreeNode, FlowLayout>();
    private final Map<FileTreeNode, CheckboxComponent> nodeCheckboxCache = new ConcurrentHashMap<FileTreeNode, CheckboxComponent>();
    private volatile boolean isLoading = false;
    private FlowLayout exportProgressDialog;
    private LabelComponent exportProgressLabel;
    private volatile boolean exportInBackground = false;
    private volatile String currentExportName = "";

    public ExportConfigScreen() {
        super((class_437)new ConfigManagerScreen());
        this.asyncExecutor = Executors.newScheduledThreadPool(2);
        this.exportManager = new ConfigExportService();
        this.detectCurrentResolution();
        CompletableFuture.runAsync(() -> {
            this.rootNode = this.exportManager.buildFileTree();
            this.scanMods();
        }, this.asyncExecutor).thenRun(() -> class_310.method_1551().execute(() -> {
            if (this.treeContainer != null) {
                this.displayInitialTree();
            }
        }));
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)("Export Configuration - " + PackCore.getModpackInfo().getName())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(-1));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createContentArea());
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = ScreenUIComponents.createSidebar(35);
        FlowLayout scrollContent = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(8);
        scrollContent.child(this.createInfoSection());
        scrollContent.child((Component)this.createPresetSection());
        scrollContent.child((Component)this.createSelectionInfo());
        sidebar.child(ScreenUIComponents.createScrollContainer(scrollContent));
        this.nextButton = ScreenUIComponents.createButton("Next: Add Details", btn -> this.showMetadataView(), 120, 20);
        this.nextButton.active(false);
        sidebar.child((Component)this.nextButton).horizontalAlignment(HorizontalAlignment.CENTER);
        return sidebar;
    }

    private Component createInfoSection() {
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)8));
        section.child(Components.label((class_2561)class_2561.method_43470((String)"Select files and folders to include in your configuration export.")).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)100)));
        return section;
    }

    private FlowLayout createPresetSection() {
        FlowLayout section = ScreenUIComponents.createSection("Quick Presets", 0);
        section.horizontalAlignment(HorizontalAlignment.CENTER);
        for (ConfigExportService.PresetType preset : ConfigExportService.PresetType.values()) {
            section.child((Component)ScreenUIComponents.createButton(preset.getDisplayName(), btn -> this.applyPreset(preset), 90, 19));
        }
        return section;
    }

    private FlowLayout createSelectionInfo() {
        FlowLayout section = ScreenUIComponents.createSection("Selection Info", 0);
        section.horizontalAlignment(HorizontalAlignment.CENTER);
        this.selectionInfoLabel = Components.label((class_2561)class_2561.method_43470((String)"0 items selected\nSize: 0 KB")).color(UITheme.color(-5195576));
        section.child((Component)this.selectionInfoLabel);
        return section;
    }

    private FlowLayout createContentArea() {
        this.contentPanel = ScreenUIComponents.createInfoPanel(65);
        this.showFileTreeView();
        return this.contentPanel;
    }

    private void showFileTreeView() {
        this.contentPanel.clearChildren();
        this.showingMetadata = false;
        this.updateNextButton();
        this.contentPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select Files to Export").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        this.treeContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content());
        ScrollContainer<FlowLayout> treeScrollContainer = ScreenUIComponents.createScrollContainer(this.treeContainer);
        this.contentPanel.child(treeScrollContainer);
        if (this.rootNode == null) {
            this.treeContainer.child((Component)ScreenUIComponents.createEmptyState("Loading files..."));
        } else {
            this.displayInitialTree();
        }
    }

    private void displayInitialTree() {
        if (this.treeContainer == null || this.rootNode == null) {
            return;
        }
        this.treeContainer.clearChildren();
        this.nodeRowCache.clear();
        this.nodeCheckboxCache.clear();
        for (FileTreeNode child : this.rootNode.getChildren()) {
            this.addTreeNodeOptimized(child, 0);
        }
    }

    private void addTreeNodeOptimized(FileTreeNode node, int depth) {
        if (node.isHidden() || depth > 10) {
            return;
        }
        FlowLayout nodeRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).padding(Insets.left((int)(depth * 16))).verticalAlignment(VerticalAlignment.CENTER);
        if (node.isDirectory() && (!node.getChildren().isEmpty() || node.hasUnloadedChildren())) {
            nodeRow.child(Components.button((class_2561)class_2561.method_43470((String)(node.isExpanded() ? "\u25bc" : "\u25b6")), btn -> this.toggleNodeExpansion(node)).renderer(ButtonComponent.Renderer.flat((int)-1070978518, (int)-18355, (int)-11184811)).sizing(Sizing.fixed((int)16), Sizing.fixed((int)16)));
        } else {
            BoxComponent placeholder = Components.box((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16));
            placeholder.fill(true);
            placeholder.color(Color.ofArgb((int)0));
            nodeRow.child((Component)placeholder);
        }
        boolean isSelected = this.selectedPaths.contains(node.getPath());
        CheckboxComponent checkbox = Components.checkbox((class_2561)class_2561.method_43473()).checked(isSelected).onChanged(checked -> this.toggleSelectionAsync(node, (boolean)checked));
        nodeRow.child((Component)checkbox);
        this.nodeCheckboxCache.put(node, checkbox);
        String icon = node.isDirectory() ? "\ud83d\udcc1" : "\ud83d\udcc4";
        nodeRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)(icon + " " + node.getName()))).color(UITheme.color(isSelected ? -18355 : -1)));
        this.nodeRowCache.put(node, nodeRow);
        this.treeContainer.child((Component)nodeRow);
        if (node.isDirectory() && node.isExpanded() && node.isChildrenLoaded()) {
            for (FileTreeNode child : node.getChildren()) {
                this.addTreeNodeOptimized(child, depth + 1);
            }
        }
    }

    private void toggleNodeExpansion(FileTreeNode node) {
        if (this.isLoading) {
            return;
        }
        if (!node.isExpanded() && !node.isChildrenLoaded()) {
            this.isLoading = true;
            this.showLoadingForNode(node);
            CompletableFuture.runAsync(() -> this.exportManager.loadNodeChildren(node), this.asyncExecutor).thenRun(() -> class_310.method_1551().execute(() -> {
                node.setExpanded(true);
                this.updateNodeExpansion(node);
                this.isLoading = false;
            }));
        } else {
            node.setExpanded(!node.isExpanded());
            this.updateNodeExpansion(node);
        }
    }

    private void showLoadingForNode(FileTreeNode node) {
        Component firstChild;
        FlowLayout nodeRow = this.nodeRowCache.get(node);
        if (nodeRow != null && !nodeRow.children().isEmpty() && (firstChild = (Component)nodeRow.children().getFirst()) instanceof ButtonComponent) {
            ButtonComponent btn = (ButtonComponent)firstChild;
            btn.method_25355((class_2561)class_2561.method_43470((String)"\u23f3"));
        }
    }

    private void updateNodeExpansion(FileTreeNode node) {
        Component firstChild;
        int nodeIndex = -1;
        for (int i = 0; i < this.treeContainer.children().size(); ++i) {
            if (this.treeContainer.children().get(i) != this.nodeRowCache.get(node)) continue;
            nodeIndex = i;
            break;
        }
        if (nodeIndex == -1) {
            return;
        }
        FlowLayout nodeRow = this.nodeRowCache.get(node);
        if (nodeRow != null && !nodeRow.children().isEmpty() && (firstChild = (Component)nodeRow.children().getFirst()) instanceof ButtonComponent) {
            ButtonComponent btn = (ButtonComponent)firstChild;
            btn.method_25355((class_2561)class_2561.method_43470((String)(node.isExpanded() ? "\u25bc" : "\u25b6")));
        }
        if (node.isExpanded()) {
            boolean parentSelected = this.selectedPaths.contains(node.getPath());
            int depth = this.calculateDepth(node);
            int insertIndex = nodeIndex + 1;
            for (FileTreeNode child : node.getChildren()) {
                if (parentSelected) {
                    this.selectedPaths.add(child.getPath());
                    if (child.isDirectory()) {
                        this.addDescendantsAsync(child);
                    }
                }
                if (this.nodeRowCache.containsKey(child)) continue;
                this.createNodeRow(child, depth + 1, insertIndex++);
            }
            if (parentSelected) {
                this.updateSelectionInfo();
            }
        } else {
            this.removeChildrenFromTree(node);
        }
    }

    private void createNodeRow(FileTreeNode node, int depth, int insertIndex) {
        if (node.isHidden()) {
            return;
        }
        FlowLayout nodeRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).padding(Insets.left((int)(depth * 16))).verticalAlignment(VerticalAlignment.CENTER);
        if (node.isDirectory() && (!node.getChildren().isEmpty() || node.hasUnloadedChildren())) {
            nodeRow.child(Components.button((class_2561)class_2561.method_43470((String)(node.isExpanded() ? "\u25bc" : "\u25b6")), btn -> this.toggleNodeExpansion(node)).renderer(ButtonComponent.Renderer.flat((int)-1070978518, (int)-18355, (int)-11184811)).sizing(Sizing.fixed((int)16), Sizing.fixed((int)16)));
        } else {
            BoxComponent placeholder = Components.box((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16));
            placeholder.fill(true);
            placeholder.color(Color.ofArgb((int)0));
            nodeRow.child((Component)placeholder);
        }
        boolean isSelected = this.selectedPaths.contains(node.getPath());
        CheckboxComponent checkbox = Components.checkbox((class_2561)class_2561.method_43473()).checked(isSelected).onChanged(checked -> this.toggleSelectionAsync(node, (boolean)checked));
        nodeRow.child((Component)checkbox);
        this.nodeCheckboxCache.put(node, checkbox);
        String icon = node.isDirectory() ? "\ud83d\udcc1" : "\ud83d\udcc4";
        nodeRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)(icon + " " + node.getName()))).color(UITheme.color(isSelected ? -18355 : -1)));
        this.nodeRowCache.put(node, nodeRow);
        ArrayList<FlowLayout> children = new ArrayList<FlowLayout>(this.treeContainer.children());
        children.add(Math.min(insertIndex, children.size()), nodeRow);
        this.treeContainer.clearChildren();
        children.forEach(arg_0 -> ((FlowLayout)this.treeContainer).child(arg_0));
        if (node.isDirectory() && node.isExpanded() && node.isChildrenLoaded()) {
            int childIndex = insertIndex + 1;
            for (FileTreeNode child : node.getChildren()) {
                this.createNodeRow(child, depth + 1, childIndex++);
            }
        }
    }

    private void removeChildrenFromTree(FileTreeNode node) {
        for (FileTreeNode child : node.getChildren()) {
            FlowLayout childRow = this.nodeRowCache.remove(child);
            this.nodeCheckboxCache.remove(child);
            if (childRow != null) {
                this.treeContainer.removeChild((Component)childRow);
            }
            if (!child.isDirectory()) continue;
            this.removeChildrenFromTree(child);
        }
    }

    private int calculateDepth(FileTreeNode node) {
        FlowLayout nodeRow = this.nodeRowCache.get(node);
        if (nodeRow == null) {
            return 0;
        }
        Insets padding = (Insets)nodeRow.padding().get();
        return padding.left() / 16;
    }

    private void toggleSelectionAsync(FileTreeNode node, boolean selected) {
        CompletableFuture.runAsync(() -> {
            if (selected) {
                this.selectedPaths.add(node.getPath());
                if (node.isDirectory()) {
                    if (!node.isChildrenLoaded()) {
                        this.exportManager.loadNodeChildren(node);
                    }
                    this.addDescendantsAsync(node);
                }
            } else {
                this.selectedPaths.remove(node.getPath());
                if (node.isDirectory()) {
                    if (!node.isChildrenLoaded()) {
                        this.exportManager.loadNodeChildren(node);
                    }
                    this.removeDescendantsAsync(node);
                }
            }
        }, this.asyncExecutor).thenRun(() -> class_310.method_1551().execute(() -> {
            this.updateNodeVisualsRecursive(node);
            this.updateSelectionInfo();
        }));
    }

    private void addDescendantsAsync(FileTreeNode node) {
        for (FileTreeNode child : node.getChildren()) {
            this.selectedPaths.add(child.getPath());
            if (!child.isDirectory()) continue;
            this.addDescendantsAsync(child);
        }
    }

    private void removeDescendantsAsync(FileTreeNode node) {
        for (FileTreeNode child : node.getChildren()) {
            this.selectedPaths.remove(child.getPath());
            if (!child.isDirectory()) continue;
            this.removeDescendantsAsync(child);
        }
    }

    private void updateNodeVisualsRecursive(FileTreeNode node) {
        CheckboxComponent checkbox = this.nodeCheckboxCache.get(node);
        if (checkbox != null) {
            checkbox.checked(this.selectedPaths.contains(node.getPath()));
        }
        if (node.isDirectory() && node.isExpanded()) {
            for (FileTreeNode child : node.getChildren()) {
                this.updateNodeVisualsRecursive(child);
            }
        }
    }

    private void updateSelectionInfo() {
        CompletableFuture.supplyAsync(() -> {
            int count = this.selectedPaths.size();
            long size = this.exportManager.calculateSelectionSize(this.selectedPaths);
            return new SelectionInfo(count, size);
        }, this.asyncExecutor).thenAccept(info -> class_310.method_1551().execute(() -> {
            String sizeText = ScreenUIComponents.formatSize(info.size);
            this.selectionInfoLabel.text((class_2561)class_2561.method_43470((String)(info.count + " item" + (info.count != 1 ? "s" : "") + " selected\nSize: " + sizeText)));
            this.updateNextButton();
        }));
    }

    private void updateNextButton() {
        this.nextButton.active(!this.selectedPaths.isEmpty() && !this.showingMetadata);
        if (this.showingMetadata) {
            this.nextButton.method_25355((class_2561)class_2561.method_43470((String)"Currently editing..."));
        } else {
            this.nextButton.method_25355((class_2561)class_2561.method_43470((String)"Next: Add Details"));
        }
    }

    private void applyPreset(ConfigExportService.PresetType preset) {
        CompletableFuture.supplyAsync(() -> {
            Set<Path> presetPaths = this.exportManager.getPresetPaths(preset);
            this.selectedPaths.clear();
            for (Path path : presetPaths) {
                FileTreeNode node = this.findNodeByPath(this.rootNode, path);
                if (node == null) continue;
                this.selectedPaths.add(node.getPath());
                if (!node.isDirectory()) continue;
                this.addDescendantsAsync(node);
            }
            return presetPaths;
        }, this.asyncExecutor).thenAccept(paths -> class_310.method_1551().execute(() -> {
            this.nodeCheckboxCache.forEach((node, checkbox) -> checkbox.checked(this.selectedPaths.contains(node.getPath())));
            this.updateSelectionInfo();
        }));
    }

    private FileTreeNode findNodeByPath(FileTreeNode currentNode, Path targetPath) {
        if (currentNode.getPath().equals(targetPath)) {
            return currentNode;
        }
        for (FileTreeNode child : currentNode.getChildren()) {
            FileTreeNode result = this.findNodeByPath(child, targetPath);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void scanMods() {
        List<String> mods = this.exportManager.scanInstalledMods();
        this.modsToInclude.clear();
        for (String mod : mods) {
            this.modsToInclude.put(mod, true);
        }
    }

    private void showMetadataView() {
        this.contentPanel.clearChildren();
        this.showingMetadata = true;
        this.updateNextButton();
        this.contentPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Configuration Details").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        FlowLayout formContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(8);
        this.nameField = Components.textBox((Sizing)Sizing.fill((int)70), (String)"");
        this.nameField.method_47404((class_2561)class_2561.method_43470((String)"Enter configuration name"));
        formContainer.child((Component)this.createFormRow("Name*:", (Component)this.nameField));
        this.descriptionArea = PlaceholderTextArea.create(Sizing.fill((int)70), Sizing.fixed((int)80), (class_2561)class_2561.method_43470((String)"Describe what this configuration does..."));
        formContainer.child((Component)this.createFormRow("Description:", (Component)this.descriptionArea));
        this.versionField = Components.textBox((Sizing)Sizing.fixed((int)120), (String)DEFAULT_VERSION);
        formContainer.child((Component)this.createFormRow("Version:", (Component)this.versionField));
        this.authorField = Components.textBox((Sizing)Sizing.fill((int)70), (String)class_310.method_1551().method_1548().method_1676());
        formContainer.child((Component)this.createFormRow("Author:", (Component)this.authorField));
        this.populateResolutionDropdown();
        formContainer.child((Component)this.createFormRow("Target Resolution:", (Component)this.resolutionButton));
        formContainer.child(Components.label((class_2561)class_2561.method_43470((String)"Installed mods when the configs was exported:")).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)100)));
        FlowLayout modsListWrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)125)).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811))).padding(Insets.of((int)8));
        this.modsListContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.bottom((int)8));
        modsListWrapper.child(ScreenUIComponents.createScrollContainer(this.modsListContainer).sizing(Sizing.fill((int)100), Sizing.fixed((int)120)));
        formContainer.child((Component)modsListWrapper);
        this.populateModsList();
        this.contentPanel.child(ScreenUIComponents.createScrollContainer(formContainer));
        FlowLayout buttonRow = ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Back", btn -> this.showFileTreeView(), 90, 20), ScreenUIComponents.createButton("Export", btn -> this.showExportWarningDialog()));
        buttonRow.margins(Insets.top((int)6));
        this.contentPanel.child((Component)buttonRow);
    }

    private FlowLayout createFormRow(String label, Component field) {
        FlowLayout row = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        row.child(Components.label((class_2561)class_2561.method_43470((String)label)).color(UITheme.color(-1)).sizing(Sizing.fixed((int)60), Sizing.content()));
        row.child(field);
        return row;
    }

    private void populateResolutionDropdown() {
        this.resolutionButton = ScreenUIComponents.createButton(this.currentResolution, btn -> this.openResolutionDropdown(), 120, 20);
        this.selectedResolution = this.currentResolution;
    }

    private void openResolutionDropdown() {
        List<String> commonResolutions = List.of("1280\u00d7720", "1920\u00d71080", "1920\u00d71200", "2560\u00d71440", "2560\u00d71080", "3440\u00d71440", "3840\u00d72160", this.currentResolution);
        List uniqueResolutions = commonResolutions.stream().distinct().toList();
        DropdownComponent.openContextMenu((class_437)this, (ParentComponent)((FlowLayout)this.uiAdapter.rootComponent), FlowLayout::child, (double)this.resolutionButton.x(), (double)(this.resolutionButton.y() + this.resolutionButton.height()), dropdown -> {
            for (String resolution : uniqueResolutions) {
                dropdown.button((class_2561)class_2561.method_43470((String)resolution), selectedDropdown -> {
                    this.selectedResolution = resolution;
                    this.currentResolution = resolution;
                    this.resolutionButton.method_25355((class_2561)class_2561.method_43470((String)resolution));
                    assert (selectedDropdown.parent() != null);
                    selectedDropdown.parent().removeChild((Component)selectedDropdown);
                });
            }
            dropdown.divider();
            dropdown.button((class_2561)class_2561.method_43470((String)"Custom..."), selectedDropdown -> {
                this.openCustomResolutionDialog();
                assert (selectedDropdown.parent() != null);
                selectedDropdown.parent().removeChild((Component)selectedDropdown);
            });
        }).zIndex(8);
    }

    private void openCustomResolutionDialog() {
        FlowLayout dialog = ScreenUIComponents.createDialog("Enter Custom Resolution", null, 300);
        TextBoxComponent customResolutionField = Components.textBox((Sizing)Sizing.fixed((int)200), (String)"1920x1080");
        customResolutionField.method_47404((class_2561)class_2561.method_43470((String)"Width x Height (e.g. 1920x1080)"));
        dialog.child((Component)customResolutionField);
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 60, 20), ScreenUIComponents.createButton("OK", btn -> {
            String customRes = customResolutionField.method_1882().trim();
            if (customRes.matches("\\d+x\\d+")) {
                this.selectedResolution = customRes;
                this.currentResolution = customRes;
                this.resolutionButton.method_25355((class_2561)class_2561.method_43470((String)customRes));
            }
            this.closeTopOverlay();
        }, 60, 20)));
        this.showOverlay(dialog, false);
    }

    private void populateModsList() {
        this.modsListContainer.clearChildren();
        if (this.modsToInclude.isEmpty()) {
            this.modsListContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No mods found")).color(UITheme.color(-5195576)));
            return;
        }
        for (Map.Entry<String, Boolean> entry : this.modsToInclude.entrySet()) {
            CheckboxComponent checkbox = Components.checkbox((class_2561)class_2561.method_43470((String)entry.getKey())).checked(entry.getValue().booleanValue()).onChanged(checked -> this.modsToInclude.put((String)entry.getKey(), (Boolean)checked));
            this.modsListContainer.child((Component)checkbox);
        }
    }

    private void detectCurrentResolution() {
        class_310 mc = class_310.method_1551();
        this.currentResolution = mc.method_22683().method_4480() + "x" + mc.method_22683().method_4507();
    }

    private void showExportWarningDialog() {
        FlowLayout dialog = ScreenUIComponents.createWarningDialog("Export Warning", null, 400);
        FlowLayout warningText = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Important Notice:")).color(UITheme.color(-1)).margins(Insets.bottom((int)4)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 The export will run in the background")).color(UITheme.color(-1)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 A progress indicator will show the status")).color(UITheme.color(-1)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 You can continue using the interface")).color(UITheme.color(-1)).margins(Insets.bottom((int)8)));
        dialog.child((Component)warningText);
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 80, 20), ScreenUIComponents.createButton("Continue Export", btn -> {
            this.closeTopOverlay();
            this.performAsyncExport();
        }, 120, 20)));
        this.showOverlay(dialog, false);
    }

    private void performAsyncExport() {
        String name = this.nameField.method_1882().trim();
        if (name.isEmpty()) {
            this.showErrorDialog("Configuration name is required!");
            return;
        }
        this.currentExportName = name;
        this.exportInBackground = false;
        this.showExportProgressDialog();
        List<String> includedMods = this.modsToInclude.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        ConfigExportService.ExportRequest request = new ConfigExportService.ExportRequest(new HashSet<Path>(this.selectedPaths), name, this.descriptionArea.method_44405().trim(), this.versionField.method_1882().trim(), this.authorField.method_1882().trim(), this.selectedResolution, includedMods);
        CompletableFuture.runAsync(() -> {
            try {
                this.updateExportProgress("Copying files...");
                Path exportedPath = this.exportManager.exportConfigAsync(request, this::updateExportProgress);
                class_310.method_1551().execute(() -> {
                    this.closeExportProgressDialog();
                    ExportNotifications.notifyExportComplete(this.currentExportName, exportedPath);
                    if (class_310.method_1551().field_1755 == this) {
                        try {
                            class_156.method_668().method_672(exportedPath.getParent().toFile());
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to auto-open export folder", (Throwable)e);
                        }
                    }
                    if (!this.exportInBackground) {
                        this.shutdownExecutor();
                        class_310.method_1551().method_1507((class_437)new ConfigManagerScreen());
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Failed to export configuration", (Throwable)e);
                class_310.method_1551().execute(() -> {
                    this.closeExportProgressDialog();
                    this.showErrorDialog("Export failed: " + e.getMessage());
                });
            }
        }, this.asyncExecutor);
    }

    private void showExportProgressDialog() {
        this.exportProgressDialog = ScreenUIComponents.createDialog("Exporting Configuration", null, 350);
        this.exportProgressDialog.positioning(Positioning.absolute((int)((this.field_22789 - 350) / 2), (int)((this.field_22790 - 150) / 2)));
        this.exportProgressDialog.zIndex(15);
        this.exportProgressLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Preparing export...")).color(UITheme.color(-1)).margins(Insets.bottom((int)12));
        this.exportProgressDialog.child((Component)this.exportProgressLabel);
        FlowLayout buttonRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER);
        ButtonComponent backgroundButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Continue in Background"), btn -> {
            this.exportInBackground = true;
            this.closeExportProgressDialog();
        }).horizontalSizing(Sizing.content());
        buttonRow.child((Component)backgroundButton);
        this.exportProgressDialog.child((Component)buttonRow);
        this.rootComponent.child((Component)this.exportProgressDialog);
    }

    private void updateExportProgress(String message) {
        class_310.method_1551().execute(() -> {
            if (this.exportProgressLabel != null && !this.exportInBackground) {
                this.exportProgressLabel.text((class_2561)class_2561.method_43470((String)message));
            }
        });
    }

    private void closeExportProgressDialog() {
        class_310.method_1551().execute(() -> {
            if (this.exportProgressDialog != null) {
                this.rootComponent.removeChild((Component)this.exportProgressDialog);
                this.exportProgressDialog = null;
                this.exportProgressLabel = null;
            }
        });
    }

    private void showErrorDialog(String message) {
        FlowLayout dialog = ScreenUIComponents.createDialog("Error", message, 350);
        dialog.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-1096636)));
        dialog.positioning(Positioning.absolute((int)((this.field_22789 - 350) / 2), (int)((this.field_22790 - 120) / 2)));
        dialog.zIndex(20);
        dialog.child(ScreenUIComponents.createButton("OK", btn -> this.rootComponent.removeChild((Component)dialog), 80, 20).horizontalSizing(Sizing.content()));
        this.rootComponent.child((Component)dialog);
    }

    private void shutdownExecutor() {
        if (this.asyncExecutor != null && !this.asyncExecutor.isShutdown()) {
            this.asyncExecutor.shutdown();
            try {
                if (!this.asyncExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.asyncExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.asyncExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void method_25419() {
        this.shutdownExecutor();
        super.method_25419();
    }

    private record SelectionInfo(int count, long size) {
    }
}

