/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.scamshield;

import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.util.markdown.MarkdownService;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ScamEducationScreen
extends BasePackCoreScreen {
    private String markdownContent;
    private static final String FALLBACK_CONTENT = "# Hypixel SkyBlock Scam Prevention Guide\n\n## Introduction\n\nScamming is the act of stealing money, items, or accounts from another player through deception or trickery.\nThis guide will help you identify and avoid the most common scams in Hypixel SkyBlock.\n\n{gold}**Important:** Victims of scams will not have their items returned under any circumstances.{gold}\n\n---\n\n## Golden Rules\n\n1. **If it seems too good to be true, it probably is**\n2. **Never give items to someone you don't trust**\n3. **Always double-check trades before accepting**\n4. **Enable API and check player stats**\n5. **Never click suspicious links**\n\n---\n\n## Common Scam Types\n\n### \ud83c\udfaf Price Manipulation\nScammers artificially inflate or deflate item prices to trick you into bad trades.\n\n**How to avoid:**\n- Check multiple sources for prices (Bazaar, Auction House)\n- Use price checking tools\n- Don't trust \"limited time offers\"\n\n### \ud83d\udcb0 Unbalanced Trades\nOffering less valuable items disguised as expensive ones.\n\n**How to avoid:**\n- Hover over items to verify their exact name\n- Check item stats and abilities\n- Use a resource pack to distinguish similar items\n\n### \ud83c\udf81 False Rewards\nPromising rare items or coins for auction bids.\n\n**How to avoid:**\n- Never bid on items expecting \"bonus rewards\"\n- Check if player is actually quitting (SkyCrypt)\n- Remember: legitimate players just give items away\n\n### \ud83d\udd28 Crafting/Reforging Scams\nAsking for materials to craft items but stealing them.\n\n**How to avoid:**\n- Only trade with trusted friends\n- Check if they have the required recipes (API enabled)\n- Meet the crafting requirements yourself, or ask a close friend you personally know to help\n\n### \ud83e\udd1d Borrowing/Loaning Scams\nBorrowing items and never returning them.\n\n**How to avoid:**\n- Don't lend items to strangers\n- If you must loan items, be aware that scammers may provide worthless collateral or never return items. It's recommends simply not to loan to people you don't know well.\n- Better yet: meet requirements yourself\n\n### \ud83d\udd04 Item Switching\nShowing expensive item then swapping for cheap lookalike.\n\n**How to avoid:**\n- Always verify the exact item before accepting\n- If they cancel and retry, check EXTRA carefully\n- Take your time, don't rush trades\n\n### \ud83d\udc51 Rank Selling\nClaiming they can give you ranks for in-game items.\n\n**How to avoid:**\n- Ranks can ONLY be purchased on store.hypixel.net\n- Players cannot give other players ranks\n- This is always 100% a scam\n\n### \ud83c\udff0 Dungeon Carry Scams\nNot paying after carry or taking payment without carrying.\n\n**How to avoid:**\n- Use trusted carry services from official Discord\n- Check carrier's Catacombs level and gear\n- Agree on payment terms before starting\n\n### \ud83c\udfdd\ufe0f Co-op Island Stealing\nJoining co-op to steal items or kick you out.\n\n**How to avoid:**\n- NEVER add strangers to co-op\n- Only co-op with people you completely trust\n- Remember: /coopadd invites them to YOUR island\n\n### \ud83d\udd17 Phishing Links\nFake websites designed to steal your account.\n\n**How to avoid:**\n- Never click links in Minecraft chat\n- Only log in at minecraft.net and hypixel.net\n- Use URL scanners if you must check a link\n- Hypixel staff will NEVER DM you in-game\n\n---\n\n## Red Flags \ud83d\udea9\n\nWatch out for these warning signs:\n\n- Player asks you to disable API\n- Deal requires multiple trades\n- Player is rushing you\n- \"Limited time offer\"\n- Asking for collateral when they have recipes\n- New account with expensive items\n- Multiple trade cancellations\n- Pressure tactics (\"last chance!\", \"hurry!\")\n\n---\n\n## Reporting Scammers\n\nIf you encounter a scammer:\n\n1. **Screenshot evidence** (F2 in Minecraft)\n2. **Report via** `/report [player] [reason]`\n3. **Report on forums** with evidence\n4. **Warn others** in your guild/party\n\n{red}**Remember:** You won't get items back, but reporting helps protect others!{red}\n\n---\n\n## Protection Tools\n\n- **SkyBlockAddons** - Has scam protection features\n- **NEU (NotEnoughUpdates)** - Shows item prices\n- **SkyCrypt** - Check player profiles\n- **Hypixel API** - Verify player stats\n\n---\n\n## Stay Safe!\n\nThe best protection is knowledge and caution. Take your time with trades, verify everything,\nand trust your instincts. If something feels wrong, it probably is.\n\n{gold}**Remember: Your items are YOUR responsibility. Stay alert and trade smart!**{gold}\n";

    public ScamEducationScreen(class_437 parentScreen, String markdownContent) {
        this(parentScreen);
        this.markdownContent = markdownContent;
    }

    public ScamEducationScreen(class_437 parentScreen) {
        super(parentScreen);
        MarkdownService markdownService = new MarkdownService();
        this.markdownContent = markdownService.getOrDefault("scam_education.md", FALLBACK_CONTENT);
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)"Scam Protection Education").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofRgb((int)-18355)).shadow(true).margins(Insets.of((int)0, (int)0, (int)4, (int)4));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8).padding(Insets.of((int)8));
        mainContent.child((Component)this.createWarningBanner());
        mainContent.child((Component)this.createQuickTips());
        mainContent.child(this.createMarkdownContent());
        return mainContent;
    }

    private FlowLayout createWarningBanner() {
        FlowLayout banner = ScreenUIComponents.createWarningCard("Stay Alert!", "Scammers are constantly finding new ways to steal your items. If something seems too good to be true, it probably is. Always verify and be carefull when interacting with others.");
        banner.margins(Insets.of((int)4, (int)0, (int)8, (int)0));
        return banner;
    }

    private FlowLayout createQuickTips() {
        FlowLayout tipsSection = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        tipsSection.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a1 Quick Tips").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-18355)));
        FlowLayout tipsContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(8);
        tipsContainer.child((Component)this.createTipCard("\ud83d\udd12", "Protect Your Account", "Never share your password or session ID with anyone \u2014 even if they claim to be staff."));
        tipsContainer.child((Component)this.createTipCard("\ud83c\udf10", "Avoid Suspicious Links", "Never click on unknown links or login pages sent by other players."));
        tipsContainer.child((Component)this.createTipCard("\ud83d\udcb0", "If It\u2019s Too Good to Be True...", "Free coins, items, or giveaways are almost always scams."));
        tipsContainer.child((Component)this.createTipCard("\ud83e\udd1d", "Trade Safely", "Double-check items and coins in every trade \u2014 scammers may switch items."));
        tipsContainer.child((Component)this.createTipCard("\ud83e\udde0", "Stay Informed", "Learn about common scams by doing '/scamshield education' to protect yourself."));
        ScrollContainer<FlowLayout> tipsScroll = ScreenUIComponents.createScrollBoxHorizontal(tipsContainer);
        tipsScroll.sizing(Sizing.fill((int)100), Sizing.fixed((int)96));
        tipsSection.child(tipsScroll);
        return tipsSection;
    }

    private FlowLayout createTipCard(String icon, String title, String description) {
        FlowLayout card = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)260), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11890462))).padding(Insets.of((int)8)).horizontalAlignment(HorizontalAlignment.CENTER);
        card.child((Component)Components.label((class_2561)class_2561.method_43470((String)icon)).color(Color.ofRgb((int)-18355)));
        card.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)));
        card.child(Components.label((class_2561)class_2561.method_43470((String)description)).color(Color.ofRgb((int)-5195576)).horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill((int)90)));
        return card;
    }

    private ScrollContainer<FlowLayout> createMarkdownContent() {
        FlowLayout wrapper = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(4);
        wrapper.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udcda Complete Scam Guide").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-18355)));
        return WizardUIComponents.createMarkdownScroll(this.markdownContent);
    }
}

