/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLayoutInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLayoutInitializer.class);
    private static final Path RUN_DIR = FabricLoader.getInstance().getGameDir();
    private static boolean hasInitialized = false;

    public static void initializeFileStructure() {
        if (hasInitialized) {
            LOGGER.info("File structure already initialized, skipping...");
            return;
        }
        LOGGER.info("Initializing PackCore file structure...");
        try {
            FileLayoutInitializer.createDirectories();
            FileLayoutInitializer.createDefaultMarkdownFiles();
            hasInitialized = true;
            LOGGER.info("PackCore file structure initialization complete");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize PackCore file structure", (Throwable)e);
        }
    }

    private static void createDirectories() throws IOException {
        Map<String, String> directories = Map.of("packcore/modpack_config/official_configs", "Official modpack configurations", "packcore/modpack_config/custom_configs", "Custom modpack configurations", "packcore/wizard_markdown_content", "Information and help markdown files", "packcore/guides", "User guides and documentation");
        for (Map.Entry<String, String> entry : directories.entrySet()) {
            Path dirPath = RUN_DIR.resolve(entry.getKey());
            Files.createDirectories(dirPath, new FileAttribute[0]);
            LOGGER.info("Created directory: {} - {}", (Object)dirPath, (Object)entry.getValue());
        }
    }

    private static void createDefaultMarkdownFiles() {
        FileLayoutInitializer.createMarkdownFile("packcore/guides", "Getting Started.md", FileLayoutInitializer.getGettingStartedContent());
        FileLayoutInitializer.createMarkdownFile("packcore/guides", "FAQ.md", FileLayoutInitializer.getFAQContent());
        FileLayoutInitializer.createMarkdownFile("packcore/guides", "Troubleshooting.md", FileLayoutInitializer.getTroubleshootingContent());
        FileLayoutInitializer.createMarkdownFile("packcore/wizard_markdown_content", "Welcome.md", FileLayoutInitializer.getWelcomeContent());
        FileLayoutInitializer.createMarkdownFile("packcore/wizard_markdown_content", "Optimisation.md", FileLayoutInitializer.getOptimisationContent());
        FileLayoutInitializer.createMarkdownFile("packcore/wizard_markdown_content", "ResourcePacks.md", FileLayoutInitializer.getResourcePacksContent());
        FileLayoutInitializer.createMarkdownFile("packcore/wizard_markdown_content", "UsefulInformation.md", FileLayoutInitializer.getUsefulInformationContent());
    }

    private static void createMarkdownFile(String directory, String fileName, String content) {
        Path filePath = RUN_DIR.resolve(directory).resolve(fileName);
        if (Files.exists(filePath, new LinkOption[0])) {
            LOGGER.debug("Markdown file already exists, skipping: {}", (Object)filePath);
            return;
        }
        try {
            String fullContent = content + "\n\n---\n\n> **\ud83d\udcdd Edit this file:** Navigate to `" + directory + "/" + fileName + "` in your game directory to customize this content.\n> **\ud83d\udd04 Refresh:** Restart the game or reopen the menu to see your changes.";
            Files.writeString(filePath, (CharSequence)fullContent, StandardOpenOption.CREATE_NEW);
            LOGGER.info("Created markdown file with instructions: {}", (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create markdown file: {}", (Object)filePath, (Object)e);
        }
    }

    public static String getMarkdownContentSafe(String directory, String fileName, String fallbackContent) {
        Path filePath = RUN_DIR.resolve(directory).resolve(fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOGGER.warn("Markdown file not found: {}, using fallback content", (Object)filePath);
            return fallbackContent + "\n\n> **File not found:** Expected at `" + directory + "/" + fileName + "`";
        }
        try {
            return Files.readString(filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read markdown file: {}", (Object)filePath, (Object)e);
            return fallbackContent + "\n\n> **Error reading file:** " + e.getMessage();
        }
    }

    private static String getGettingStartedContent() {
        return "# Getting Started with PackCore\n\nWelcome to PackCore! This guide will help you get familiar with the modpack.\n\n## First Steps\n\n1. **Apply a Configuration** - Use the config manager to apply optimized settings\n2. **Check Your Keybinds** - Press `ESC > Options > Controls` to see all mod keybinds\n3. **Explore the Interface** - Many mods add new UI elements and features\n\n## Key Features\n\n- **Optimized Performance** - Pre-configured settings for smooth gameplay\n- **Enhanced UI** - Improved interfaces and helpful overlays\n- **Quality of Life** - Many small improvements to make the game more enjoyable\n\n## Need Help?\n\n- Press `F1` in-game for contextual help\n- Check the other guides in this menu\n- Join our Discord community for live support\n";
    }

    private static String getFAQContent() {
        return "# Frequently Asked Questions\n\n## General Questions\n\n**Q: How do I reset my settings?**\nA: Delete the `packcore` folder in your game directory and restart.\n\n**Q: Can I add my own mods?**\nA: Yes, but be careful about compatibility. Check mod requirements first.\n\n**Q: Why is my performance poor?**\nA: Try applying a lower resolution configuration profile.\n\n## Technical Issues\n\n**Q: The game crashes on startup**\nA: Check your Java version and allocated memory. See the Troubleshooting guide.\n\n**Q: Mods aren't working properly**\nA: Try pressing F3+T to reload resources, or restart the game.\n\n## Getting More Help\n\nIf your question isn't answered here, check the Troubleshooting guide or join our Discord.\n";
    }

    private static String getTroubleshootingContent() {
        return "# Troubleshooting Guide\n\n## Common Issues and Solutions\n\n### Game Won't Start\n\n1. **Check Java Version** - Ensure you're using Java 21 or newer\n2. **Memory Allocation** - Allocate at least 4GB RAM to Minecraft\n3. **Mod Conflicts** - Remove recently added mods one by one\n\n### Performance Issues\n\n1. **Lower Settings** - Reduce render distance and graphics quality\n2. **Update Drivers** - Ensure your graphics drivers are current\n3. **Close Other Programs** - Free up system resources\n\n### Visual Glitches\n\n1. **Reload Resources** - Press F3+T in-game\n2. **Check Resource Packs** - Disable resource packs temporarily\n3. **Update Graphics Drivers** - Especially important for shader support\n\n## Still Need Help?\n\n1. **Check Logs** - Look in `.minecraft/logs/latest.log` for error messages\n2. **Discord Support** - Join our community for live help\n3. **GitHub Issues** - Report bugs on our GitHub repository\n\n## System Requirements\n\n- **Java:** 21 or newer\n- **RAM:** 6GB minimum, 8GB recommended\n- **Graphics:** OpenGL 3.2 support required\n";
    }

    private static String getWelcomeContent() {
        return "# \ud83c\udfae Welcome to PackCore!\n\nThank you for choosing **PackCore**! This modpack provides an optimized experience for your gameplay.\n\n## \ud83d\ude80 Key Features\n\n- **\ud83d\udd0d Automatic Configuration** - Smart config detection and application on first launch\n- **\ud83d\udca1 Optimized Performance** - Pre-configured settings for smooth gameplay\n- **\u2699 Config Manager** - Import, export, and apply configurations in-game\n- **\ud83c\udfaf Resolution Profiles** - Optimized settings for different screen resolutions\n\n## \ud83d\udccb Getting Started\n\n1. **First Launch** - The mod automatically detects your screen resolution and applies the best config\n2. **In-Game Config Manager** - Access it from the main menu or ESC menu to manage configurations\n3. **Import/Export** - Share configurations with friends or create your own\n\n---\n\n## \ud83d\udca1 About Configurations\n\nEach configuration package contains:\n- **Optimized game settings** for your resolution\n- **Mod interface layouts** positioned for best visibility\n- **Performance tweaks** to ensure smooth gameplay\n- **Resource pack selections** that complement your setup\n\n> **Need help?** Check the other guides in this menu or join our Discord community!\n";
    }

    private static String getOptimisationContent() {
        return "# \u26a1 Optimisation Tips\n\nGet the most out of your modpack with these optimization tips!\n\n## Video Settings\n\n## Performance Mods\n\nThe modpack includes several performance-enhancing mods. Make sure they're properly configured in their respective settings.\n\n## Memory Allocation\n\n- **Recommended:** 6-8GB for optimal performance\n- **Minimum:** 4GB for basic gameplay\n- Configure in your launcher settings\n\n";
    }

    private static String getResourcePacksContent() {
        return "# \ud83c\udfa8 Resource Pack Selection\n\nChoose the visual style that best fits your preferences!\n\n## Available Packs:\n\n### **Hypixel Plus**\nA clean, mostly vanilla pack designed for Hypixel modes like SkyBlock. Updates items and icons for better clarity without changing the overall Minecraft feel.\n\n### **FurfSky Overlay**\nA comprehensive resource pack for Hypixel SkyBlock, offering textures for nearly every item in the game with special styled retextures for items only.\n\n### **FurfSky Full**\nA comprehensive resource pack for Hypixel SkyBlock with full retextures for both items and menus in a special artistic style.\n\n### **SkyBlock Dark UI**\nA sleek, dark-themed resource pack for Hypixel SkyBlock, enhancing all GUI elements including mod interfaces with a modern aesthetic.\n\n### **Defrosted**\nIcy-themed 16x pack for Minecraft 1.21.5 with a frosty blue aesthetic across items and menus, maintaining minimalist clarity.\n\n### **Looshy**\nA smooth, vanilla-like 16x resource pack with clean updates and subtle charm that keeps Minecraft's original style while offering refined textures.\n\n## \ud83d\udca1 Tips:\n\n- You can select multiple packs - they'll be applied in order\n- Resource packs can be changed later in the game settings\n- Some packs work better together than others\n";
    }

    private static String getUsefulInformationContent() {
        return "# \u2139 Useful Information\n\n## Config Management\n\n- **Import Config:** Import configurations from zip files\n- **Export Config:** Create and share your own configurations\n- **Apply Config:** Switch between different configuration profiles\n\n## Backup & Restore\n\nBackups are automatically created before applying new configurations.\nFind them in: `packcore/backups/`\n\n## Community\n\nJoin our Discord for support, updates, and to share your configurations!\n";
    }

    public static void forceReinitialize() {
        hasInitialized = false;
        FileLayoutInitializer.initializeFileStructure();
    }

    public static boolean isInitialized() {
        return hasInitialized;
    }
}

