{gold}**Hypixel SkyBlock Scam Prevention Guide**{}

> Scamming means stealing coins, items, or accounts through lies or tricks.
> This guide helps you spot scams and avoid them.

{gold}**Important:** Victims of scams will not get items back in any case.{}




{gold}**Golden Rules**{}

1. **If it looks too good to be true, it is**
2. **Never hand items to someone you do not trust**
3. **Double-check trades before you click accept**
4. **Enable API and check player stats**
5. **Do not click weird or unknown links**




{gold}**Common Scam Types**{}


{yellow}**Price Manipulation**{}

Scammers push prices up or down to trick you.

**Avoid it**
- Check Bazaar and Auction House
- Use price check mods
- Ignore “limited offer” deals


{yellow}**Unbalanced Trades**{}

Cheap items disguised as rare items.


**Avoid it**
- Hover items to read names
- Check stats before trading
- Use packs that show item differences


{yellow}**False Rewards**{}

“Bid on this and get free items!”


**Avoid it**
- Do not bid expecting rewards
- Check player SkyCrypt
- Real players just give items away


{yellow}**Crafting or Reforge Scams**{}

They ask for mats, then steal them.


**Avoid it**
- Only trade with trusted friends
- Check they have recipes (API on)
- Best choice: unlock recipes yourself


{yellow}**Borrowing and Loan Scams**{}

They ask to “borrow,” then vanish.


**Avoid it**
- Never loan items to strangers
- Collateral does not make it safe
- Best choice: do not loan gear at all


{yellow}**Item Switching**{}

Show good item, switch to a fake copy.


**Avoid it**
- Check item before you accept
- If they cancel and redo, inspect again
- Take your time


{yellow}**Rank Selling**{}

“Give me coins and I give rank.”


**Avoid it**
- Ranks only from store.hypixel.net
- Players cannot give ranks
- Always a scam


{yellow}**Dungeon Carry Scams**{}

No carry after payment or reverse.


**Avoid it**
- Use trusted Discord carry services
- Check Catacombs level
- Agree payment first


{yellow}**Co-op Island Theft**{yellow}

They join, steal, or kick you.


**Avoid it**
- Never co-op strangers
- Only co-op trusted real friends
- `/coopadd` gives them your island access


{yellow}**Phishing Links**{}

Fake login sites steal your account.


**Avoid it**
- Never click chat links
- Login only at hypixel.net and minecraft.net
- Hypixel staff do not DM you in-game




{gold}**Red Flags** 🚩{}

Watch out for:

- They ask you to turn off API
- Trade needs many steps
- They rush you
- “Only now” or “last chance”
- They ask for collateral but have recipes unlocked
- New account with rich gear
- Trade canceling over and over
- Pressure to hurry




{gold}**Reporting Scammers**{}

Do this if scammed or see one:

1. Take screenshots (F2)
2. Use `/report [name] [reason]`
3. Report on forums with proof
4. Warn others in guild or party

{red}You will not get items back. Reporting protects others.{}




{gold}**Tools To Protect You**{}

- **Skyblocker** – price info
- **SkyCrypt** – check players



{gold}**Stay Safe**{}

Stay calm when trading.

Check items, check players, trust your gut.

If something feels wrong, stop.

{gold}**Your items are your responsibility. Stay sharp. Trade safe.**{}