package com.github.kd_gaming1.packcore.command.packcore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class HelpCommand {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("help").executes(HelpCommand::execute);
    }

    private static int execute(CommandContext<FabricClientCommandSource> context) {
        var source = context.getSource();

        source.sendFeedback(class_2561.method_43470("═══════════════════════════════════").method_27692(class_124.field_1065));
        source.sendFeedback(class_2561.method_43470("    PackCore Commands Help").method_27695(class_124.field_1065, class_124.field_1067));
        source.sendFeedback(class_2561.method_43470("═══════════════════════════════════").method_27692(class_124.field_1065));
        source.sendFeedback(class_2561.method_43470(""));

        // Setup & Configuration
        source.sendFeedback(class_2561.method_43470("⚙ Setup & Configuration:").method_27695(class_124.field_1054, class_124.field_1067));
        sendCommand(source, "/packcore wizard", "Open the setup wizard");
        sendCommand(source, "/packcore configmanager", "Open config manager GUI");
        sendCommand(source, "/packcore menu toggle", "Enable/disable custom menu");
        sendCommand(source, "/packcore menu enable", "Enable custom menu");
        sendCommand(source, "/packcore menu disable", "Disable custom menu");
        source.sendFeedback(class_2561.method_43470(""));

        // Performance & Design
        source.sendFeedback(class_2561.method_43470("🚀 Performance & Design:").method_27695(class_124.field_1054, class_124.field_1067));
        sendCommand(source, "/packcore performance list", "List performance profiles");
        sendCommand(source, "/packcore performance apply <profile>", "Apply performance profile");
        sendCommand(source, "/packcore tabdesign list", "List available tab designs");
        sendCommand(source, "/packcore tabdesign apply <design>", "Apply tab design");
        source.sendFeedback(class_2561.method_43470(""));

        // Information
        source.sendFeedback(class_2561.method_43470("ℹ Information:").method_27695(class_124.field_1054, class_124.field_1067));
        sendCommand(source, "/packcore status", "Show current status");
        sendCommand(source, "/packcore guide", "Open guide system");
        sendCommand(source, "/packcore help", "Show this help message");

        source.sendFeedback(class_2561.method_43470(""));
        source.sendFeedback(class_2561.method_43470("═══════════════════════════════════").method_27692(class_124.field_1065));
        source.sendFeedback(class_2561.method_43470("💡 Tip: Click any command to copy it!").method_27695(class_124.field_1080, class_124.field_1056));

        return 1;
    }

    private static void sendCommand(FabricClientCommandSource source, String command, String description) {
        class_5250 commandText = class_2561.method_43470("  " + command)
                .method_27692(class_124.field_1060)
                .method_27694(style -> style
                        .method_10958(new class_2558.class_10610(command))
                        .method_10949(new class_2568.class_10613(
                                class_2561.method_43470("Click to copy command").method_27692(class_124.field_1054))));

        class_5250 descText = class_2561.method_43470(" - " + description).method_27692(class_124.field_1080);

        source.sendFeedback(commandText.method_10852(descText));
    }

}