package com.github.kd_gaming1.packcore.ui.component;

import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

/**
 * Extended TextAreaComponent that supports placeholder text
 */
public class PlaceholderTextArea extends TextAreaComponent {
    @Nullable
    private class_2561 placeholder;
    private int placeholderColor = 0x808080; // Gray color for placeholder text

    protected PlaceholderTextArea(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    /**
     * Sets the placeholder text that will be displayed when the text area is empty and not focused
     */
    public PlaceholderTextArea placeholder(class_2561 placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    /**
     * Sets the color of the placeholder text
     */
    public PlaceholderTextArea placeholderColor(int color) {
        this.placeholderColor = color;
        return this;
    }

    @Override
    protected void method_44384(class_332 context) {
        // Call the parent render method first
        super.method_44384(context);

        // Render placeholder if text is empty and component is not focused
        if (this.placeholder != null && this.method_44405().isEmpty() && !this.method_25370()) {
            renderPlaceholder(context);
        }
    }

    private void renderPlaceholder(class_332 context) {
        var textRenderer = class_310.method_1551().field_1772;

        // Calculate position similar to how TextFieldWidget does it
        int x = this.method_46426() + 4; // Add padding
        int y = this.method_46427() + 4; // Add padding

        // Draw the placeholder text
        context.method_27535(textRenderer, this.placeholder, x, y, this.placeholderColor);
    }

    /**
     * Factory method to create a new PlaceholderTextAreaComponent
     */
    public static PlaceholderTextArea create(Sizing horizontalSizing, Sizing verticalSizing) {
        return new PlaceholderTextArea(horizontalSizing, verticalSizing);
    }

    /**
     * Factory method to create a new PlaceholderTextAreaComponent with placeholder text
     */
    public static PlaceholderTextArea create(Sizing horizontalSizing, Sizing verticalSizing, class_2561 placeholder) {
        return new PlaceholderTextArea(horizontalSizing, verticalSizing).placeholder(placeholder);
    }
}