/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.introduction;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.gui.help.BaseWizardPage;
import com.github.kd_gaming1.packcore.gui.help.ConfigurationApplicationService;
import com.github.kd_gaming1.packcore.gui.help.WizardDataManager;
import com.github.kd_gaming1.packcore.gui.titlescreen.fancy.FancyMainMenuScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class IntroductionScreenPageFinal
extends BaseWizardPage {
    private final WizardDataManager dataManager;
    private LabelComponent statusLabel;
    private ButtonComponent applyButton;
    private FlowLayout progressContainer;
    private FlowLayout warningBanner;
    private Map<String, LabelComponent> stepLabels = new LinkedHashMap<String, LabelComponent>();
    private boolean shouldShowSkipButton = false;

    public IntroductionScreenPageFinal() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Apply Configuration"), 5, 5), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        this.dataManager = WizardDataManager.getInstance();
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.gap(4);
        contentContainer.child((Component)this.createHeader());
        contentContainer.child((Component)this.createConfigurationSummary());
        this.warningBanner = this.createWarningBanner();
        contentContainer.child((Component)this.warningBanner);
        contentContainer.child((Component)this.createProgressSection());
        contentContainer.child((Component)this.createStatusSection());
        contentContainer.child((Component)this.createActionButtons());
        this.initializeUIState();
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        contentContainerRight.child((Component)this.createHelpSection());
    }

    private void initializeUIState() {
        if (this.dataManager.isConfigurationApplying()) {
            this.progressContainer.positioning(Positioning.layout());
            this.updateApplyButtonState(true, "Applying Settings...");
            this.updateStatusLabel("\u23f3 Please wait while we apply your settings...", class_124.field_1054);
            this.updatePrimaryButtonState(false);
        } else if (this.dataManager.isConfigurationApplied()) {
            String result = this.dataManager.getConfigurationResult();
            if ("success".equals(result)) {
                this.onConfigurationApplied();
            } else if ("failed".equals(result)) {
                this.onConfigurationFailed(null, new RuntimeException(this.dataManager.getConfigurationErrorMessage()));
            }
            this.updatePrimaryButtonState(this.dataManager.isConfigurationApplied());
        } else {
            this.updatePrimaryButtonState(false);
        }
    }

    private FlowLayout createHeader() {
        FlowLayout header = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        LabelComponent title = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"\u2728 Ready to Apply Your Settings!").method_10862(class_2583.field_24360.method_36139(-10496).method_10982(Boolean.TRUE))).horizontalSizing(Sizing.fill((int)98)).margins(Insets.of((int)2));
        LabelComponent subtitle = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Review your choices below. When you're ready, click 'Apply Settings' to activate everything.").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).horizontalSizing(Sizing.fill((int)98)).margins(Insets.of((int)2));
        header.child((Component)title).child((Component)subtitle);
        return header;
    }

    private FlowLayout createConfigurationSummary() {
        FlowLayout summaryContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)553637632).and(Surface.outline((int)-10496))).padding(Insets.of((int)6));
        summaryContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udccb What You've Selected:").method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)-10496))).horizontalSizing(Sizing.fill((int)98));
        String optimizationProfile = this.dataManager.getOptimizationProfile();
        summaryContainer.child((Component)this.createSummaryItem("\ud83d\ude80 Performance Level:", optimizationProfile.isEmpty() ? "Default (no changes)" : optimizationProfile));
        List<String> resourcePacks = this.dataManager.getResourcePacksOrdered();
        if (!resourcePacks.isEmpty()) {
            summaryContainer.child((Component)this.createSummaryItem("\ud83c\udfa8 Resource Packs (loading order):", ""));
            for (int i = 0; i < resourcePacks.size(); ++i) {
                summaryContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("  " + (i + 1) + ". " + resourcePacks.get(i)))).color(Color.ofRgb((int)0xB9BBBE)).margins(Insets.left((int)16)));
            }
        } else {
            summaryContainer.child((Component)this.createSummaryItem("\ud83c\udfa8 Resource Packs:", "None selected"));
        }
        String tabDesign = this.dataManager.getTabDesign();
        summaryContainer.child((Component)this.createSummaryItem("\ud83d\uddbc\ufe0f Tab Menu Style:", tabDesign.isEmpty() ? "Default (no changes)" : tabDesign));
        return summaryContainer;
    }

    private FlowLayout createSummaryItem(String label, String value) {
        FlowLayout item = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).margins(Insets.vertical((int)2));
        item.child((Component)Components.label((class_2561)class_2561.method_43470((String)label)).color(Color.ofRgb((int)0xFFFFFF)));
        LabelComponent valueLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)value)).color(Color.ofRgb((int)0xB9BBBE)).horizontalSizing(Sizing.expand());
        item.child((Component)valueLabel);
        return item;
    }

    private FlowLayout createWarningBanner() {
        FlowLayout banner = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)822053888).and(Surface.outline((int)-23296))).padding(Insets.of((int)8)).margins(Insets.vertical((int)4));
        banner.positioning(Positioning.absolute((int)0, (int)-1000));
        return banner;
    }

    private void showWarningBanner(String title, String message) {
        class_310.method_1551().execute(() -> {
            this.warningBanner.clearChildren();
            this.warningBanner.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\u26a0\ufe0f " + title)).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)16753920)));
            this.warningBanner.child(Components.label((class_2561)class_2561.method_43470((String)message)).color(Color.ofRgb((int)0xFFFFFF)).horizontalSizing(Sizing.fill((int)95)));
            this.warningBanner.positioning(Positioning.layout());
        });
    }

    private void hideWarningBanner() {
        class_310.method_1551().execute(() -> this.warningBanner.positioning(Positioning.absolute((int)0, (int)-1000)));
    }

    private FlowLayout createProgressSection() {
        this.progressContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(3).surface(Surface.flat((int)0x20000000).and(Surface.outline((int)0x40FFFFFF))).padding(Insets.of((int)6));
        this.progressContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2699\ufe0f Applying Your Settings:").method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)-10496)));
        this.initializeProgressSteps();
        if (!this.dataManager.isConfigurationApplying()) {
            this.progressContainer.positioning(Positioning.absolute((int)0, (int)-1000));
        }
        return this.progressContainer;
    }

    private void initializeProgressSteps() {
        Set<String> additionalSettings;
        String tabDesign;
        List<String> resourcePacks;
        this.stepLabels.clear();
        String optimizationProfile = this.dataManager.getOptimizationProfile();
        if (!optimizationProfile.isEmpty()) {
            LabelComponent stepLabel = this.createProgressStepLabel("Performance Settings", "pending");
            this.stepLabels.put("performance", stepLabel);
            this.progressContainer.child((Component)stepLabel);
        }
        if (!(resourcePacks = this.dataManager.getResourcePacksOrdered()).isEmpty()) {
            LabelComponent stepLabel = this.createProgressStepLabel("Resource Packs", "pending");
            this.stepLabels.put("resourcepacks", stepLabel);
            this.progressContainer.child((Component)stepLabel);
        }
        if (!(tabDesign = this.dataManager.getTabDesign()).isEmpty()) {
            LabelComponent stepLabel = this.createProgressStepLabel("Tab Menu Style", "pending");
            this.stepLabels.put("tabdesign", stepLabel);
            this.progressContainer.child((Component)stepLabel);
        }
        if (!(additionalSettings = this.dataManager.getAdditionalSettings()).isEmpty()) {
            LabelComponent stepLabel = this.createProgressStepLabel("Extra Settings", "pending");
            this.stepLabels.put("additional", stepLabel);
            this.progressContainer.child((Component)stepLabel);
        }
    }

    private LabelComponent createProgressStepLabel(String stepName, String status) {
        String icon = switch (status) {
            case "success" -> "\u2705";
            case "error" -> "\u274c";
            case "running" -> "\u23f3";
            default -> "\u23f8\ufe0f";
        };
        class_124 color = switch (status) {
            case "success" -> class_124.field_1060;
            case "error" -> class_124.field_1061;
            case "running" -> class_124.field_1054;
            default -> class_124.field_1080;
        };
        return (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)(icon + " " + stepName)).method_10862(class_2583.field_24360.method_10977(color))).margins(Insets.left((int)8));
    }

    private void updateProgressStep(String stepKey, String status, String errorMessage) {
        class_310.method_1551().execute(() -> {
            LabelComponent stepLabel = this.stepLabels.get(stepKey);
            if (stepLabel != null) {
                String stepName = switch (stepKey) {
                    case "performance" -> "Performance Settings";
                    case "resourcepacks" -> "Resource Packs";
                    case "tabdesign" -> "Tab Menu Style";
                    case "additional" -> "Extra Settings";
                    default -> "Unknown Step";
                };
                String icon = switch (status) {
                    case "success" -> "\u2705";
                    case "error" -> "\u274c";
                    case "running" -> "\u23f3";
                    default -> "\u23f8\ufe0f";
                };
                class_124 color = switch (status) {
                    case "success" -> class_124.field_1060;
                    case "error" -> class_124.field_1061;
                    case "running" -> class_124.field_1054;
                    default -> class_124.field_1080;
                };
                String displayText = icon + " " + stepName;
                if (status.equals("error") && errorMessage != null && !errorMessage.isEmpty()) {
                    displayText = displayText + " - " + errorMessage;
                }
                stepLabel.text((class_2561)class_2561.method_43470((String)displayText).method_10862(class_2583.field_24360.method_10977(color)));
            }
        });
    }

    private FlowLayout createStatusSection() {
        FlowLayout statusContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).margins(Insets.vertical((int)8));
        this.statusLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udc49 Ready to begin! Click 'Apply Settings' when you're ready.").method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).horizontalSizing(Sizing.fill((int)98)).margins(Insets.of((int)2));
        statusContainer.child((Component)this.statusLabel);
        return statusContainer;
    }

    private FlowLayout createActionButtons() {
        FlowLayout buttonContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)16)).positioning(Positioning.relative((int)50, (int)100));
        this.applyButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Apply Settings"), this::onApplyPressed).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)130, (int)66)).horizontalSizing(Sizing.fixed((int)130)).verticalSizing(Sizing.fixed((int)22));
        buttonContainer.child((Component)this.applyButton);
        return buttonContainer;
    }

    private FlowLayout createHelpSection() {
        FlowLayout helpContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).surface(Surface.flat((int)0x20000000).and(Surface.outline((int)0x40FFFFFF))).padding(Insets.of((int)8)).margins(Insets.of((int)5, (int)0, (int)0, (int)0));
        helpContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2139\ufe0f What Happens Next?").method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)-10496)));
        helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"1. Performance settings will be adjusted")).color(Color.ofRgb((int)0xFFFFFF)).horizontalSizing(Sizing.fill((int)95)));
        helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"2. Resource packs will be enabled in order")).color(Color.ofRgb((int)0xFFFFFF)).horizontalSizing(Sizing.fill((int)95)));
        helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"3. Tab menu style will be configured")).color(Color.ofRgb((int)0xFFFFFF)).horizontalSizing(Sizing.fill((int)95)));
        helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udca1 Tip: Each step shows a progress indicator. If something fails, you'll see exactly what went wrong!").method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).horizontalSizing(Sizing.fill((int)95)).margins(Insets.of((int)6, (int)2, (int)2, (int)2)));
        return helpContainer;
    }

    private void onApplyPressed(ButtonComponent button) {
        if (this.dataManager.isConfigurationApplying() || this.dataManager.isConfigurationApplied()) {
            PackCore.LOGGER.debug("Apply pressed but already applying ({}) or has applied ({})", (Object)this.dataManager.isConfigurationApplying(), (Object)this.dataManager.isConfigurationApplied());
            return;
        }
        PackCore.LOGGER.info("Starting configuration application process");
        this.hideWarningBanner();
        this.dataManager.setConfigurationApplying(true);
        this.dataManager.setConfigurationApplied(false);
        this.dataManager.setConfigurationResult("", "");
        this.progressContainer.positioning(Positioning.layout());
        this.updateApplyButtonState(true, "Applying...");
        this.updateStatusLabel("\u23f3 Please wait while we apply your settings. This may take a moment...", class_124.field_1054);
        ConfigurationApplicationService.applyAllConfigurationsWithProgress(this::updateProgressStep).whenComplete((result, throwable) -> class_310.method_1551().execute(() -> {
            this.dataManager.setConfigurationApplying(false);
            if (result.isOverallSuccess() && throwable == null) {
                this.dataManager.setConfigurationApplied(true);
                this.dataManager.setConfigurationResult("success", "");
                this.onConfigurationApplied();
            } else {
                this.shouldShowSkipButton = true;
                this.dataManager.setConfigurationApplied(false);
                StringBuilder failureMessage = new StringBuilder();
                if (!result.getFailedSteps().isEmpty()) {
                    for (Map.Entry<String, String> failure : result.getFailedSteps().entrySet()) {
                        failureMessage.append("\u274c ").append(failure.getKey()).append(":\n   ").append(failure.getValue()).append("\n\n");
                    }
                } else if (throwable != null) {
                    String errorMsg = throwable.getMessage() != null ? throwable.getMessage() : "An unexpected error occurred";
                    failureMessage.append(errorMsg);
                } else {
                    failureMessage.append("An unexpected error occurred.");
                }
                this.dataManager.setConfigurationResult("failed", failureMessage.toString());
                this.onConfigurationFailed((ConfigurationApplicationService.ConfigurationResult)result, (Throwable)throwable);
            }
        }));
    }

    private void updateApplyButtonState(boolean isApplying, String message) {
        if (this.applyButton != null) {
            this.applyButton.method_25355((class_2561)class_2561.method_43470((String)message));
            this.applyButton.field_22763 = !isApplying;
        }
    }

    private void updateStatusLabel(String message, class_124 color) {
        if (this.statusLabel != null) {
            this.statusLabel.text((class_2561)class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_10977(color))).horizontalSizing(Sizing.fill((int)100));
        }
    }

    private void onConfigurationApplied() {
        PackCore.LOGGER.info("Wizard configuration applied successfully!");
        this.updateApplyButtonState(true, "\u2705 All Done!");
        this.updateStatusLabel("\u2705 Success! All your settings have been applied. Click 'Continue' to start playing!", class_124.field_1060);
        this.updatePrimaryButtonState(true);
        PackCoreConfig.haveShownWelcomeWizard = true;
        PackCoreConfig.write((String)"packcore");
        WizardDataManager.WizardConfiguration config = this.dataManager.getConfiguration();
        StringBuilder configSummary = new StringBuilder();
        if (!config.getOptimizationProfile().isEmpty()) {
            configSummary.append("Performance: ").append(config.getOptimizationProfile());
        }
        if (!config.getResourcePacksOrdered().isEmpty()) {
            if (!configSummary.isEmpty()) {
                configSummary.append(", ");
            }
            configSummary.append("Packs: ").append(String.join((CharSequence)", ", config.getResourcePacksOrdered()));
        }
        if (!config.getTabDesign().isEmpty()) {
            if (!configSummary.isEmpty()) {
                configSummary.append(", ");
            }
            configSummary.append("Tab: ").append(config.getTabDesign());
        }
    }

    private void onConfigurationFailed(ConfigurationApplicationService.ConfigurationResult result, Throwable throwable) {
        PackCore.LOGGER.error("Failed to apply wizard configuration", throwable);
        StringBuilder failureMessage = new StringBuilder();
        boolean hasResourcePackFailure = false;
        List<String> selectedPacks = this.dataManager.getResourcePacksOrdered();
        boolean hasHypixelPlus = selectedPacks.stream().anyMatch(pack -> pack.equalsIgnoreCase("HypixelPlus"));
        if (result != null && !result.getFailedSteps().isEmpty()) {
            for (Map.Entry<String, String> failure : result.getFailedSteps().entrySet()) {
                failureMessage.append("\u274c ").append(failure.getKey()).append(":\n   ").append(failure.getValue()).append("\n\n");
                if (!failure.getKey().contains("Resource Pack")) continue;
                hasResourcePackFailure = true;
            }
        } else if (throwable != null) {
            String errorMsg = throwable.getMessage() != null ? throwable.getMessage() : "An unexpected error occurred";
            failureMessage.append(errorMsg).append("\n\n");
        } else {
            failureMessage.append("An unexpected error occurred.\n\n");
        }
        if (hasResourcePackFailure && hasHypixelPlus) {
            this.showWarningBanner("HypixelPlus Requires Special Setup", "HypixelPlus needs the JVM argument -Xss4M to work properly. If the resource packs failed to apply, this is likely the cause. Please add -Xss4M to your launcher's JVM arguments and restart the game.");
        }
        this.updateApplyButtonState(false, "\ud83d\udd04 Retry Settings");
        this.updateStatusLabel("\u26a0\ufe0f Some settings couldn't be applied. See details above. Click 'Retry Settings' or 'Skip' to 'Finish'.", class_124.field_1061);
        this.updatePrimaryButtonState(true);
        this.dataManager.setConfigurationApplied(false);
        this.dataManager.setConfigurationApplying(false);
        this.dataManager.setConfigurationResult("failed", failureMessage.toString());
    }

    @Override
    protected void onContinuePressed() {
        if (this.dataManager.isConfigurationApplying()) {
            this.updateStatusLabel("\u23f3 Please wait - we're still applying your settings...", class_124.field_1054);
            return;
        }
        if (!this.dataManager.isConfigurationApplied()) {
            this.updateStatusLabel("\u26a0\ufe0f Please apply your settings first, or click 'Skip' to configure them later. If some configurations failed, you can click 'Skip' \u2014 the ones that succeeded will be saved.", class_124.field_1065);
            return;
        }
        this.field_22787.method_1507((class_437)new FancyMainMenuScreen());
    }

    @Override
    protected void onSkipPressed() {
        if (this.dataManager.isConfigurationApplying()) {
            this.updateStatusLabel("\u23f3 Please wait - we're still applying your settings. You can skip once it finishes.", class_124.field_1054);
            return;
        }
        PackCoreConfig.haveShownWelcomeWizard = true;
        PackCoreConfig.write((String)"packcore");
        this.field_22787.method_1507((class_437)new FancyMainMenuScreen());
    }

    @Override
    protected boolean isLastPage() {
        return true;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 60;
    }

    @Override
    protected int getContentColumnWidthRightPercent() {
        return 38;
    }

    @Override
    protected boolean isSkippable() {
        return this.shouldShowSkipButton;
    }
}

