/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore;

import com.github.kd_gaming1.packcore.command.packcore.PackCoreCommand;
import com.github.kd_gaming1.packcore.command.scamshield.ScamShieldCommand;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.config.backup.ScheduledBackupManager;
import com.github.kd_gaming1.packcore.integration.bobby.BobbyConfigModifier;
import com.github.kd_gaming1.packcore.integration.skyblocker.DungeonMap;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import com.github.kd_gaming1.packcore.scamshield.ChatMessageInterceptor;
import com.github.kd_gaming1.packcore.scamshield.ScamShieldChatHandler;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamDetector;
import com.github.kd_gaming1.packcore.ui.screen.title.SBEStyledTitleScreen;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.WelcomeWizardPage;
import com.github.kd_gaming1.packcore.util.HypixelEventUtil;
import com.github.kd_gaming1.packcore.util.update.modrinth.UpdateCache;
import com.mojang.brigadier.CommandDispatcher;
import eu.midnightdust.lib.config.MidnightConfig;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackCore
implements ClientModInitializer {
    public static final String MOD_ID = "packcore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private static ModpackInfo modpackInfo;
    private static UpdateCache updateManager;
    private static final Path packcoreDir;
    private static ScamDetector scamDetector;

    public void onInitializeClient() {
        LOGGER.info("PackCore initialized!");
        HypixelEventUtil.init();
        scamDetector = ScamDetector.getInstance();
        LOGGER.info("[ScamShield] Initialized with {} scam types", (Object)scamDetector.getScamTypes().size());
        ChatMessageInterceptor.getInstance().register();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            scamDetector.shutdown();
            ScamShieldChatHandler.getInstance().shutdown();
        });
        try {
            modpackInfo = ModpackInfo.loadFromFile(packcoreDir);
            updateManager = new UpdateCache();
            LOGGER.info("Loaded modpack info for: {}", (Object)modpackInfo.getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load modpack info: {}", (Object)e.getMessage());
        }
        MidnightConfig.init((String)MOD_ID, PackCoreConfig.class);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            PackCoreCommand.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            ScamShieldCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
        if (PackCoreConfig.enableScheduledBackups) {
            ScheduledBackupManager.initialize();
        }
        try {
            if (PackCoreConfig.enableCustomMenu) {
                ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                    if (screen instanceof class_442) {
                        client.execute(() -> client.method_1507((class_437)(PackCoreConfig.haveShownWelcomeWizard ? new SBEStyledTitleScreen() : new WelcomeWizardPage())));
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to show custom title screen: {}", (Object)e.getMessage());
        }
        if (!PackCoreConfig.haveSetBobbyConfig) {
            BobbyConfigModifier.enableDynamicMultiWorld();
            PackCoreConfig.haveSetBobbyConfig = true;
            PackCoreConfig.write((String)MOD_ID);
        }
        if (!PackCoreConfig.haveSetDungeonMapConfig) {
            DungeonMap.disableDungeonMap();
            PackCoreConfig.haveSetDungeonMapConfig = true;
            PackCoreConfig.write((String)MOD_ID);
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            try {
                class_437 currentScreen = client.field_1755;
                Class<?> zenClass = Class.forName("xyz.meowing.zen.updateChecker.UpdateGUI");
                Class<?> kryptClass = Class.forName("xyz.meowing.krypt.updateChecker.UpdateGUI");
                if (zenClass.isInstance(currentScreen) || kryptClass.isInstance(currentScreen)) {
                    class_310.method_1551().method_1507(null);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
    }

    public static ModpackInfo getModpackInfo() {
        return modpackInfo;
    }

    public static UpdateCache getUpdateManager() {
        return updateManager;
    }

    public static ScamDetector getScamDetector() {
        return scamDetector;
    }

    static {
        packcoreDir = FabricLoader.getInstance().getGameDir().resolve(MOD_ID);
    }
}

