/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.apply;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.backup.BackupManager;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.util.GsonUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

public class SelectiveConfigApplyService {
    private static final Gson GSON = GsonUtils.GSON;
    private static final String PENDING_SELECTIVE_CONFIG_FILE = "packcore_pending_selective_config.json";
    private static final Map<String, String> KNOWN_FILE_DESCRIPTIONS = Map.ofEntries(Map.entry("options. txt", "Minecraft video settings, controls, and preferences"), Map.entry("servers.dat", "Multiplayer server list"), Map.entry("config/skyblocker.json", "SkyBlocker - Item highlighting, macro features"), Map.entry("config/firmament.json", "Firmament - Repository integration, features"), Map.entry("config/skyhanni.json", "SkyHanni - Events, diana helper, farming"), Map.entry("config/dungeons-guide.json", "Dungeons Guide - Dungeon secrets and routing"), Map.entry("config/neu.json", "NotEnoughUpdates - Auction house, recipes, overlays"), Map.entry("config/skytils.json", "Skytils - Dungeons, kuudra, slayer features"), Map.entry("config/owo-ui.json", "owo-ui library configuration"), Map.entry("config/isxander-main-menu-credits.json", "Main menu credits display"), Map.entry("config/sodium-options.json", "Sodium - Performance optimization settings"), Map.entry("config/iris. json5", "Iris Shaders - Shader pack settings"));

    public static CompletableFuture<List<SelectableFile>> scanConfigFiles(ConfigFileRepository.ConfigFile config) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<SelectableFile> files = new ArrayList<SelectableFile>();
            try (ZipFile zipFile = new ZipFile(config.path().toFile());){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entryName.equals("packcore_metadata.json")) continue;
                    SelectableFile.FileType type = SelectiveConfigApplyService.determineFileType(entryName);
                    String description = SelectiveConfigApplyService.getFileDescription(entryName, type);
                    String displayName = SelectiveConfigApplyService.getDisplayName(entryName);
                    files.add(new SelectableFile(entryName, displayName, type, entry.getSize(), description, entry.isDirectory()));
                }
                files.sort(Comparator.comparing(f -> f.type.ordinal()).thenComparing(f -> f.displayName));
            }
            catch (IOException e) {
                PackCore.LOGGER.error("[Selective Config Apply Service] Failed to scan config files", (Throwable)e);
            }
            return files;
        });
    }

    public static CompletableFuture<Boolean> scheduleSelectiveConfigApplication(ConfigFileRepository.ConfigFile config, Set<String> selectedPaths) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path gameDir = FabricLoader.getInstance().getGameDir();
                Path pendingFile = gameDir.resolve(PENDING_SELECTIVE_CONFIG_FILE);
                PendingSelectiveConfig pending = new PendingSelectiveConfig(config.path().toString(), config.getDisplayName(), selectedPaths);
                String json = GSON.toJson((Object)pending);
                Files.writeString(pendingFile, (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                PackCore.LOGGER.info("[Selective Config Apply Service] Scheduled {} files for application: {}", (Object)selectedPaths.size(), (Object)config.getDisplayName());
                class_310.method_1551().method_1592();
                return true;
            }
            catch (IOException e) {
                PackCore.LOGGER.error("[Selective Config Apply Service] Failed to schedule selective config application", (Throwable)e);
                return false;
            }
        });
    }

    public static boolean checkAndApplyPendingSelectiveConfig(Path gameDir) {
        Path pendingFile = gameDir.resolve(PENDING_SELECTIVE_CONFIG_FILE);
        if (!Files.exists(pendingFile, new LinkOption[0])) {
            return false;
        }
        try {
            boolean success;
            String json = Files.readString(pendingFile, StandardCharsets.UTF_8);
            PendingSelectiveConfig pending = (PendingSelectiveConfig)GSON.fromJson(json, PendingSelectiveConfig.class);
            if (pending == null || pending.configPath == null || pending.selectedPaths == null) {
                PackCore.LOGGER.warn("[Selective Config Apply Service] Invalid pending selective config file");
                Files.deleteIfExists(pendingFile);
                return false;
            }
            PackCore.LOGGER.info("[Selective Config Apply Service] Found pending selective config: {} ({} files)", (Object)pending.configName, (Object)pending.selectedPaths.size());
            Path backup = BackupManager.createAutoBackup();
            if (backup != null) {
                PackCore.LOGGER.info("[Selective Config Apply Service] Created auto-backup before applying: {}", (Object)backup);
            }
            if (success = SelectiveConfigApplyService.applySelectedFilesSync(Path.of(pending.configPath, new String[0]), pending.selectedPaths, gameDir, msg -> PackCore.LOGGER.info("[Selective Config Apply Service] {}", msg))) {
                PackCore.LOGGER.info("[Selective Config Apply Service] Successfully applied {} selected files", (Object)pending.selectedPaths.size());
            } else {
                PackCore.LOGGER.error("[Selective Config Apply Service] Failed to apply selected files");
            }
            Files.deleteIfExists(pendingFile);
            return success;
        }
        catch (Exception e) {
            PackCore.LOGGER.error("[Selective Config Apply Service] Error processing pending selective config", (Throwable)e);
            try {
                Files.deleteIfExists(pendingFile);
            }
            catch (IOException ex) {
                PackCore.LOGGER.warn("[Selective Config Apply Service] Failed to clean up pending file", (Throwable)ex);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean applySelectedFilesSync(Path zipPath, Set<String> selectedPaths, Path gameDir, Consumer<String> progressCallback) {
        boolean bl;
        progressCallback.accept("Extracting selected files.. .");
        Path tempDir = Files.createTempDirectory("packcore_selective", new FileAttribute[0]);
        try {
            SelectiveConfigApplyService.extractSelectedFiles(zipPath, selectedPaths, tempDir, progressCallback);
            progressCallback.accept("Applying files...");
            SelectiveConfigApplyService.copySelectedFilesToGameDir(tempDir, gameDir);
            PackCore.LOGGER.info("[Selective Config Apply Service] Successfully applied {} selected files", (Object)selectedPaths.size());
            progressCallback.accept("Complete!");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                SelectiveConfigApplyService.deleteDirectory(tempDir);
                throw throwable;
            }
            catch (Exception e) {
                PackCore.LOGGER.error("[Selective Config Apply Service] Failed to apply selected files", (Throwable)e);
                progressCallback.accept("Error: " + e.getMessage());
                return false;
            }
        }
        SelectiveConfigApplyService.deleteDirectory(tempDir);
        return bl;
    }

    private static void extractSelectedFiles(Path zipPath, Set<String> selectedPaths, Path tempDir, Consumer<String> progressCallback) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            int processed = 0;
            int total = selectedPaths.size();
            for (String selectedPath : selectedPaths) {
                ZipEntry entry = zipFile.getEntry(selectedPath);
                if (entry == null) {
                    PackCore.LOGGER.warn("[Selective Config Apply Service] Entry not found in zip: {}", (Object)selectedPath);
                    continue;
                }
                Path targetPath = tempDir.resolve(selectedPath);
                if (entry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    SelectiveConfigApplyService.extractDirectory(zipFile, selectedPath, tempDir);
                } else {
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    try (InputStream is = zipFile.getInputStream(entry);){
                        Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                int percentage = ++processed * 100 / total;
                progressCallback.accept(String.format("Extracting: %d%%", percentage));
            }
        }
    }

    private static void extractDirectory(ZipFile zipFile, String dirPath, Path tempDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(dirPath) || entry.isDirectory()) continue;
            Path targetPath = tempDir.resolve(entryName);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            InputStream is = zipFile.getInputStream(entry);
            try {
                Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private static void copySelectedFilesToGameDir(Path tempDir, Path gameDir) throws IOException {
        try (Stream<Path> paths = Files.walk(tempDir, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(sourcePath -> {
                try {
                    Path relativePath = tempDir.relativize((Path)sourcePath);
                    Path targetPath = gameDir.resolve(relativePath);
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    PackCore.LOGGER.debug("[Selective Config Apply Service] Copied: {}", (Object)relativePath);
                }
                catch (IOException e) {
                    PackCore.LOGGER.warn("[Selective Config Apply Service] Failed to copy file: {}", sourcePath, (Object)e);
                }
            });
        }
    }

    private static SelectableFile.FileType determineFileType(String path) {
        if ((path = path.toLowerCase()).equals("options.txt")) {
            return SelectableFile.FileType.GAME_OPTIONS;
        }
        if (path.equals("servers.dat")) {
            return SelectableFile.FileType.SERVER_LIST;
        }
        if (path.startsWith("config/")) {
            return SelectableFile.FileType.MOD_CONFIG;
        }
        if (path.startsWith("resourcepacks/")) {
            return SelectableFile.FileType.RESOURCE_PACK;
        }
        return SelectableFile.FileType.OTHER;
    }

    private static String getDisplayName(String path) {
        int lastSlash;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastSlash = path.lastIndexOf(47)) >= 0) {
            return path.substring(lastSlash + 1);
        }
        return path;
    }

    private static String getFileDescription(String path, SelectableFile.FileType type) {
        String fileName;
        int dotIndex;
        String description = KNOWN_FILE_DESCRIPTIONS.get(path.toLowerCase());
        if (description != null) {
            return description;
        }
        if (path.startsWith("config/") && (dotIndex = (fileName = path.substring("config/".length())).indexOf(46)) > 0) {
            Object modName = fileName.substring(0, dotIndex);
            modName = ((String)modName).substring(0, 1).toUpperCase() + ((String)modName).substring(1);
            return "Configuration for " + (String)modName;
        }
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Mod configuration file";
            case 1 -> "Minecraft game settings";
            case 2 -> "Control bindings";
            case 3 -> "Resource pack";
            case 4 -> "Multiplayer server list";
            case 5 -> "Configuration file";
        };
    }

    private static void deleteDirectory(Path directory) {
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    PackCore.LOGGER.debug("[Selective Config Apply Service] Could not delete: {}", path);
                }
            });
        }
        catch (IOException e) {
            PackCore.LOGGER.warn("[Selective Config Apply Service] Failed to delete temp directory: {}", (Object)directory);
        }
    }

    public static Map<String, List<SelectableFile>> groupFilesByMod(List<SelectableFile> files) {
        LinkedHashMap<String, List<SelectableFile>> groups = new LinkedHashMap<String, List<SelectableFile>>();
        for (SelectableFile file : files) {
            String groupName = SelectiveConfigApplyService.determineGroup(file.path);
            groups.computeIfAbsent(groupName, k -> new ArrayList()).add(file);
        }
        return groups;
    }

    private static String determineGroup(String path) {
        String fileName;
        int dotIndex;
        if (path.equals("options.txt")) {
            return "Minecraft Settings";
        }
        if (path.equals("servers.dat")) {
            return "Server List";
        }
        if (path.startsWith("config/") && (dotIndex = (fileName = path.substring("config/".length())).indexOf(46)) > 0) {
            String modName = fileName.substring(0, dotIndex);
            return SelectiveConfigApplyService.formatModName(modName);
        }
        return "Other Files";
    }

    private static String formatModName(String modName) {
        modName = modName.replace("-", " ");
        modName = modName.replace("_", " ");
        String[] words = modName.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }

    private static class PendingSelectiveConfig {
        String configPath;
        String configName;
        Set<String> selectedPaths;

        PendingSelectiveConfig(String configPath, String configName, Set<String> selectedPaths) {
            this.configPath = configPath;
            this.configName = configName;
            this.selectedPaths = selectedPaths;
        }
    }

    public record SelectableFile(String path, String displayName, FileType type, long size, String description, boolean isDirectory) {

        public static enum FileType {
            MOD_CONFIG("Mod Configuration"),
            GAME_OPTIONS("Game Settings"),
            KEYBINDINGS("Keybindings"),
            RESOURCE_PACK("Resource Pack"),
            SERVER_LIST("Server List"),
            OTHER("Other");

            private final String displayName;

            private FileType(String displayName) {
                this.displayName = displayName;
            }

            public String getDisplayName() {
                return this.displayName;
            }
        }
    }
}

