/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;

public class ScamShieldWhitelist {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ScamShieldWhitelist INSTANCE = new ScamShieldWhitelist();
    private final Set<String> whitelistedPlayers = ConcurrentHashMap.newKeySet();
    private final Path whitelistFile;

    private ScamShieldWhitelist() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        this.whitelistFile = gameDir.resolve("packcore/scamshield/whitelist.json");
        this.load();
    }

    public static ScamShieldWhitelist getInstance() {
        return INSTANCE;
    }

    public boolean isWhitelisted(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        return this.whitelistedPlayers.contains(playerName.toLowerCase());
    }

    public boolean add(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        String normalized = playerName.toLowerCase();
        boolean added = this.whitelistedPlayers.add(normalized);
        if (added) {
            this.save();
            PackCore.LOGGER.info("[ScamShield] Added '{}' to whitelist", (Object)playerName);
        }
        return added;
    }

    public boolean remove(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        String normalized = playerName.toLowerCase();
        boolean removed = this.whitelistedPlayers.remove(normalized);
        if (removed) {
            this.save();
            PackCore.LOGGER.info("[ScamShield] Removed '{}' from whitelist", (Object)playerName);
        }
        return removed;
    }

    public Set<String> getWhitelistedPlayers() {
        return new HashSet<String>(this.whitelistedPlayers);
    }

    public void clear() {
        this.whitelistedPlayers.clear();
        this.save();
        PackCore.LOGGER.info("[ScamShield] Cleared whitelist");
    }

    private void load() {
        try {
            if (!Files.exists(this.whitelistFile, new LinkOption[0])) {
                PackCore.LOGGER.info("[ScamShield] No whitelist file found, starting empty");
                return;
            }
            String json = Files.readString(this.whitelistFile, StandardCharsets.UTF_8);
            String[] players = (String[])GSON.fromJson(json, String[].class);
            if (players != null) {
                for (String player : players) {
                    this.whitelistedPlayers.add(player.toLowerCase());
                }
            }
            PackCore.LOGGER.info("[ScamShield] Loaded {} whitelisted players", (Object)this.whitelistedPlayers.size());
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to load whitelist", (Throwable)e);
        }
    }

    private void save() {
        try {
            Files.createDirectories(this.whitelistFile.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this.whitelistedPlayers.toArray(new String[0]));
            Path tempFile = this.whitelistFile.resolveSibling(String.valueOf(this.whitelistFile.getFileName()) + ".tmp");
            Files.writeString(tempFile, (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.move(tempFile, this.whitelistFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to save whitelist", (Throwable)e);
        }
    }
}

