/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.debug;

import java.util.ArrayList;
import java.util.List;

public class TestCase {
    private final String name;
    private final String description;
    private final List<Message> conversation;
    private final boolean shouldTrigger;
    private final int expectedMinScore;
    private final String category;

    public TestCase(String name, String description, List<Message> conversation, boolean shouldTrigger, int expectedMinScore, String category) {
        this.name = name;
        this.description = description;
        this.conversation = new ArrayList<Message>(conversation);
        this.shouldTrigger = shouldTrigger;
        this.expectedMinScore = expectedMinScore;
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Message> getConversation() {
        return this.conversation;
    }

    public boolean shouldTrigger() {
        return this.shouldTrigger;
    }

    public int getExpectedMinScore() {
        return this.expectedMinScore;
    }

    public String getCategory() {
        return this.category;
    }

    public static class Builder {
        private String name;
        private String description;
        private final List<Message> conversation = new ArrayList<Message>();
        private boolean shouldTrigger = true;
        private int expectedMinScore = 100;
        private String category = "Unknown";

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder message(String sender, String text) {
            return this.message(sender, text, 100L);
        }

        public Builder message(String sender, String text, long delayMs) {
            this.conversation.add(new Message(sender, text, delayMs));
            return this;
        }

        public Builder shouldTrigger(boolean shouldTrigger) {
            this.shouldTrigger = shouldTrigger;
            return this;
        }

        public Builder expectedMinScore(int score) {
            this.expectedMinScore = score;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public TestCase build() {
            return new TestCase(this.name, this.description, this.conversation, this.shouldTrigger, this.expectedMinScore, this.category);
        }
    }

    public static class Message {
        private final String sender;
        private final String text;
        private final long delayMs;

        public Message(String sender, String text, long delayMs) {
            this.sender = sender;
            this.text = text;
            this.delayMs = delayMs;
        }

        public String getSender() {
            return this.sender;
        }

        public String getText() {
            return this.text;
        }

        public long getDelayMs() {
            return this.delayMs;
        }
    }
}

