/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.storage;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.storage.DetectedScam;
import com.github.kd_gaming1.packcore.scamshield.storage.DetectionStats;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.fabricmc.loader.api.FabricLoader;

public class ScamShieldDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ScamShieldDataManager INSTANCE = new ScamShieldDataManager();
    private final Path scamShieldDir;
    private final Path detectionsFile;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ExecutorService saveExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "ScamShield-Saver");
        t.setDaemon(true);
        return t;
    });

    private ScamShieldDataManager() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        this.scamShieldDir = gameDir.resolve("packcore/scamshield");
        this.detectionsFile = this.scamShieldDir.resolve("detections.json");
        this.initializeDirectories();
    }

    public static ScamShieldDataManager getInstance() {
        return INSTANCE;
    }

    private void initializeDirectories() {
        try {
            Files.createDirectories(this.scamShieldDir, new FileAttribute[0]);
            PackCore.LOGGER.info("[ScamShield] Data directory initialized at: {}", (Object)this.scamShieldDir);
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to create ScamShield directories", (Throwable)e);
        }
    }

    public void saveDetectionAsync(DetectedScam detection) {
        CompletableFuture.runAsync(() -> {
            try {
                List<DetectedScam> history = this.loadDetectionHistory();
                history.add(detection);
                int maxHistory = PackCoreConfig.scamShieldMaxHistorySize;
                if (history.size() > maxHistory) {
                    history = new ArrayList<DetectedScam>(history.subList(history.size() - maxHistory, history.size()));
                }
                String json = GSON.toJson(history);
                this.lock.writeLock().lock();
                try {
                    Path tempFile = this.detectionsFile.resolveSibling(String.valueOf(this.detectionsFile.getFileName()) + ".tmp");
                    Files.writeString(tempFile, (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.move(tempFile, this.detectionsFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    if (PackCoreConfig.enableScamShieldDebugging) {
                        PackCore.LOGGER.info("[ScamShield] Saved detection to history (total: {})", (Object)history.size());
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (IOException e) {
                PackCore.LOGGER.error("[ScamShield] Failed to save detection", (Throwable)e);
            }
        }, this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DetectedScam> loadDetectionHistory() {
        this.lock.readLock().lock();
        try {
            if (!Files.exists(this.detectionsFile, new LinkOption[0])) {
                ArrayList<DetectedScam> arrayList = new ArrayList<DetectedScam>();
                return arrayList;
            }
            String json = Files.readString(this.detectionsFile, StandardCharsets.UTF_8);
            DetectedScam[] detections = (DetectedScam[])GSON.fromJson(json, DetectedScam[].class);
            if (detections == null) {
                ArrayList<DetectedScam> arrayList = new ArrayList<DetectedScam>();
                return arrayList;
            }
            ArrayList<DetectedScam> arrayList = new ArrayList<DetectedScam>(List.of(detections));
            return arrayList;
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to load detection history", (Throwable)e);
            ArrayList<DetectedScam> arrayList = new ArrayList<DetectedScam>();
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Void> clearHistoryAsync() {
        return CompletableFuture.runAsync(() -> {
            this.lock.writeLock().lock();
            try {
                Files.deleteIfExists(this.detectionsFile);
                PackCore.LOGGER.info("[ScamShield] Cleared detection history");
            }
            catch (IOException e) {
                PackCore.LOGGER.error("[ScamShield] Failed to clear history", (Throwable)e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private ExecutorService getExecutor() {
        return this.saveExecutor;
    }

    public DetectionStats getStats() {
        List<DetectedScam> history = this.loadDetectionHistory();
        return new DetectionStats(history);
    }

    public Path getScamShieldDirectory() {
        return this.scamShieldDir;
    }

    public void shutdown() {
        this.saveExecutor.shutdown();
        try {
            if (!this.saveExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.saveExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.saveExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

