/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.component.tree;

import com.github.kd_gaming1.packcore.config.apply.FileDescriptionRegistry;
import com.github.kd_gaming1.packcore.ui.component.tree.FileTreeNode;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Files;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2561;

public class FileTreeUIHelper {
    public static FlowLayout createTreeNodeRow(FileTreeNode node, int depth, boolean isSelected, Runnable onExpand, BiConsumer<FileTreeNode, Boolean> onSelect, Consumer<FileTreeNode> onHover) {
        int fileCount;
        FlowLayout row = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).padding(Insets.left((int)(depth * 16))).verticalAlignment(VerticalAlignment.CENTER);
        if (node.isDirectory() && (!node.getChildren().isEmpty() || node.hasUnloadedChildren())) {
            ButtonComponent expandBtn = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)(node.isExpanded() ? "\u25bc" : "\u25b6")), btn -> onExpand.run()).renderer(ButtonComponent.Renderer.flat((int)-1070978518, (int)-18355, (int)-11184811)).sizing(Sizing.fixed((int)16), Sizing.fixed((int)16));
            row.child((Component)expandBtn);
        } else {
            BoxComponent spacer = Components.box((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16));
            spacer.fill(true);
            spacer.color(Color.ofArgb((int)0));
            row.child((Component)spacer);
        }
        if (onSelect != null) {
            CheckboxComponent checkbox = Components.checkbox((class_2561)class_2561.method_43473()).checked(isSelected).onChanged(checked -> onSelect.accept(node, (Boolean)checked));
            row.child((Component)checkbox);
        }
        String icon = FileTreeUIHelper.getNodeIcon(node);
        row.child((Component)Components.label((class_2561)class_2561.method_43470((String)icon)).color(UITheme.color(-18355)));
        row.child(Components.label((class_2561)class_2561.method_43470((String)node.getName())).color(UITheme.color(isSelected ? -18355 : -1)).horizontalSizing(Sizing.expand()));
        if (node.isDirectory() && !node.getChildren().isEmpty() && (fileCount = FileTreeUIHelper.countFiles(node)) > 0) {
            row.child((Component)Components.label((class_2561)class_2561.method_43470((String)("[" + fileCount + "]"))).color(UITheme.color(-5195576)));
        }
        if (onHover != null) {
            row.mouseEnter().subscribe(() -> {
                row.surface(Surface.flat((int)-1069925830));
                onHover.accept(node);
            });
            row.mouseLeave().subscribe(() -> row.surface(Surface.BLANK));
        }
        return row;
    }

    public static FlowLayout createTreeNodeRowReadOnly(FileTreeNode node, int depth, Runnable onExpand, Consumer<FileTreeNode> onHover) {
        return FileTreeUIHelper.createTreeNodeRow(node, depth, false, onExpand, null, onHover);
    }

    private static String getNodeIcon(FileTreeNode node) {
        if (node.isDirectory()) {
            return node.isExpanded() ? "\ud83d\udcc2" : "\ud83d\udcc1";
        }
        return FileDescriptionRegistry.getIcon(node.getPath().toString());
    }

    public static int countFiles(FileTreeNode node) {
        if (!node.isDirectory()) {
            return 1;
        }
        int count = 0;
        for (FileTreeNode child : node.getChildren()) {
            if (child.isHidden()) continue;
            count += FileTreeUIHelper.countFiles(child);
        }
        return count;
    }

    public static long calculateSize(FileTreeNode node) {
        if (!node.isDirectory()) {
            try {
                return Files.size(node.getPath());
            }
            catch (Exception e) {
                return 0L;
            }
        }
        long total = 0L;
        for (FileTreeNode child : node.getChildren()) {
            if (child.isHidden()) continue;
            total += FileTreeUIHelper.calculateSize(child);
        }
        return total;
    }

    public static void selectNodeAndChildren(FileTreeNode node, boolean selected, Set<String> selectedPaths) {
        String path = node.getPath().toString();
        if (selected) {
            selectedPaths.add(path);
        } else {
            selectedPaths.remove(path);
        }
        if (node.isDirectory()) {
            for (FileTreeNode child : node.getChildren()) {
                FileTreeUIHelper.selectNodeAndChildren(child, selected, selectedPaths);
            }
        }
    }

    public static boolean hasSelectedChildren(FileTreeNode node, Set<String> selectedPaths) {
        if (selectedPaths.contains(node.getPath().toString())) {
            return true;
        }
        if (node.isDirectory()) {
            for (FileTreeNode child : node.getChildren()) {
                if (!FileTreeUIHelper.hasSelectedChildren(child, selectedPaths)) continue;
                return true;
            }
        }
        return false;
    }
}

