/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.configmanager;

import com.github.kd_gaming1.packcore.config.apply.ConfigApplyService;
import com.github.kd_gaming1.packcore.config.model.ConfigMetadata;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.BackupManagementScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ExportConfigScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ImportConfigScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.SelectiveFileApplicationScreen;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManagerScreen
extends BasePackCoreScreen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private ConfigFileRepository.ConfigFile selectedConfig = null;
    private FlowLayout infoPanel;
    private final Map<ConfigFileRepository.ConfigFile, FlowLayout> entryComponents = new HashMap<ConfigFileRepository.ConfigFile, FlowLayout>();

    public ConfigManagerScreen() {
        super(null);
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)"Configuration Manager").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(-1));
    }

    @Override
    protected FlowLayout createHeaderActions() {
        FlowLayout actions = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(8);
        ConfigMetadata currentMeta = ConfigFileRepository.getCurrentConfig();
        FlowLayout currentConfigInfo = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).horizontalAlignment(HorizontalAlignment.RIGHT).margins(Insets.right((int)8));
        currentConfigInfo.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Active: " + currentMeta.getName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        currentConfigInfo.child((Component)Components.label((class_2561)class_2561.method_43470((String)("v" + currentMeta.getVersion() + " | " + currentMeta.getTargetResolution()))).color(UITheme.color(-5195576)));
        actions.child((Component)currentConfigInfo);
        actions.child((Component)ScreenUIComponents.createButton("Close", btn -> this.navigateBack(), 90, 19));
        return actions;
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createInfoPanel());
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = ScreenUIComponents.createSidebar(35);
        sidebar.child((Component)this.createInfoText());
        sidebar.child((Component)this.createConfigSection("Official Configs", ConfigFileRepository.getOfficialConfigs(), true));
        sidebar.child((Component)this.createConfigSection("Custom Configs", ConfigFileRepository.getCustomConfigs(), false));
        sidebar.child((Component)this.createSidebarButtons());
        return sidebar;
    }

    private FlowLayout createInfoText() {
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        int padding = guiScale <= 2 ? 16 : 8;
        FlowLayout infoContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)padding, (int)0, (int)padding, (int)0));
        LabelComponent infoLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Manage your modpack configurations. Select a config to view details or apply it.")).color(UITheme.color(-1)).sizing(Sizing.fill((int)95), Sizing.content());
        infoContainer.child((Component)infoLabel);
        return infoContainer;
    }

    private FlowLayout createConfigSection(String title, List<ConfigFileRepository.ConfigFile> configs, boolean isOfficial) {
        FlowLayout section = ScreenUIComponents.createSection(title, isOfficial ? 45 : 50);
        FlowLayout listContent = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2);
        if (configs.isEmpty()) {
            listContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No configs found")).color(UITheme.color(-5195576)));
        } else {
            for (ConfigFileRepository.ConfigFile config : configs) {
                listContent.child((Component)this.createConfigEntry(config));
            }
        }
        section.child(ScreenUIComponents.createScrollContainer(listContent));
        return section;
    }

    private FlowLayout createConfigEntry(ConfigFileRepository.ConfigFile config) {
        FlowLayout entry = ScreenUIComponents.createListEntry();
        String version = "v" + config.metadata().getVersion();
        String configName = config.getDisplayName().endsWith(version) ? config.getDisplayName().replaceAll(version, "") : config.getDisplayName();
        entry.child((Component)Components.label((class_2561)class_2561.method_43470((String)configName)).color(UITheme.color(-1)));
        FlowLayout badges = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)(config.official() ? "Official" : "Custom"))).color(UITheme.color(config.official() ? -15681151 : -680437)));
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)version)).color(UITheme.color(-5195576)));
        entry.child((Component)badges);
        this.entryComponents.put(config, entry);
        ScreenUIComponents.applyHoverEffects(entry, () -> this.selectConfig(config));
        return entry;
    }

    private FlowLayout createSidebarButtons() {
        FlowLayout buttonRow = (FlowLayout)Containers.ltrTextFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.child(ScreenUIComponents.createButton("Import", btn -> class_310.method_1551().method_1507((class_437)new ImportConfigScreen()), 90, 19).margins(Insets.bottom((int)4)));
        buttonRow.child(ScreenUIComponents.createButton("Export", btn -> class_310.method_1551().method_1507((class_437)new ExportConfigScreen()), 90, 19).margins(Insets.bottom((int)4)));
        buttonRow.child(ScreenUIComponents.createButton("Backup", btn -> class_310.method_1551().method_1507((class_437)new BackupManagementScreen()), 90, 19).margins(Insets.bottom((int)4)));
        return buttonRow;
    }

    private FlowLayout createInfoPanel() {
        this.infoPanel = ScreenUIComponents.createInfoPanel(65);
        this.showEmptyState();
        return this.infoPanel;
    }

    private void showEmptyState() {
        this.infoPanel.clearChildren();
        this.infoPanel.child((Component)ScreenUIComponents.createEmptyState("Select a configuration to view details"));
    }

    private void selectConfig(ConfigFileRepository.ConfigFile config) {
        if (this.selectedConfig != null && this.entryComponents.containsKey(this.selectedConfig)) {
            ScreenUIComponents.applySelectedState(this.entryComponents.get(this.selectedConfig), false);
        }
        this.selectedConfig = config;
        if (this.entryComponents.containsKey(config)) {
            ScreenUIComponents.applySelectedState(this.entryComponents.get(config), true);
        }
        this.showConfigDetails();
    }

    private void showConfigDetails() {
        if (this.selectedConfig == null) {
            return;
        }
        this.infoPanel.clearChildren();
        this.infoPanel.horizontalAlignment(HorizontalAlignment.LEFT);
        this.infoPanel.verticalAlignment(VerticalAlignment.TOP);
        ConfigMetadata meta = this.selectedConfig.metadata();
        int padding = (Integer)class_310.method_1551().field_1690.method_42474().method_41753() <= 2 ? 6 : 0;
        FlowLayout scrollableContent = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8);
        scrollableContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)meta.getName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)).margins(Insets.of((int)padding, (int)0, (int)0, (int)0)));
        FlowLayout infoBox = ScreenUIComponents.createInfoBox();
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Version:", meta.getVersion()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Author:", meta.getAuthor()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Resolution:", meta.getTargetResolution()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Source:", meta.getSource()));
        if (meta.getCreatedDate() != null && !meta.getCreatedDate().isEmpty()) {
            infoBox.child((Component)ScreenUIComponents.createInfoRow("Created:", ScreenUIComponents.formatTimestamp(meta.getCreatedDate())));
        }
        scrollableContent.child((Component)infoBox);
        if (meta.getDescription() != null && !meta.getDescription().isEmpty()) {
            scrollableContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
            scrollableContent.child(Components.label((class_2561)class_2561.method_43470((String)meta.getDescription())).color(UITheme.color(-1)).sizing(Sizing.fill((int)94), Sizing.content()));
        }
        scrollableContent.child(this.createModsList(meta));
        this.infoPanel.child(ScreenUIComponents.createScrollContainer(scrollableContent).sizing(Sizing.fill((int)96), Sizing.expand()));
        this.infoPanel.child((Component)this.createActionButtons());
    }

    private Component createModsList(ConfigMetadata meta) {
        if (meta.getMods() == null || meta.getMods().isEmpty()) {
            return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        }
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        container.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Included Mods:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        FlowLayout modsContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2);
        int displayCount = Math.min(15, meta.getMods().size());
        for (int i = 0; i < displayCount; ++i) {
            modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\u2022 " + meta.getMods().get(i)))).color(UITheme.color(-1)));
        }
        if (meta.getMods().size() > displayCount) {
            modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("... and " + (meta.getMods().size() - displayCount) + " more"))).color(UITheme.color(-5195576)));
        }
        container.child(ScreenUIComponents.createScrollContainer(modsContainer).sizing(Sizing.fill((int)100), Sizing.fixed((int)150)));
        return container;
    }

    private FlowLayout createActionButtons() {
        FlowLayout buttonPanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)12));
        buttonPanel.child((Component)ScreenUIComponents.createButton("Apply Full Config", btn -> this.showConfirmationDialog(), 120, 20));
        buttonPanel.child((Component)ScreenUIComponents.createButton("Apply Specific Files", btn -> class_310.method_1551().method_1507((class_437)new SelectiveFileApplicationScreen(this.selectedConfig, (class_437)this)), 120, 20));
        if (!this.selectedConfig.official()) {
            buttonPanel.child((Component)ScreenUIComponents.createButton("Delete", btn -> this.deleteConfig(), 90, 20));
        }
        return buttonPanel;
    }

    private void showConfirmationDialog() {
        if (this.selectedConfig == null) {
            return;
        }
        FlowLayout dialog = ScreenUIComponents.createDialog("Apply Configuration?", "This will close the game, and when the game is open again, apply:\"\n" + this.selectedConfig.getDisplayName() + "\n\n\u26a0 Current configurations will be backed up automatically.", 400);
        FlowLayout buttons = ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Apply", btn -> this.applyConfig(), 90, 20), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 90, 20));
        dialog.child((Component)buttons);
        this.showOverlay(dialog, false);
    }

    private void applyConfig() {
        if (this.selectedConfig == null) {
            return;
        }
        this.closeTopOverlay();
        try {
            ConfigApplyService.scheduleConfigApplication(this.selectedConfig);
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Applying: " + this.selectedConfig.getDisplayName() + " - Restarting...")), false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply config", (Throwable)e);
        }
    }

    private void deleteConfig() {
        if (this.selectedConfig == null || this.selectedConfig.official()) {
            return;
        }
        if (ConfigFileRepository.deleteConfig(this.selectedConfig)) {
            this.selectedConfig = null;
            this.build((FlowLayout)this.uiAdapter.rootComponent);
        }
    }
}

