/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.command.packcore;

import com.github.kd_gaming1.packcore.integration.minecraft.PerformanceProfileService;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class PerformanceCommand {
    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"performance").then(ClientCommandManager.literal((String)"list").executes(PerformanceCommand::listPerformanceProfiles))).then(ClientCommandManager.literal((String)"apply").then(ClientCommandManager.argument((String)"profile", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("performance");
            builder.suggest("balanced");
            builder.suggest("quality");
            builder.suggest("shaders");
            return builder.buildFuture();
        }).executes(PerformanceCommand::applyPerformanceProfile)));
    }

    private static int applyPerformanceProfile(CommandContext<FabricClientCommandSource> context) {
        PerformanceProfileService.PerformanceProfile profile;
        String profileName;
        switch (profileName = StringArgumentType.getString(context, (String)"profile").toLowerCase()) {
            case "performance": {
                profile = PerformanceProfileService.PerformanceProfile.PERFORMANCE;
                break;
            }
            case "balanced": {
                profile = PerformanceProfileService.PerformanceProfile.BALANCED;
                break;
            }
            case "quality": {
                profile = PerformanceProfileService.PerformanceProfile.QUALITY;
                break;
            }
            case "shaders": {
                profile = PerformanceProfileService.PerformanceProfile.SHADERS;
                break;
            }
            default: {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Unknown performance profile: " + profileName)).method_27692(class_124.field_1061));
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available profiles: performance, balanced, quality, shaders").method_27692(class_124.field_1054));
                return 0;
            }
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Applying performance profile: " + profile.getDisplayName() + "...")).method_27692(class_124.field_1054));
        CompletableFuture.runAsync(() -> {
            try {
                PerformanceProfileService.ProfileResult result = PerformanceProfileService.applyPerformanceProfile(profile);
                class_310.method_1551().execute(() -> {
                    if (result.isFullySuccessful()) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u2713 Performance profile '" + profile.getDisplayName() + "' applied successfully!")).method_27692(class_124.field_1060));
                        if (result.isVanillaApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2713 Minecraft settings applied").method_27692(class_124.field_1080));
                        }
                        if (result.isSodiumAvailable() && result.isSodiumApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2713 Sodium settings applied").method_27692(class_124.field_1080));
                        }
                        if (result.isIrisAvailable() && result.isIrisApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2713 Iris/Shader settings applied").method_27692(class_124.field_1080));
                        }
                    } else {
                        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u26a0 Performance profile applied with some issues:").method_27692(class_124.field_1054));
                        if (!result.isVanillaApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"  \u2717 Failed to apply Minecraft settings").method_27692(class_124.field_1061));
                        }
                        if (result.isSodiumAvailable() && !result.isSodiumApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"  \u2717 Failed to apply Sodium settings").method_27692(class_124.field_1061));
                        }
                        if (result.isIrisAvailable() && !result.isIrisApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"  \u2717 Failed to apply Iris/Shader settings").method_27692(class_124.field_1061));
                        }
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u2717 Failed to apply performance profile: " + e.getMessage())).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int listPerformanceProfiles(CommandContext<FabricClientCommandSource> context) {
        PerformanceProfileService.SystemAvailability availability = PerformanceProfileService.getSystemAvailability();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== PackCore Performance Profiles ===").method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Systems:").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2022 Minecraft: \u2713").method_27692(class_124.field_1060));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 Sodium: " + (availability.sodiumAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.sodiumAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 Iris/Shaders: " + (availability.irisAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.irisAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)""));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Profiles:").method_27692(class_124.field_1054));
        for (PerformanceProfileService.PerformanceProfile profile : PerformanceProfileService.PerformanceProfile.values()) {
            String command = "/packcore performance apply " + profile.name().toLowerCase();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 " + profile.getDisplayName() + " - " + profile.getDescription())).method_27692(class_124.field_1068));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("    Command: " + command)).method_27692(class_124.field_1080));
        }
        return 1;
    }
}

