/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.context;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.scamshield.context.PlayerActivity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConversationContext {
    private static final ConversationContext INSTANCE = new ConversationContext();
    private volatile PlayerActivity currentActivity = PlayerActivity.UNKNOWN;
    private volatile String currentLocation = "";
    private final Set<String> recentPartyMembers = ConcurrentHashMap.newKeySet();
    private volatile long activityStartTime = 0L;
    private volatile long lastActivityUpdate = 0L;
    private final Map<String, Map<PlayerActivity, Double>> sensitivityRules = new HashMap<String, Map<PlayerActivity, Double>>();

    private ConversationContext() {
        this.initializeDefaultRules();
    }

    public static ConversationContext getInstance() {
        return INSTANCE;
    }

    private void initializeDefaultRules() {
        HashMap<PlayerActivity, Double> discordVerifyRules = new HashMap<PlayerActivity, Double>();
        discordVerifyRules.put(PlayerActivity.DUNGEON, 1.5);
        discordVerifyRules.put(PlayerActivity.IN_PARTY, 1.3);
        discordVerifyRules.put(PlayerActivity.UNKNOWN, 1.0);
        discordVerifyRules.put(PlayerActivity.LOBBY, 0.8);
        this.sensitivityRules.put("discord_verify_scam", discordVerifyRules);
        HashMap<PlayerActivity, Double> freeRankRules = new HashMap<PlayerActivity, Double>();
        freeRankRules.put(PlayerActivity.LOBBY, 1.2);
        freeRankRules.put(PlayerActivity.UNKNOWN, 1.0);
        this.sensitivityRules.put("free_rank_bait_scam", freeRankRules);
        HashMap<PlayerActivity, Double> phishingRules = new HashMap<PlayerActivity, Double>();
        phishingRules.put(PlayerActivity.DUNGEON, 1.4);
        phishingRules.put(PlayerActivity.IN_PARTY, 1.4);
        phishingRules.put(PlayerActivity.TRADING, 1.3);
        phishingRules.put(PlayerActivity.UNKNOWN, 1.0);
        this.sensitivityRules.put("phishing_sequence_scam", phishingRules);
    }

    public void updateActivity(PlayerActivity activity) {
        if (activity == null) {
            activity = PlayerActivity.UNKNOWN;
        }
        if (this.currentActivity != activity) {
            PackCore.LOGGER.info("[ScamShield] Activity changed: {} \u2192 {}", (Object)this.currentActivity, (Object)activity);
            this.currentActivity = activity;
            this.activityStartTime = System.currentTimeMillis();
        }
        this.lastActivityUpdate = System.currentTimeMillis();
    }

    public void updateLocation(String location) {
        if (location != null && !location.equals(this.currentLocation)) {
            PackCore.LOGGER.info("[ScamShield] Location changed: {} \u2192 {}", (Object)this.currentLocation, (Object)location);
            this.currentLocation = location;
        }
    }

    public void addPartyMember(String playerName) {
        if (playerName != null && !playerName.isEmpty()) {
            this.recentPartyMembers.add(playerName.toLowerCase());
            PackCore.LOGGER.info("[ScamShield] Added party member: {}", (Object)playerName);
        }
    }

    public void removePartyMember(String playerName) {
        if (playerName != null) {
            this.recentPartyMembers.remove(playerName.toLowerCase());
            PackCore.LOGGER.info("[ScamShield] Removed party member: {}", (Object)playerName);
        }
    }

    public void clearPartyMembers() {
        if (!this.recentPartyMembers.isEmpty()) {
            PackCore.LOGGER.info("[ScamShield] Cleared party members");
            this.recentPartyMembers.clear();
        }
    }

    public boolean isInParty(String playerName) {
        if (playerName == null) {
            return false;
        }
        return this.recentPartyMembers.contains(playerName.toLowerCase());
    }

    public double getSensitivityMultiplier(String scamTypeId) {
        Map<PlayerActivity, Double> rules = this.sensitivityRules.get(scamTypeId);
        if (rules == null) {
            return 1.0;
        }
        return rules.getOrDefault((Object)this.currentActivity, 1.0);
    }

    public long getActivityDuration() {
        if (this.activityStartTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.activityStartTime;
    }

    public void reset() {
        PackCore.LOGGER.info("[ScamShield] Context reset");
        this.currentActivity = PlayerActivity.UNKNOWN;
        this.currentLocation = "";
        this.recentPartyMembers.clear();
        this.activityStartTime = 0L;
        this.lastActivityUpdate = 0L;
    }

    public PlayerActivity getCurrentActivity() {
        return this.currentActivity;
    }

    public String getCurrentLocation() {
        return this.currentLocation;
    }

    public Set<String> getRecentPartyMembers() {
        return new HashSet<String>(this.recentPartyMembers);
    }

    public void setSensitivityRule(String scamTypeId, PlayerActivity activity, double multiplier) {
        this.sensitivityRules.computeIfAbsent(scamTypeId, k -> new HashMap()).put(activity, multiplier);
        PackCore.LOGGER.info("[ScamShield] Updated sensitivity rule: {} in {} = {}x", new Object[]{scamTypeId, activity, multiplier});
    }
}

