/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector;

import java.util.regex.Pattern;

public class LegitimateTradeContext {
    private static final Pattern LOWBALLING = Pattern.compile("\\b(lb|lowball\\w*|lbing)\\s*\\d+[mkb]\\b", 2);
    private static final Pattern VISIT_WITH_AMOUNT = Pattern.compile("\\bvisit\\s+(?:me|\\w+).*?\\d+[mkb]\\b", 2);
    private static final Pattern SELLING_BUYING = Pattern.compile("\\b(selling|buying|sold|wtb|wts)\\s+.*?\\d+[mkb]\\b", 2);
    private static final Pattern AUCTION_REF = Pattern.compile("\\b(ah|auction house|bin|bid)\\b", 2);
    private static final Pattern SHOP_REFERENCE = Pattern.compile("\\b(shop|store|minions? for sale|selling minions?)\\b", 2);

    public static boolean isLegitimateTradeAd(String message) {
        if (LOWBALLING.matcher(message).find()) {
            return true;
        }
        if (VISIT_WITH_AMOUNT.matcher(message).find()) {
            return true;
        }
        if (SELLING_BUYING.matcher(message).find()) {
            return true;
        }
        if (AUCTION_REF.matcher(message).find()) {
            return true;
        }
        return SHOP_REFERENCE.matcher(message).find();
    }

    public static double getScoreMultiplier(String message) {
        if (!LegitimateTradeContext.isLegitimateTradeAd(message)) {
            return 1.0;
        }
        if (LOWBALLING.matcher(message).find()) {
            return 0.15;
        }
        if (SELLING_BUYING.matcher(message).find() || VISIT_WITH_AMOUNT.matcher(message).find()) {
            return 0.15;
        }
        return 0.35;
    }
}

