/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.help.guide;

import com.github.kd_gaming1.packcore.ui.help.guide.GuideDetailScreen;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.util.help.guide.GuideInfo;
import com.github.kd_gaming1.packcore.util.help.guide.GuideService;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class GuideListScreen
extends BasePackCoreScreen {
    private FlowLayout guideListContainer;

    public GuideListScreen() {
        this(null);
    }

    public GuideListScreen(class_437 parentScreen) {
        super(parentScreen);
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)"Guides & Help").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofRgb((int)-18355)).shadow(true).margins(Insets.of((int)0, (int)0, (int)4, (int)4));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.expand()).gap(6).padding(Insets.of((int)8));
        mainContent.child(Components.label((class_2561)TextOps.withColor((String)"Welcome to the PackCore Guides & Help! Browse the list of guides, or join the Discord for help.", (int)-1)).horizontalSizing(Sizing.fill((int)100)).margins(Insets.of((int)0, (int)0, (int)2, (int)0)));
        this.guideListContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4);
        mainContent.child(ScreenUIComponents.createScrollContainer(this.guideListContainer));
        this.loadGuides();
        return mainContent;
    }

    private void loadGuides() {
        this.guideListContainer.clearChildren();
        List<GuideInfo> guides = GuideService.loadAvailableGuides();
        if (guides.isEmpty()) {
            this.guideListContainer.child((Component)Components.label((class_2561)TextOps.withColor((String)"No guides found. Place .md files in the packcore/guides folder.", (int)-5195576)));
        } else {
            for (GuideInfo guide : guides) {
                this.guideListContainer.child((Component)this.createGuideEntry(guide));
            }
        }
    }

    private FlowLayout createGuideEntry(GuideInfo guide) {
        FlowLayout entry = ScreenUIComponents.createListEntry();
        String cleanTitle = ScreenUIComponents.stripMarkdown(guide.getTitle());
        LabelComponent titleLabel = Components.label((class_2561)class_2561.method_43470((String)cleanTitle)).color(Color.ofRgb((int)-18355)).shadow(false);
        String cleanPreview = ScreenUIComponents.stripMarkdown(guide.getPreview());
        LabelComponent previewLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)cleanPreview)).color(Color.ofRgb((int)-5195576)).sizing(Sizing.fill((int)100), Sizing.content());
        entry.child((Component)titleLabel);
        entry.child((Component)previewLabel);
        ScreenUIComponents.applyHoverEffects(entry, () -> this.openGuide(guide));
        return entry;
    }

    private void openGuide(GuideInfo guide) {
        if (!guide.isContentLoaded()) {
            GuideService.loadGuideContent(guide);
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)new GuideDetailScreen(guide, (class_437)this));
    }

    public void refresh() {
        this.loadGuides();
    }
}

