/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_colored_chain_conveyor.ponder.highLogistics;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.reggarf.mods.create_colored_chain_conveyor.blocks.colored.CCCCChainConveyorBlock;
import com.reggarf.mods.create_colored_chain_conveyor.registries.CCCCBlocks;
import com.reggarf.mods.create_extra_casing.registry.CECBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import java.util.function.Supplier;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.element.ParrotElementImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ConveyorScenes {
    public static void conveyor(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("chain_conveyor", "Relaying rotational force using Chain Conveyors");
        scene.configureBasePlate(0, 0, 9);
        scene.scaleSceneView(0.75f);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        Selection pole = util.select().fromTo(1, 1, 6, 1, 3, 6);
        Selection cogs = util.select().position(8, 1, 2);
        Selection cogs2 = util.select().fromTo(7, 1, 1, 7, 3, 1);
        BlockPos conv1 = util.grid().at(7, 4, 1);
        BlockPos conv2 = util.grid().at(1, 4, 7);
        BlockPos conv3 = util.grid().at(1, 2, 4);
        BlockPos conv4 = util.grid().at(7, 4, 7);
        ConveyorScenes.connection(builder, conv1, conv2, false);
        ConveyorScenes.connection(builder, conv1, conv3, false);
        ConveyorScenes.connection(builder, conv1, conv4, false);
        Selection conv1S = util.select().position(conv1);
        Selection conv2S = util.select().position(conv2);
        scene.world().setKineticSpeed(conv2S, 0.0f);
        scene.idle(5);
        scene.world().showSection(cogs, Direction.EAST);
        scene.idle(5);
        scene.world().showSection(cogs2, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(conv1S, Direction.DOWN);
        ElementLink poleE = scene.world().showIndependentSection(pole, Direction.DOWN);
        scene.world().moveSection(poleE, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.idle(5);
        scene.world().showSection(conv2S, Direction.DOWN);
        scene.idle(20);
        ItemStack redCasingItem = new ItemStack((ItemLike)((CasingBlock)CECBlocks.RED_CASING.get()).asItem());
        scene.overlay().showControls(util.vector().topOf(conv1), Pointing.DOWN, 60).rightClick().withItem(redCasingItem);
        scene.world().replaceBlocks(util.select().position(conv1), ((CCCCChainConveyorBlock)((Object)CCCCBlocks.RED_ANDESITE_CHAIN_CONVEYOR.get())).defaultBlockState(), false);
        scene.idle(10);
        scene.overlay().showText(60).text("Encasing the chain conveyor with a Extra Casing").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(conv1));
        scene.idle(50);
        scene.overlay().showControls(util.vector().topOf(conv2), Pointing.DOWN, 60).rightClick().withItem(redCasingItem);
        scene.world().replaceBlocks(util.select().position(conv2), ((CCCCChainConveyorBlock)((Object)CCCCBlocks.RED_ANDESITE_CHAIN_CONVEYOR.get())).defaultBlockState(), false);
        scene.idle(10);
        scene.overlay().showText(60).text("You can encase multiple conveyors to match your factory's style").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(conv2));
        scene.idle(50);
    }

    private static void connection(SceneBuilder builder, BlockPos p1, BlockPos p2, boolean connect) {
        builder.world().modifyBlockEntity(p1, ChainConveyorBlockEntity.class, be -> {
            if (connect) {
                be.connections.add(p2.subtract((Vec3i)p1));
            } else {
                be.connections.remove(p2.subtract((Vec3i)p1));
            }
        });
        builder.world().modifyBlockEntity(p2, ChainConveyorBlockEntity.class, be -> {
            if (connect) {
                be.connections.add(p1.subtract((Vec3i)p2));
            } else {
                be.connections.remove(p1.subtract((Vec3i)p2));
            }
        });
    }

    public static class ChainConveyorParrotElement
    extends ParrotElementImpl {
        private ItemEntity wrench;

        public ChainConveyorParrotElement(Vec3 location, Supplier<? extends ParrotPose> pose) {
            super(location, pose);
        }

        protected void renderLast(PonderLevel world, MultiBufferSource buffer, GuiGraphics graphics, float fade, float pt) {
            PoseStack poseStack = graphics.pose();
            EntityRenderDispatcher entityrenderermanager = Minecraft.getInstance().getEntityRenderDispatcher();
            if (this.entity == null) {
                this.entity = this.pose.create(world);
                this.entity.yRotO = 180.0f;
                this.entity.setYRot(180.0f);
            }
            if (this.wrench == null) {
                this.wrench = new ItemEntity((Level)world, 0.0, 0.0, 0.0, AllItems.WRENCH.asStack());
                this.wrench.yRotO = 180.0f;
                this.wrench.setYRot(180.0f);
            }
            double lx = Mth.lerp((double)pt, (double)this.entity.xo, (double)this.entity.getX());
            double ly = Mth.lerp((double)pt, (double)this.entity.yo, (double)this.entity.getY());
            double lz = Mth.lerp((double)pt, (double)this.entity.zo, (double)this.entity.getZ());
            float angle = AngleHelper.angleLerp((double)pt, (double)this.entity.yRotO, (double)this.entity.getYRot());
            poseStack.pushPose();
            poseStack.translate(this.location.x, this.location.y, this.location.z);
            poseStack.translate(lx, ly, lz);
            poseStack.mulPose(Axis.YP.rotationDegrees(angle));
            poseStack.translate(0.0f, 1.5f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(((float)world.scene.getCurrentTime() + pt) * 0.2f)) * 10.0f));
            poseStack.translate(0.0f, -1.5f, 0.0f);
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            poseStack.scale(1.5f, 1.5f, 1.5f);
            poseStack.translate(-0.1, 0.2, -0.6);
            BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(this.wrench.getItem(), (Level)world, (LivingEntity)null, 0);
            Minecraft.getInstance().getItemRenderer().render(this.wrench.getItem(), ItemDisplayContext.GROUND, false, poseStack, buffer, this.lightCoordsFromFade(fade), OverlayTexture.NO_OVERLAY, bakedmodel);
            poseStack.popPose();
            this.entity.flapSpeed = 2.0f;
            entityrenderermanager.render((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, poseStack, buffer, this.lightCoordsFromFade(fade));
            poseStack.popPose();
        }
    }
}

