/*
 * Decompiled with CFR 0.152.
 */
package com.netgoat.netgoat;

import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;

public class Config {
    private final String defaultServer;
    private final Map<String, String> regions;
    private final Map<String, String> hostnames;
    private final PingRouting pingRouting;

    public Config(Path path) throws IOException {
        Toml toml = new Toml().read(path.toFile());
        this.defaultServer = toml.getString("default-server", "lobby");
        this.regions = toml.getTable("regions").toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        this.hostnames = toml.getTable("hostnames").toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        this.pingRouting = new PingRouting(toml.getTable("ping-routing"));
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public Map<String, String> getRegions() {
        return this.regions;
    }

    public Map<String, String> getHostnames() {
        return this.hostnames;
    }

    public PingRouting getPingRouting() {
        return this.pingRouting;
    }

    public static class PingRouting {
        private final long timeout;
        private final String defaultRegion;
        private final long maxPing;

        public PingRouting(Toml toml) {
            this.timeout = toml.getLong("timeout", Long.valueOf(1000L));
            this.defaultRegion = toml.getString("default-region", "us");
            this.maxPing = toml.getLong("max-ping", Long.valueOf(150L));
        }

        public long getTimeout() {
            return this.timeout;
        }

        public String getDefaultRegion() {
            return this.defaultRegion;
        }

        public long getMaxPing() {
            return this.maxPing;
        }
    }
}

