/*
 * Decompiled with CFR 0.152.
 */
package com.netgoat.netgoat;

import com.google.inject.Inject;
import com.netgoat.netgoat.Config;
import com.netgoat.netgoat.PlayerListener;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

@Plugin(id="netgoat", name="NetGoat", version="1.0-SNAPSHOT", description="A plugin to redirect players based on hostname and ping.", authors={"Gemini"})
public class NetGoat {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private Config config;

    @Inject
    public NetGoat(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        if (!this.loadConfig()) {
            return;
        }
        this.server.getEventManager().register((Object)this, (Object)new PlayerListener(this.server, this.logger, this.config));
        this.logger.info("NetGoat plugin has been enabled.");
    }

    private boolean loadConfig() {
        try {
            File configFile;
            if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (!(configFile = new File(this.dataDirectory.toFile(), "config.toml")).exists()) {
                try (InputStream in = this.getClass().getResourceAsStream("/config.toml");){
                    Files.copy(in, configFile.toPath(), new CopyOption[0]);
                }
            }
            this.config = new Config(configFile.toPath());
            return true;
        }
        catch (IOException e) {
            this.logger.error("Error loading configuration", (Throwable)e);
            return false;
        }
    }
}

