/*
 * Decompiled with CFR 0.152.
 */
package com.netgoat.netgoat;

import com.netgoat.netgoat.Config;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class PlayerListener {
    private final ProxyServer server;
    private final Logger logger;
    private final Config config;

    public PlayerListener(ProxyServer server, Logger logger, Config config) {
        this.server = server;
        this.logger = logger;
        this.config = config;
    }

    @Subscribe
    public void onPlayerChooseInitialServer(PlayerChooseInitialServerEvent event) {
        String hostname = event.getPlayer().getVirtualHost().map(host -> host.getHostString()).orElse("");
        if (this.config.getHostnames().containsKey(hostname)) {
            String region = this.config.getHostnames().get(hostname);
            String serverName = this.config.getRegions().get(region);
            if (serverName != null) {
                this.server.getServer(serverName).ifPresent(registeredServer -> {
                    event.setInitialServer(registeredServer);
                    this.logger.info("Redirecting player {} to {} based on hostname {}", new Object[]{event.getPlayer().getUsername(), serverName, hostname});
                });
                return;
            }
        }
        Config.PingRouting pingRouting = this.config.getPingRouting();
        CompletableFuture<Optional> bestServerFuture = CompletableFuture.supplyAsync(() -> this.config.getRegions().values().stream().map(arg_0 -> ((ProxyServer)this.server).getServer(arg_0)).filter(Optional::isPresent).map(Optional::get).map(s -> {
            long start = System.currentTimeMillis();
            return s.ping().thenApply(ping -> new ServerPingResult((RegisteredServer)s, (ServerPing)ping, System.currentTimeMillis() - start));
        }).map(CompletableFuture::join).min(Comparator.comparingLong(r -> r.latency)));
        bestServerFuture.completeOnTimeout(Optional.empty(), pingRouting.getTimeout(), TimeUnit.MILLISECONDS).whenComplete((bestServerResult, throwable) -> {
            RegisteredServer targetServer;
            if (throwable != null) {
                this.logger.error("Error during ping-based redirection", throwable);
            }
            if ((targetServer = bestServerResult.filter(r -> r.latency <= pingRouting.getMaxPing()).map(r -> r.server).orElseGet(() -> this.server.getServer(this.config.getRegions().get(pingRouting.getDefaultRegion())).orElse(this.server.getServer(this.config.getDefaultServer()).orElse(null)))) != null) {
                event.setInitialServer(targetServer);
                this.logger.info("Redirecting player {} to {} based on ping", (Object)event.getPlayer().getUsername(), (Object)targetServer.getServerInfo().getName());
            } else {
                this.logger.warn("Could not find a suitable server for player {}", (Object)event.getPlayer().getUsername());
            }
        });
    }

    private static class ServerPingResult {
        private final RegisteredServer server;
        private final ServerPing ping;
        private final long latency;

        public ServerPingResult(RegisteredServer server, ServerPing ping, long latency) {
            this.server = server;
            this.ping = ping;
            this.latency = latency;
        }
    }
}

