package knowlogy.knowlogy.util;

import knowlogy.knowlogy.Knowlogy;
//? if fabric {
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
//?}
import net.minecraft.class_2561;
import net.minecraft.class_2960;
    
//? if neoforge {
/*import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.Pack;

import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.event.AddPackFindersEvent;
*///?}

public class ResourcePack {
    /*
     * Registers a resource pack on the client and sends out an info message.
     * @param modId the identifier of the mod.
     * @param resourcePackId the identifier of the pack.
     */
    public static void register (
        //? if neoforge
        /*AddPackFindersEvent event,*/
        String modId,
        String resourcePackId,
        boolean defaultEnabled
    ) {
        //? if fabric {
        ResourcePackActivationType activationType = (defaultEnabled) ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL;
        Knowlogy.LOADER.getModContainer(modId).ifPresent(modContainer ->
            ResourceManagerHelper.registerBuiltinResourcePack(
                class_2960.method_60655(modId, resourcePackId),
                modContainer,
                class_2561.method_43471("resourcePack.%s.%s.name".formatted(modId, resourcePackId)),
                activationType
		    )
        );
        //?}

        //? if neoforge {
        /*boolean alwaysActive = defaultEnabled;
        event.addPackFinders(
            ResourceLocation.fromNamespaceAndPath(modId, "resourcepacks/%s".formatted(resourcePackId)),
            PackType.CLIENT_RESOURCES,
            Component.translatable("resourcePack.%s.%s.name".formatted(modId, resourcePackId)),
            PackSource.BUILT_IN,
            alwaysActive,
            Pack.Position.TOP
        );
        *///?}

        Knowlogy.LOGGER.info("Registered {} resource pack!", resourcePackId);
    }

    /*
     * Registers a resource pack on the client and sends out an info message.
     * Will not register the resourcepack if @param targetModId is not present.
     * @param modId the identifier of the mod.
     * @param resourcePackId the identifier of the pack.
     * @param targetModId the identifier of the mod required for the pack.
     */
    public static void register (
        //? if neoforge
        /*AddPackFindersEvent event,*/
        String modId,
        String resourcePackId,
        String targetModId
    ) {
        if (
            //? if fabric
            !Knowlogy.LOADER.isModLoaded(targetModId)
            //? if neoforge
            /*FMLLoader.getLoadingModList().getModFileById(targetModId) != null*/
        ) {
            Knowlogy.LOGGER.info("Not registering {} resource pack, {} not present.", resourcePackId, targetModId);
            return;
        }

        Knowlogy.LOGGER.info("Registering {} resource pack for {}.", resourcePackId, targetModId);

        register (
            //? if neoforge
            /*event,*/
            modId,
            resourcePackId,
            true
        );
    }
}
