```json
{
  "title": "Decorated Pot",
  "icon": "minecraft:decorated_pot",
  "categories": [
    "minecraft:blocks",
    "minecraft:group/functional_blocks",
    "minecraft:group/redstone_blocks"
  ],
  "associated_items": [
    "minecraft:decorated_pot"
  ]
}
```

&spotlight(minecraft:decorated_pot)
A **decorated pot** is a storage block crafted from bricks and/or [pottery sherds](^minecraft:tag/decorated_pot_sherds), with the items used individually affecting the appearance of its four side faces.

;;;;;

![Decorated Pot in Trial Chambers](minecraft:textures/gui/image/decorated_pot_in_trial_chambers.png,fit)

A decorated pot in [trial chambers](^minecraft:trial_chambers) and a skeleton [monster room](^minecraft:monster_room) behind.

;;;;;

&title(Breaking)
Decorated pots can be broken with any [tool](^minecraft:tool) and are mined instantly. A decorated pot drops the four [pottery sherds](^minecraft:tag/decorated_pot_sherds) or bricks used to craft it when mined with a pickaxe, axe, shovel, hoe or sword not enchanted with Silk Touch. It drops itself when mined with anything else, including tools listed above enchanted with Silk Touch. In either case, the tool does not lose durability.

;;;;;

&title(Crafting)
The decorated pot's side textures correspond to the item used in the [crafting](^minecraft:crafting). If a [pottery sherd](^minecraft:tag/decorated_pot_sherds) is used, that side bears the texture of that pottery sherd, if a brick is used, that side bears the default texture.

;;;;;

&title(Natural Generation)
Decorated pots naturally generate in [trial chambers](^minecraft:trial_chambers), with loot inside. Decorated pots in the trial chambers are composed of either four bricks or three bricks and either one [flow](^minecraft:flow_pottery_sherd), [guster](^minecraft:guster_pottery_sherd), or [scrape pottery sherd](^minecraft:scrape_pottery_sherd).

;;;;;

&title(Storage)
A decorated pot can store up to a stack of a single type of item. Unlike other containers, decorated pots have no GUI; items are inserted by interacting with the pot or by using droppers or hoppers. The only way to retrieve stored items is by breaking the pot or by using hoppers and minecarts with hopper.

;;;;;

&title(Redstone)
A redstone comparator can be used to measure the number of stored items.
