```json
{
  "title": "Ominous Vault",
  "icon": "minecraft:vault[minecraft:block_state={ominous:\"true\"}]",
  "categories": [
    "minecraft:blocks",
    "minecraft:group/functional_blocks"
  ]
}
```

<block;minecraft:vault[ominous=true,vault_state=active]>

An **ominous vault** is a variant of the [vault](^minecraft:vault) found in [trial chambers](^minecraft:trial_chambers). It dispenses valuable loot when unlocked using an [ominous trial key](^minecraft:ominous_trial_key).

;;;;;

&title(Obtaining)

Ominous vaults cannot be obtained in [Survival](https://minecraft.wiki/w/Survival), even with [Silk Touch](https://minecraft.wiki/w/Silk_Touch), and can not be moved with a [piston](https://minecraft.wiki/w/Piston).

;;;;;

&title(Breaking)
An ominous vault can be broken but it does not drop itself as an item and takes a long time to break.

Due to their high blast resistance, ominous vaults are immune to [explosions](https://minecraft.wiki/w/Explosion), but can still be destroyed by the [wither](https://minecraft.wiki/w/Wither)'s block-breaking attack and blue wither skulls. 

;;;;;

&title(Natural generation)
Ominous vaults can be found throughout [trial chamber](^minecraft:trial_chambers)s. Unlike [ominous trial spawners](^minecraft:ominous_trial_spawner), ominous vaults don't replace normal vaults when a player with the [Trial Omen](^minecraft:trial_omen) effect is nearby.

;;;;;

&title(Natural generation)
An ominous vault can be distinguished from a normal vault by its texture and location in harder to find places. An ominous vault is always surrounded by an altar-like structure that contains red [candles](^minecraft:candle) and [red glazed terracotta](https://minecraft.wiki/w/Red_glazed_terracotta).

;;;;;

&title(Usage)
A [player](https://minecraft.wiki/w/Player) can unlock an ominous vault using an [ominous trial key](^minecraft:ominous_trial_key). Each player can only unlock each ominous vault once.

Like the normal [vault](^minecraft:vault), the ominous vault has 3 loot tables.

;;;;;

&title(Loot)
The ominous vault ejects 2 to 5 stacks of loot, like the vault, but the ominous vault's loot is significantly better.

The ominous vault ejects a combination of loot from three different loot tables. The following information describes the loot ejected for a single player when a single ominous trial key is used. 
