```json
{
  "title": "Conduit",
  "icon": "minecraft:conduit",
  "categories": [
    "minecraft:blocks",
    "minecraft:group/functional_blocks"
  ],
  "associated_items": [
    "minecraft:conduit"
  ]
}
```

&spotlight(minecraft:conduit)
A **conduit** is a [beacon](https://minecraft.wiki/w/Beacon)-like block that provides [Conduit Power](https://minecraft.wiki/w/Conduit_Power) effect and attacks [monsters](https://minecraft.wiki/w/Monsters) underwater.

;;;;;

![Activated Conduit](minecraft:textures/gui/image/conduit_activated.png,fit)

Closer look at the activated conduit.

;;;;;

&title(Breaking)

A conduit drops as an [item](^minecraft:items) when [broken](^minecraft:breaking) with any [tool](^minecraft:tool) or by hand, but a [pickaxe](^minecraft:tag/pickaxes) is the fastest way to break it.


Like other precious blocks such as [beacons](https://minecraft.wiki/w/Beacon) and [shulker boxes](https://minecraft.wiki/w/Shulker_box), when destroyed by an [explosion](https://minecraft.wiki/w/Explosion), a conduit always drops as an item. 

;;;;;

&title(Crafting)

<recipe;minecraft:conduit>

;;;;;

&title(Conduit Power)
When activated, conduits give the "[Conduit Power](https://minecraft.wiki/w/Conduit_Power)" effect to all [players](https://minecraft.wiki/w/Player) in contact with [rain](https://minecraft.wiki/w/Rain) or [water](https://minecraft.wiki/w/Water), within a spherical range of 32-96 blocks. This effect restores oxygen, gives underwater night vision and increases mining speed by 16.7% (1/6th). Conduits also damage any hostile mobs, like [drowned](https://minecraft.wiki/w/Drowned), [guardians](https://minecraft.wiki/w/Guardians), and [elder guardians](https://minecraft.wiki/w/Elder_guardian), within a range of 8 blocks of the conduit.

;;;;;

<structure;minecraft:conduit_activation_frame>

Valid block placements for conduit activation; note that the conduit itself must also be surrounded by water.

;;;;;

&title(Conduit Power)
To activate, a conduit needs to be in the center of a 3×3×3 volume of [water](https://minecraft.wiki/w/Water), which must be enclosed within an activation frame. The frame can be built out of blocks in three 5×5 open squares centered on the conduit, one around each axis.

Only [prismarine](https://minecraft.wiki/w/Prismarine), [dark prismarine](https://minecraft.wiki/w/Dark_prismarine), [prismarine bricks](https://minecraft.wiki/w/Prismarine_bricks), and [sea lantern](https://minecraft.wiki/w/Sea_lantern) blocks in the frame contribute to activation.

;;;;;

A minimum of 16 [blocks](^minecraft:blocks) are required and produce an effective range of 32 blocks. Prismarine-type [slabs](^minecraft:tag/slabs) (including double slabs), [stairs](https://minecraft.wiki/w/Stairs), and [walls](https://minecraft.wiki/w/Walls) cannot be used to activate the conduit. Any blocks (of any type) that are not part of the activation frame itself but are in the 5×5×5 outer shell likewise have no effect. Once activated, removing any blocks away from the conduit (frame blocks) deactivates the conduit.

;;;;;

![Placement for 16 blocks](minecraft:textures/gui/image/conduit_block_placement_for_16_blocks.png,fit)

Basic arrangements of 16 [prismarine bricks](https://minecraft.wiki/w/Prismarine) to activate a conduit.

;;;;;

![Placement for greater range](minecraft:textures/gui/image/conduit_block_placement_for_greater_range.png,fit)

Adding additional [blocks](^minecraft:blocks) around a conduit can extend the range of effect.