```json
{
  "title": "Smelting",
  "icon_sprite": "minecraft:icon/furnace",
  "category": "minecraft:story/story",
  "required_advancements": [
    "minecraft:story/mine_stone"
  ]
}
```

**Smelting** is a method of obtaining refined goods from raw materials by heating in a [{block}furnace{}](^minecraft:furnace), [{block}blast furnace{}](https://minecraft.wiki/w/Blast_furnace), [{block}smoker{}](https://minecraft.wiki/w/Smoker) or [{block}campfire{}](https://minecraft.wiki/w/Campfire). For example, raw iron can be smelted to produce iron ingots using coal as fuel. Like [crafting](^minecraft:crafting), smelting uses recipes to determine what item is produced, but its recipes are simpler. Smelting also yields [experience](https://minecraft.wiki/w/Experience). 

;;;;;

The furnace burns one fuel item at a time. Different fuels will fuel the furnace for different amounts of time, and the item in the top will take different amounts of time depending on whether you use a smoker, blast furnace or furnace. The fuel gauge indicates how much of that fuel's burn time remains. As each fuel item is fully consumed, another one is taken from the fuel slot and the gauge starts over. 

;;;;;

Smeltable input items are also processed one at a time but are not removed from the input slot while smelting is in progress. The arrow indicates how much of the smelting process has been completed. When the arrow is full, the input item is removed from the input stack and an output item is added to the output stack. Smelting of the next input item then begins immediately. 

;;;;;

&title(See Also)

```xml owo-ui
<flow-layout direction="vertical">
    <children>
        <flow-layout direction="horizontal">
            <children>
                <item>
                    <stack>minecraft:furnace</stack>
                    <set-tooltip-from-stack>true</set-tooltip-from-stack>
                </item>
                <item>
                    <stack>minecraft:blast_furnace</stack>
                    <set-tooltip-from-stack>true</set-tooltip-from-stack>
                </item>
                <item>
                    <stack>minecraft:smoker</stack>
                    <set-tooltip-from-stack>true</set-tooltip-from-stack>
                </item>
                <item>
                    <stack>minecraft:campfire</stack>
                    <set-tooltip-from-stack>true</set-tooltip-from-stack>
                </item>
            </children>
            <gap>10</gap>
            <vertical-alignment>center</vertical-alignment>
        </flow-layout>
    </children>
    <gap>8</gap>
    <sizing>
        <horizontal method="fill">100</horizontal>
    </sizing>
    <horizontal-alignment>center</horizontal-alignment>
</flow-layout>
```
