/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader;

import com.github.litermc.vschunkloader.attachment.AmmoShipAttachment;
import com.github.litermc.vschunkloader.attachment.ForceLoadAttachment;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vschunkloader.config.FreezeMode;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class VSCApi {
    private static final VSCApi INSTANCE = new VSCApi();
    public static final String REUSABLE_SHIP_SLUG_PREFIX = "+reuse+";

    private VSCApi() {
    }

    public static VSCApi get() {
        return INSTANCE;
    }

    public static boolean forceLoad(MinecraftServer server, long id, class_2960 token, boolean load) {
        ServerShip ship = VSCApi.getShip(server, id);
        if (ship == null) {
            return false;
        }
        ForceLoadAttachment attachment = ForceLoadAttachment.get(ship);
        if (load) {
            attachment.addForceLoad(token);
        } else {
            attachment.removeForceLoad(token);
        }
        return true;
    }

    public static boolean clearForceLoadTokens(MinecraftServer server, long id) {
        ServerShip ship = VSCApi.getShip(server, id);
        if (ship == null) {
            return false;
        }
        ForceLoadAttachment attachment = ForceLoadAttachment.get(ship);
        attachment.removeAllForceLoadTokens();
        return true;
    }

    public static Set<class_2960> getForceLoadTokens(MinecraftServer server, long id) {
        ServerShip ship = VSCApi.getShip(server, id);
        if (ship == null) {
            return null;
        }
        ForceLoadAttachment attachment = ForceLoadAttachment.get(ship);
        return attachment.getAllForceLoadTokens();
    }

    public static boolean isForceLoaded(MinecraftServer server, long id) {
        ServerShip ship = VSCApi.getShip(server, id);
        if (ship == null) {
            return false;
        }
        return ForceLoadAttachment.get(ship).isForceLoaded();
    }

    public static boolean isForceLoadedBy(MinecraftServer server, long id, class_2960 token) {
        ServerShip ship = VSCApi.getShip(server, id);
        if (ship == null) {
            return false;
        }
        return ForceLoadAttachment.get(ship).isForceLoadedBy(token);
    }

    public static boolean canFreezeShipForChunkLoad(ServerShip ship) {
        return switch (Config.shipFreezing) {
            default -> throw new IncompatibleClassChangeError();
            case FreezeMode.ALL -> true;
            case FreezeMode.NONE -> false;
            case FreezeMode.AMMO -> ship.getAttachment(AmmoShipAttachment.class) != null;
        };
    }

    private static ServerShip getShip(MinecraftServer server, long id) {
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server);
        ServerShip ship = (ServerShip)shipWorld.getLoadedShips().getById(id);
        if (ship != null) {
            return ship;
        }
        return (ServerShip)shipWorld.getAllShips().getById(id);
    }
}

