/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader;

import com.github.litermc.vschunkloader.VSCApi;
import com.github.litermc.vschunkloader.attachment.ChunkSensorAttachment;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vschunkloader.util.ChunkLoaderManager;
import com.github.litermc.vschunkloader.util.TaskUtil;
import com.github.litermc.vtil.util.LevelUtil;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class VSCListeners {
    private VSCListeners() {
    }

    public static void onServerLevelLoad(class_3218 level) {
        ChunkLoaderManager.get(level);
    }

    public static void onServerLevelUnload(class_3218 level) {
    }

    public static void preServerTick(MinecraftServer server) {
        TaskUtil.preServerTick();
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server);
        for (ServerShip ship : shipWorld.getAllShips()) {
            String slug;
            if (!Config.forceLoadAllShips ? !VSCApi.isForceLoaded(server, ship.getId()) : (slug = ship.getSlug()) != null && slug.startsWith("+reuse+")) continue;
            class_3218 level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
            if (level == null) continue;
            ChunkLoaderManager.get(level).refreshForcedShip(ship);
        }
        for (ServerShip ship : shipWorld.getLoadedShips()) {
            ChunkSensorAttachment.get(ship).serverTick((LoadedServerShip)ship);
        }
    }

    public static void postServerTick(MinecraftServer server) {
        TaskUtil.postServerTick();
    }

    public static void onServerChunkLoad(class_3218 level, class_2818 chunk) {
    }

    public static void onServerChunkUnload(class_3218 level, class_2818 chunk) {
    }
}

