/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.attachment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.github.litermc.vschunkloader.VSCApi;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.util.TaskUtil;
import com.github.litermc.vtil.api.assemble.ShipAllocator;
import com.github.litermc.vtil.util.LevelUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class AmmoShipAttachment
implements ServerTickListener {
    private static final class_2960 AMMO_SHIP_TICKET = new class_2960("vschunkloader", "ammo_ship");
    private final MinecraftServer server = PlatformHelper.get().getCurrentServer();
    private final ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)this.server);
    private long shipId;
    private int activatedTick;
    private boolean unmanaged = false;
    private boolean deactivated = false;

    public AmmoShipAttachment() {
        this(-1L);
    }

    private AmmoShipAttachment(long shipId) {
        this.shipId = shipId;
    }

    public static AmmoShipAttachment create(ServerShip ship) {
        AmmoShipAttachment attachment = new AmmoShipAttachment(ship.getId());
        ship.saveAttachment(AmmoShipAttachment.class, (Object)attachment);
        return attachment;
    }

    @JsonGetter(value="shipId")
    private long getShipId() {
        return this.shipId;
    }

    @JsonSetter(value="shipId")
    private void setShipId(long shipId) {
        this.shipId = shipId;
    }

    @JsonGetter(value="activatedTick")
    private long getActivatedTick() {
        return this.activatedTick;
    }

    @JsonSetter(value="activatedTick")
    private void setActivatedTick(int activatedTick) {
        this.activatedTick = activatedTick;
    }

    public void onServerTick() {
        if (this.activatedTick == 0) {
            this.checkActivate();
            return;
        }
        if (this.activatedTick > Config.ammoMaxActivateSeconds * 20) {
            if (!this.deactivated) {
                this.deactivated = true;
                this.deactivate();
            }
            return;
        }
        ++this.activatedTick;
    }

    public void managerTick() {
        this.unmanaged = false;
    }

    private ServerShip getShip() {
        ServerShip ship = (ServerShip)this.world.getLoadedShips().getById(this.shipId);
        if (ship != null) {
            return ship;
        }
        return (ServerShip)this.world.getAllShips().getById(this.shipId);
    }

    private void checkActivate() {
        if (this.unmanaged) {
            this.activate();
            return;
        }
        this.unmanaged = true;
    }

    private void activate() {
        this.activatedTick = 1;
        VSCApi.forceLoad(this.server, this.shipId, AMMO_SHIP_TICKET, true);
    }

    private void deactivate() {
        VSCApi.forceLoad(this.server, this.shipId, AMMO_SHIP_TICKET, false);
        if (!Config.removeAmmoAfterExpired) {
            return;
        }
        ServerShip ship = this.getShip();
        if (ship == null) {
            return;
        }
        class_3218 level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
        if (level == null) {
            this.world.deleteShip(ship);
            return;
        }
        TaskUtil.queueTickStart(() -> ShipAllocator.get((MinecraftServer)level.method_8503()).putShip(ship));
    }
}

